;************************************************************************
;***********************       S R D . C M D        *********************
;************************************************************************
.GOTO BEGIN
;
;	S R D . C M D	V6.1	01-Dec-80
;
;	This command file was created along with version 6.0
;	of SRD. It is intended for use with ...AT., and seems
;	to work under IAS V3.0, and RSX-11M V3.1 and 3.2.
;
;	This command file will create the necessary files to build
;	SRD, and optionally assemble and task-build.
;
;	TO BUILD SRD FOR THE FOLLOWING SYSTEMS:
;
;	R$$11M	--	RSX-11M MAPPED
;	R$$11U	--	RSX-11M UNMAPPED
;	R$$11D	--	RSX-11D
;	I$$AS	--	IAS V3.0
;
;
;   MODIFICATIONS:
;
;	01-DEC-81  -  Bob Turkelson
;		Correct problem with wrong switch settings when <ESCAPE>
;		used to display help;
;		Move /00 default value to 3rd switch initialization word;
;		Remove some references to SYSLIB when building with FCSRES
;
;
.BEGIN:	.DISABLE	LOWERCASE
	.SETT	MAC
	.SETT	TKB
	.SETT	SRD
	.IFNINS ...MAC .SETF MAC
	.IFNINS ...TKB .SETF TKB
	.IFNINS ...SRD .SETF SRD
	.IFF MAC INS $BIGMAC/CKP=YES
	.IFF TKB INS $BIGTKB/CKP=YES
	.IFF SRD INS $SRD
	.SETF	R$$11M
	.SETF	R$$11U
	.SETF	D$$CAL
	.SETF	F$$CS
	.SETF	R$$11D
	.SETF	I$$AS
	.SETF R$$MPL
	.SETF R$SUPL
	.SETT	E$$IS
	.ENABLE	SUBSTITUTION
	.ENABLE	ESCAPE
	.SETS	END	".END"
.; We have to do this to stop AT. getting upset
;
;	Question/Answer phase
;	
;	To get help hit ESCAPE from any prompt.
;
.0005:	.ASK	SKIP	Have you already created SRDSYS.MAC
	.IFF	<ESCAPE>	.GOTO 0010
;
;	SRDSYS.MAC is a special prefix file that contains
;	definitions of the type of system you are running
;	on (e.g. RSX-11D).  It is created by this command
;	file, so if this is the first time you  have  run
;	this the answer is probably NO.
;
	.GOTO	0005
.0010:	.SETT	PROCED
	.IFT SKIP .GOTO 0440
	.ASK	SYSTEM	Are you using RSX-11M, MAPPED or RSX11M+
	.IFF	<ESCAPE>	.GOTO	0020
;
;	If you are using RSX-11M V3.0 or later, and you
;	are using the MAPPED system, answer yes to this
;	question.
;
	.GOTO	0010
;
.0020:	.IFF	SYSTEM	.GOTO 0100
	.ASK R$$MPL Are you using RSX11M+
	.IFT R$$MPL .ASK R$SUPL Supervisor Mode Supported
	.SETT	R$$11M
	.SETS	OPTNS	"/MM"
	.IFT R$$MPL .SETS OPTNS ""
	.SETS	SY$TEM	"RSX-11M Mapped"
.0030:
	.ASK	D$$CAL	Are you using dynamic checkpoint allocation
	.IFF	<ESCAPE>	.GOTO	0040
;
;	If your system is generated with dynamic checkpoint
;	allocation, and you want SRD to take advantage of
;	it, answer yes to the following question.
;
	.GOTO	0030
;
.0040:	.ASK	F$$CS	Are you using FCSRES
	.IFF	<ESCAPE>	.GOTO	0050
;
;	If you have built FCSRES on your system, it will be
;	used by SRD, thus decreasing the total size of SRD
;	by approximately 3 k-words.
;
	.GOTO	0040
;
.0050:	.ASK	E$$IS	Does your machine have EIS
	.IFF	<ESCAPE>	.GOTO	0410
;
;	EIS stands for the Extended Instruction Set. This question
;	is asked so that the SOB instruction can be correctly
;	simulated on a non-EIS machine. (E.G. 11-03,11-40, etc)
;
	.GOTO	0050
;
.0100:	.ASK	SYSTEM	Are you using RSX-11M, UNMAPPED
	.IFF	<ESCAPE>	.GOTO	0110
;
;	If you are using RSX-11M UNMAPPED, answer yes
;	to the following question. This merely tells the
;	taskbuilder to build the task with the /-MM switch.
;
	.GOTO	0100
;
.0110:	.IFF	SYSTEM	.GOTO 0200
	.SETT	R$$11U
	.SETS	OPTNS	"/-MM"
	.SETS	SY$TEM	"RSX-11M Unmapped"
;
.0150:	.ASK	E$$IS	Does your machine have EIS
	.IFF	<ESCAPE>	.GOTO	0410
;
;	EIS stands for the Extended Instruction Set. This question
;	is asked so that the SOB instruction can be correctly
;	simulated on a non-EIS machine. (E.G. 11-03,11-40, etc)
;
	.GOTO	0150
;
.0200:	.ASK	SYSTEM	Are you using RSX-11D
	.IFF	<ESCAPE>	.GOTO	0210
;
;	If you are using RSX-11D V6.2 or before, then answer yes to
;	the following question. Note that this will produce
;	the exact same SRD as for IAS, except that the naming
;	conventions will be different.
;
	.GOTO	0200
;
.0210:	.IFF	SYSTEM  .GOTO 0300
	.SETS	OPTNS	"/MU"
	.SETT	R$$11D
	.SETS	SY$TEM	"RSX-11D"
	.GOTO	0410
;
.0300:	.ASK	SYSTEM	Are you using IAS
	.IFF	<ESCAPE>	.GOTO	0310
;
;	If you are using any of the three flavors of IAS V3.0 or
;	IAS V2.0, answer yes to the following question. Note that
;	in the task-build command file, that SYSRES is used as the
;	default system library.
;
	.GOTO	0300
;
.0310:	.IFF	SYSTEM  .GOTO BEGIN
	.SETS	OPTNS	"/MU"
	.SETT	I$$AS
	.SETS	SY$TEM	"IAS"
	.GOTO	0410
;
.0410:	.ASKN	[1024.:24576.:8192.] EXTEND	Enter task extension
	.IFF	<ESCAPE>	.GOTO	0420
;
;	The task extension defines the buffer area used by SRD to
;	read the directory file into. The task extension must be 
;	specified in units of 256. word blocks. A good means of
;	determining the size needed is to look at the [0,0] directory
;	for the largest directory file, and have this extension large
;	enough to handle it. The smallest extension(1024.) will handle
;	directories up to 4. blocks long, where the largest extension
;	(24576.) will handle directories up to 98. blocks long. The
;	default extension will handle directories up to 32. blocks long.
;
	.GOTO 0410
;
.0420:;
;	Creating Switch Defaults
;
	.SETN	SWINI 0
	.SETN	SW2INI 0
	.SETN	SW3INI 0
.1420:	.ASK	X	Do you want the sort to be in name order
	.IFF	<ESCAPE>	.GOTO	1421
;
;	If you answer Y, the default sort order will be
;		Name, Extension, Version
;	If you answer N, the default sort order will be
;		Extension, Name, Version
;
	.GOTO	1420
.1421:	.IFT	X	.SETN SWINI SWINI+100000
	.ASK	X	Do you want the directory to be listed by default
	.IFF	<ESCAPE>	.GOTO	1422
	.SETF	X
;
;	If you answer Y to this question, an implicit /LI will
;	be included in every SRD operation.  If you answer no,
;	no files will be listed unless you use an explicit
;	/LI, /FU or /MI.
;
	.GOTO	1421
.1422:	.IFT	X	.SETN	SWINI	SWINI+2
	.ASK	X	Do you want to use the Revision Date in Date Matches
	.IFF	<ESCAPE>	.GOTO	1423
	.SETF	X
;
;	If you answer Y to this question then, by default, the 
;	Revision Date will be included in all matches including
;	a date (/DA, /AF, /AE, /BF, /BE).
;	If you answer N the Creation Date will be used.
;
	.GOTO	1422
.1423:	.IFT	X	.SETN	SW2INI	SW2INI+40
	.ASK	X	Do you want the directory sorted by default
	.IFF	<ESCAPE>	.GOTO	1424
	.SETF	X
;
;	If you answer Y to this question any directory listings you
;	request will automatically be sorted (unless you specify /-SR).
;	If you answer N the directory will only be sorted if you specify
;	/SR.
;
	.GOTO	1423
.1424:	.IFT	X	.SETN	SW2INI	SW2INI+100
	.ASK	X	Do you want System Accounts in [*,*] searches
	.IFF	<ESCAPE>	.GOTO	1425
	.SETF	X
;
;	If you answer Y to this question any directory listings in
;	which the group part of the UIC is wild (*) will include
;	System Accounts (those with a group code of 0-10).
;	If you answer N such accounts will be excluded by default.
;
	.GOTO	1424
.1425:	.IFT	X	.SETN	SW2INI	SW2INI+400
	.ASK	X	Do you want to include [0,0] in [*,*] searches
	.IFF	<ESCAPE>	.GOTO	1426
	.SETF	X
;
;	If you answer Y to this question any directory listings in
;	which the group part of the UIC is wild (*) will include
;	the Master File Directory ([0,0]).
;	If you answer N the MFD will be excluded by default.
;
	.GOTO	1425
.1426:	.IFT	X	.SETN	SW3INI	SW3INI+1
	.ASK	X	Do you want output device attached if terminal
	.IFF	<ESCAPE>	.GOTO	1427
	.SETF	X
;
;	If you answer Y to this question then, by default, the
;	output device, if it is a terminal, will be attached.
;	If you answer N it will not be attached.
;
	.GOTO	1426
.1427:	.IFT	X	.SETN	SW2INI	SW2INI+1000
	.ASK	X	Do you want implicit wildcarding
	.IFF	<ESCAPE>	.GOTO	1428
	.SETF	X
;
;	If you answer Y to this question then, by default, all
;	file specifications you enter will be treated as if they
;	were terminated by an *.
;	If you answer N to this question then this 'implicit
;	wildcarding' is disabled.
;
	.GOTO	1427
.1428:	.IFT	X	.SETN	SW2INI	SW2INI+20000
	.ASK	X	Do you want implicit wildcarding during delete
	.IFF	<ESCAPE>	.GOTO	1429
	.SETF	X
;
;	If you answer Y to this question then, by default, if /WI
;	is specified, explicitly or implictly, then all
;	file specifications you enter will be treated as if they
;	were terminated by an *. even during a delete operation.
;	If you answer N to this question then this 'implicit
;	wildcarding during delete' is disabled.
;
	.GOTO	1428
.1429:	.IFT	X	.SETN	SW2INI	SW2INI+10000
	.ASK	X	Do you want the Type 2 Middle Size Listing
	.IFF	<ESCAPE>	.GOTO	1430
	.SETF	X
;
;	If you answer Y to this question then, by default, specifying
;	the /MI switch for a Middle Size listing will list out:-
;
;		Filename  Filesize  Creation Date/Time  File ID
;
;	If you answer N to this question it will list out:-
;
;		Filename  Creation Date/Time  Revision Date/Time
;
	.GOTO	1429
.1430:	.IFT	X	.SETN	SW2INI	SW2INI+100000
	.ASK	PROCED	Q/A complete, do you want to continue
	.IFF	<ESCAPE>	.GOTO	0422
	.SETF	X
;
;	If you answer Y, then the command files to build SRD will
;	be created. If you answer N, then this command file will
;	exit without generating anything but a passing memory.
;
	.GOTO	0420
;
.0422:	.IFF	PROCED	.GOTO END
;	Creating SRD.BLD
	.OPEN	SRD.BLD
	.ENABLE	DATA
;
;	SRD.BLD - Task Build file for an 'SY$TEM' system
;
SRD'OPTNS'/-FP/CP,SRD/-SP/MA=SRD/MP
;
TSKV	=SSTVC$:7
STACK	=128
.DISABLE DATA
.IFT R$SUPL .DATA SUPLIB=FCSFSL:SV
.ENABLE DATA
ASG	=TI:1
ASG	=SY:2:3
ASG	=TI:4
UNITS	=4
GBLDEF	=..RWLG:1
GBLDEF	=SWINI:'SWINI'
;	SWINI defines the initial switch settings of the first mask:-
;	       2 = /LI - List the directory
;	  100000 = /NA - Sort by Name first
GBLDEF	=SW2INI:'SW2INI'
;	SW2INI defines the initial switch settings of the second mask:-
;	      40 = /RD - Use Revision Date for date checks
;	     100 = /SR - Sort the directory
;	     400 = /SY - Include system accounts in [*,*]
;	    1000 = /AT - Attach output device if terminal
;	   10000 = /WI - Implicit wildcarding
;	   20000 = /WD - Implicit wildcarding in delete
;	  100000 = /M2 - Type 2 Middle Size Listing
GBLDEF	=SW3INI:'SW3INI'
;	SW3INI defines the initial switch settings of the third mask:-
;	       1 = /00 - Include [0,0] in [*,*]
.DISABLE	DATA
	.IFT	I$$AS .OR  .IFT R$$11D .DATA LIBR	=SYSRES:RO
	.IFT	I$$AS	.DATA TASK	=$$$SRD
	.IFT	R$$11D .OR .IFT R$$11M .DATA TASK	=...SRD
	.IFT	F$$CS	.DATA LIBR	=FCSRES:RO
.ENABLE	DATA
EXTTSK	='EXTEND'
/
.DISABLE	DATA
.CLOSE
;	Creating SRD.ODL
	.OPEN	SRD.ODL
	.ENABLE	DATA
;
;		SRD.ODL
;
;	** SRD OVERLAY DESCRIPTION **
;	For an 'SY$TEM' system.
;
; UPDATED	01-Dec-81
;
	.NAME	OV1INI
	.NAME	OPNFNB
	.NAME	CSI12
	.ROOT	SRDR-*(O1,O2A,O2B,O2C,O4,O5)
SRDR:	.FCTR	SRDROT-SRDATA-SRDSUB-SRDTRP-LIBR
.DISABLE	DATA
	.IFT R$SUPL .GOTO 0540
	.IFT	F$$CS	.GOTO 0540
	.ENABLE	DATA
LIBR:	.FCTR	LB:[1,1]SYSLIB/LB:ASSLUN:ARITH:CBTA:DIRECT:DEL:EOFCHK-LIBR2
LIBR2:	.FCTR	LB:[1,1]SYSLIB/LB:MKDL:MOVREC:PGCS:RDWAIT:RETADR:WATSET
.DISABLE	DATA
	.GOTO	0580
.0540:	.ENABLE	DATA
LIBR:	.FCTR	LB:[1,1]SYSLIB/LB:CBTA:EOFCHK-LIBR2
LIBR2:	.FCTR	LB:[1,1]SYSLIB/LB:MOVREC:PGCS:RDWAIT:RETADR:WATSET
.DISABLE	DATA
.0580:	.ENABLE	DATA
O1:	.FCTR	SRDINI-SRDREP-*(O11)
O2A:	.FCTR	SRDNUD
O2B:	.FCTR	SRDOPR-SRDXX1
O2C:	.FCTR	SRDSRT-SRDXX2
O5:	.FCTR	SRDDBF
.DISABLE	DATA
.0580:	.IFF	R$$11D .AND .IFF I$$AS .GOTO 0600
	.ENABLE	DATA
O4:	.FCTR	SRDLST-SRDTST-SRDXX3
O11:	.FCTR	OV1INI-*(OP1,CSI1)
OP1:	.FCTR	OPNFNB-LB:[1,1]SYSLIB/LB:PRINT
.DISABLE	DATA
	.GOTO	0700
.0600:	.IFT	F$$CS	.GOTO 0640
	.ENABLE	DATA
O4:	.FCTR	SRDLST-SRDTST-LB:[1,1]SYSLIB/LB:PUTSQ-SRDXX3
O11:	.FCTR	OV1INI-*(OP1,PRS1,CSI1)
OP1:	.FCTR	OPNFNB-LB:[1,1]SYSLIB/LB:OPFNB:$PRINT
	.NAME	PRSFNB
PRS1:	.FCTR	PRSFNB-LB:[1,1]SYSLIB/LB:PARSE
.DISABLE	DATA
	.GOTO	0700
.0640:	.ENABLE	DATA
O4:	.FCTR	SRDLST-SRDTST-SRDXX3
O11:	.FCTR	OV1INI-*(OP1,PRS1,CSI1)
OP1:	.FCTR	OPNFNB
	.NAME	PRSFNB
PRS1:	.FCTR	PRSFNB
.DISABLE	DATA
.0700:	.ENABLE	DATA
CSI1:	.FCTR	CSI12-LB:[1,1]SYSLIB/LB:.CSI1:.CSI2
	'END'
.DISABLE	DATA
	.CLOSE
;	Creating SRDSYS.MAC
	.OPEN	SRDSYS.MAC
	.ENABLE	DATA
;
;	VERSION 6 OF SRD
;
	.NLIST
;
; SRD PRE-PREFIX FILE
;
;	UPDATED: 1-DEC-76
;
;	UPDATED: 08-MAR-79
;
;	UPDATED: 05-AUG-79
;
;	UPDATED: 19-NOV-79	H.R.TUMBLIN, DUMC
;
;	UPDATED: 28-Nov-80	Phil Stephensen-Payne, SYSTIME
;
; CONDITIONALS DEPENDING ON THE SYSTEM FOR WHICH THIS IS
; BEING ASSEMBLED...
;
.DISABLE	DATA
	.IFT	R$$11M	.DATA R$$11M	=1 ;DEFINE THIS SYMBOL FOR RSX-11M
	.IFT	E$$IS	.DATA E$$IS	=1 ;DEFINE THIS FOR EIS SYSTEMS
	.IFT	R$$11D	.DATA I$$AS	=1 ;DEFINE THIS SYMBOL FOR RSX-11D
	.IFT	I$$AS	.DATA I$$AS	=1 ;DEFINE THIS SYMBOL FOR IAS
	.IFT	D$$CAL	.DATA D$$CAL	=1 ;DEFINE THIS SYMBOL (AND R$$11M) FOR
	.CLOSE
	.SETF	PROCED
.0430:	.ASK	PROCED	Command files generated, Continue
	.IFF	<ESCAPE>	.GOTO	0440
;
;	At this point, all the necessary command, overlay, and prefix
;	files have been generated. If you answer Y to continue, then 
;	SRD will be assembled and task-built. If you answer N, then
;	this command file will exit, preserving the command files.
;
	.GOTO	0430
.0440:	.IFF	PROCED	.GOTO END
;
;	Assemble the source modules
;
.SETF LISTX
.ASK ALL Do you want to assemble all the modules
.ASK LISTX Listings desired
.IFT ALL .GOTO 0460
.0450:
.ASKS MOD Which module do you want to assemble?
.IF MOD = "" .GOTO 0470
.GOSUB MAC
.GOTO 0450
.0460: .SETS MOD "SRDATA"
.GOSUB MAC
.SETS MOD "SRDINI"
.GOSUB MAC
.SETS MOD "SRDLST"
.GOSUB MAC
.SETS MOD "SRDNUD"
.GOSUB MAC
.SETS MOD "SRDOPR"
.GOSUB MAC
.SETS MOD "SRDROT"
.GOSUB MAC
.SETS MOD "SRDSRT"
.GOSUB MAC
.SETS MOD "SRDSUB"
.GOSUB MAC
.SETS MOD "SRDTST"
.GOSUB MAC
.SETS MOD "SRDTRP"
.GOSUB MAC
.SETS MOD "SRDREP"
.GOSUB MAC
.SETS MOD "SRDDBF"
.GOSUB MAC
.SETS MOD "SRDXX1"
.GOSUB MAC
.SETS MOD "SRDXX2"
.GOSUB MAC
.SETS MOD "SRDXX3"
.GOSUB MAC
.GOTO 0470
.MAC:
.IFT LISTX .GOTO MAC01
.IF MOD = "SRDATA" MAC 'MOD'=SRDSYS,SRDPRE,'MOD'
.IF MOD <> "SRDATA" MAC 'MOD'=SRDSYS/PA:1,SRDPRE/PA:1,'MOD'
.GOTO MAC02
MAC01:
.IF MOD = "SRDATA" MAC 'MOD','MOD'/-SP/CR=SRDSYS,SRDPRE,'MOD'
.IF MOD <> "SRDATA" MAC 'MOD','MOD'/-SP/CR=SRDSYS/PA:1,SRDPRE/PA:1,'MOD'
.MAC02:
.RETURN
.0470:;
;	Now taskbuild SRD
;
TKB @SRD.BLD
;
;	SRD Build complete
;
.END:	.IFF SRD REM SRD
	.IFF MAC REM MAC
	.IFF TKB REM TKB
