	.MACRO	ASTVEC	SRVRTN,EXTRA
;
; MACRO ASTVEC
;
; SRVRTN = Asynchronous System Trap Service Routine Name
; EXTRA  = Number of extra AST stack parameters
;
	jsr	r1,@#entrap		;transfer to entrap first
	.word	EXTRA			;system trap stack code word
	.word	SRVRTN			;trap service routine addr
	.ENDM	ASTVEC
	
	
	.MACRO	SSTVEC	SRVRTN,EXTRA
;
; MACRO SSTVEC
;
; SRVRTN = Synchronous System Trap Service Routine Name
; EXTRA  = Number of extra SST stack parameters
;
	jsr	r1,@#entrap		;transfer to entrap first
	.word	-<EXTRA+2>		;system trap stack code word
	.word	SRVRTN			;trap service routine addr
	.ENDM	SSTVEC
	
	
	.MACRO	TRPVEC	SRVRTN,COUNT
;
; MACRO TRPVEC
;
; SRVRTN = System Trap Service Routine Name
; COUNT  = System Trap Service Stack Code Word
;          (Number of extra AST stack parameters, or
;           Negative of total number of SST stack parameters)
;
	jsr	r1,@#entrap		;transfer to entrap first
	.word	COUNT			;system trap stack code word
	.word	SRVRTN			;trap service routine addr
	.ENDM	TRPVEC
