/*
 *				b u i l d . h
 */

#define	EOS		0
#define	FALSE		0
#define	TRUE		1

#define	NONE		0
#define	VAX		1		/* Base operating system opsys	*/
#define	RSX		2
#define	RSTS		3
#define	RT11		4

#define	VNATIVE		1		/* Produce command for op_type	*/
#define	VBOTH		2
#define	VRSX		3
#define	RSXNATIVE	4
#define	RSTSRSX		5
#define	RSTSRT		6
#define	RT11NATIVE	7

#define	NAMESIZE	17		/* Macro names are 16 bytes	*/
#define	WORKSIZE	1025		/* Longest macro result		*/
#define	INLINESIZE	257		/* Input text line size		*/

#define	USED		1		/* Flags for symbol table	*/
#define	FREE		2		/* This entry may be free'd	*/
#define	MODEL		4		/* Set by model file readin	*/
#define	DEFAULT		8		/* Symbol has default value	*/

typedef struct opcode {		/* Used to store operating system names	*/
	char	*o_name;		/* Opcode name entry		*/
	char	o_minimum;		/* Must match this many bytes	*/
	char	o_value;		/* Return value			*/
} OPCODE;

typedef struct symbol {		/* Macro symbol table			*/
	struct symbol	*sy_next;	/* Symbol table chain		*/
	char		*sy_name;	/* Macro name text		*/
	char		*sy_value;	/* Current value		*/
	char		*sy_perm;	/* Permanent (default) value	*/
	int		sy_flag;	/* USED, FREE, and MODEL here	*/
} SYMBOL;

/*
 * String/storage management
 */

extern char	*savest();		/* Save a string		*/
extern char	*csavest();		/* Concat to a saved string	*/
extern char	*myalloc();		/* Allocate or die		*/
extern char	*myrealloc();		/* Compacting reallocator	*/
#ifdef	CHECKALLOC
extern unsigned	hwmallo;		/* Max. bytes allocated		*/
extern		myfree();		/* Free storage			*/
#else
#define	myfree	free
#endif
#ifndef	vms
extern char	*my_free;		/* Set to malloc(1) by init	*/
#endif
extern char	*skipwhite();		/* Return -> non-whitespace	*/

/*
 * Symbol table management
 */

extern SYMBOL	*sylookup();		/* Lookup or make a symbol	*/
extern char	*syvalue();		/* Lookup, return value		*/
extern SYMBOL	*syset();		/* Store a value in symbol	*/
extern SYMBOL	*sysave();		/* Save a value in symbol	*/
extern 		syperm();		/* Make values permanent	*/
extern		syclean();		/* Delete non-permanent symbols	*/

/*
 * Others
 */

extern FILE	*myfopen();		/* Open a file or give message	*/
extern char	*getline();		/* Read one line from a file	*/
extern char	*expand();		/* Do macro expansions		*/
extern FILE	*out();			/* Output routine for expout()	*/

extern int	debug;			/* Enable debug code		*/
extern int	allow;			/* allow world access to result	*/
extern int	verbose;		/* Log files during processing	*/
extern int	profile;		/* Set -p profile switch	*/
extern int	delete;			/* Delete .obj's after build	*/
extern int	build;			/* Build even if no )BUILD	*/
extern int	zflag;			/* Build test command files	*/
extern int	opsys;			/* VAX/RSTS/RSX/RT11		*/
extern int	op_type;		/* VAXNATIVE/VAXRSX/...		*/
extern int	mpinstall;		/* True if MP is installed	*/
extern char	work[WORKSIZE];		/* Static scratch buffer	*/
extern char	inline[INLINESIZE];	/* File input line		*/
extern char	*op_model[];		/* -> opsys models		*/
extern char	*op_base[];		/* -> op_type models		*/
extern char	*comm_model;		/* -> common models		*/
extern char	*src_name;		/* Source file name		*/
extern char	*hdr_name;		/* header file name		*/
extern char	*opsys_name;		/* Op_type name			*/
extern char	*model_name;		/* Model file name		*/
extern char	*lib_name;		/* name of library being built	*/

