/* -----------PREVIOUS DATE: "PREDAY"---------------------------------*/
/* this program reads today's date, calculates a prior date and       */
/* outputs it to a file DATE.DAT in RSX-11M format: dd-mmm-yy.        */
/* It will ask for an integer parameter and deduct that number of days*/
/* from the current date.		AAW, Bergen Record, 1-20-82   */
/*								      */
/* REVISION 1: 5-feb-82 -- Allow command line arguement; prompt if    */
/*  no arguement is given.					      */
/* REVISION 2: 19-APR-82 -- Allow a negative argument to add to the   */
/*  current date, go to next month or year as required.	              */
/*  Change internal prompt to allow negative arguments.		      */
/*  Allow second argument of -t to output date to terminal instead    */
/*   of to file.						      */
#include <stdio.h>;
 static char months[12][3] = {
	"JAN",
	"FEB",
	"MAR",
	"APR",
	"MAY",
	"JUN",
	"JUL",
	"AUG",
	"SEP",
	"OCT",
	"NOV",
	"DEC"
 };
 static char adays [7][10] = {
	"SUNDAY   ",
	"MONDAY   ",
	"TUESDAY  ",
	"WEDNESDAY",
	"THURSDAY ",
	"FRIDAY   ",
	"SATURDAY "
 };
 int endm [12] = {
	31,28,31,30,31,30,31,31,30,31,30,31};

/* function "isleap" */
isleap(y)   /* determines if year is leap year */
 int y;
 {
  if (y % 4 == 0 && y % 100 != 0 || y % 400 == 0)
    return(1);
  else
    return(0);
 }

main (argc,argv)
 char *argv[];
{
 FILE *fp;
 int daysless;
 int tiout;
 char days[5];
 struct time {
	int year;
	int month;
	int day;
	int hour;
	int minute;
	int second;
	int tick;
	int tsec;
  } buffer;

rtime(&buffer);			/* read today's date & time into buffer */

if (argc <= 1) { 
  printf("Date how many days ago? ");
  scanf("%5s", &days);      /* read number of days to deduct */
  daysless = atoi(days);
}
else daysless = atoi(argv[1]);

/* check for any switches */
tiout = 0;
if (argc >= 3) tiout = (argv[2][1] == 'T');
  
/* Now calculate new date, including any February 29's. */
buffer.day -= daysless;		/* deduct required days */

if (isleap(buffer.year)) endm[1] = 29; /* adjust Feb for leap */
else endm[1] = 28;		/* not a leap year */

while (buffer.day <= 0) {	/* goes to previous month */
  if (buffer.month >= 2) {	/* staying in current year */
    buffer.month -= 1;		/* decrement month */
    buffer.day += endm[buffer.month-1];  /* add nbr days in last month */
   }
  else {			/* going to previous year */
    buffer.month = 12;
    buffer.year -= 1;		/* decrement year */
    buffer.day += endm[11];	/* add nbr days in december */
   }
  if (isleap(buffer.year)) endm[1] = 29; /* adjust Feb for leap */
  else endm[1] = 28;		/* not a leap year */
 }

while (buffer.day > endm[buffer.month-1]) { /* goes to next month */
  buffer.day -= endm[buffer.month-1];	/* subtract nmbr days in this month */
  if (buffer.month <= 11) {	/* staying in current year */
    buffer.month += 1;	/* increment month */
   }
  else {				/* going to next year */
    buffer.month = 1;
    buffer.year += 1;			/* increment year */
   }
  if (isleap(buffer.year)) endm[1] = 29; /* adjust Feb for leap */
  else endm[1] = 28;		/* not a leap year */
 }

if (tiout)    /* put date in RSX string format to terminal */
printf ("%02d-%.3s-%02d %s\n", buffer.day,
	 months[buffer.month-1], buffer.year, adays[dayofweek(&buffer)] );
else {  
  	/* open file for write */
  if ((fp = fopen("DATE.DAT","W")) == NULL) 
  	printf ("cannot open file %s", fp);
  /* put date in RSX string format to file */
  fprintf (fp, "%02d-%.3s-%02d %s\n\0", buffer.day,
  	 months[buffer.month-1], buffer.year, adays[dayofweek(&buffer)] );
  fclose (fp);			/* close file */
 }
}
