/* Compile-time constants */

#define	UNIMATION	/* Define to enable page numbers	*/

#define	TRUE	1
#define FALSE	0
#define	EOF	-1
#define	ERROR	-1
#define	OK	0
#define	DEF	0
#define	INCL	1
#define	UNDEF	2
#define	IF	3
#define	IFD	4
#define	IFN	5
#define	ELSE	6
#define	ENDIF	7
#define	MSG	8
#define LINE	9
#define	EOS	'\0'
#define	EQL	0
#define	NEQ	1
#define	LSS	2
#define	LEQ	3
#define	GTR	4
#define	GEQ	5
#define	NIL	0
#define	SOH	001
#define	OCTAL	8
#define	DECIMAL	10
#ifndef stdio
#define	STDIN	0		/* Standard input file descriptor */
#define	STDOUT	1		/* Standard output */
#define	STDERR	2		/* Standard error output */
#endif
#define	LINESZ	1024		/* Size of a line */
#define	MAXIDLEN 12		/* Maximum length of an identifier */
#define	SRCHMAX	2		/* #include search list size */
#define ALASIZE	10		/* Maximum number of macro parameters */
#define	INCDEPTH 4		/* Maximum #include depth */
#define	IFDEPTH	25		/* Maximum #if nesting depth */
#define	DEFDEPTH 25		/* Maximum nested definition level */
#define	EXPBUFSZ 300		/* Maximum #if expression buffer size */
#define	CATMAX	50		/* Size of 'concat' buffer */
#define	MAXARGSZ 100		/* Maximum length of an actual parameter */

#ifdef	vms
#include	<ctype.h>
#endif

/* Structure defintions */

#ifndef stdio
struct buf {		/* Getc, putc buffer structure */
	int fildes;	/* File descriptor */
	int nleft;	/* Number of bytes left in buffer */
	char *nextp;	/* Buffer pointer */
	char buff[512];	/* The I/O buffer itself */
};
#endif

struct stack {
	int spcnt;	/* Space count */
	int usecnt;	/* Use count */
	int *stackptr;	/* Pointer into stack buffer */
};

struct sym {
	char name[MAXIDLEN+1];	/* Name buffer */
	int nargs;	/* Number of arguments */
	int ref;	/* Reference marker to stop recursive definitions */
	char *defptr;	/* Pointer to definition block */
	struct sym *next;	/* Forward link for bucketing */
};

