{ RMS CONST and TYPE definitions }
CONST
  fbdel = 4B;			{ fab fac field: delete access }
  fbget = 2B;			{ fab fac field: get access }
  fbput = 1B;			{ fab fac field: put access }
  fbrea = 42B;			{ fab fac field: read access }
  fbtrn = 20B;			{ fab fac field: truncate access }
  fbupd = 10B;			{ fab fac field: update access }
  fbwrt = 41B;			{ fab fac field: write block I/O }
  fbctg = 200B;			{ fab fop field: contiguous file }
  fbdfw = 20000B;		{ fab fop field: deferred write }
  fbdlk = 20B;			{ fab fop field: unlock }
  fbfid = 10000B;		{ fab fop field: open by file id }
  fbmkd = 4000B;		{ fab fop field: mark for delete }
  fbnef = 1000B;		{ fab fop field: no EOF on magtape }
  fbpos = 10B;			{ fab fop field: position to last file }
  fbrwc = 2B;			{ fab fop field: rewind mag tape on close }
  fbrwo = 1B;			{ fab fop field: rewind mag tape on open }
  fbsup = 400B;			{ fab fop field: supersede if explicit vrsn }
  fbtmd = 6000B;		{ fab fop field: temp file - delete on close }
  fbtmp = 2000B;		{ fab fop field: temp file - no delete }
  fbseq = 0;			{ fab org field: sequential }
  fbrel = 20B;			{ fab org field: relative }
  fbidx = 40B;			{ fab org field: indexed }
  fbfix = 1B;			{ fab rfm field: fixed length records }
  fbvar = 2B;			{ fab rfm field: variable length records }
  fbwri = 15B;			{ fab shr field: other tasks write sharing }
  rbkey = 1B;			{ rab rac field: random access }
  rbrfa = 2B;			{ rab rac field: record's file address }
  rbseq = 0;			{ rab rac field: sequential access }
  rbeof = 1B;			{ rab rop field: position to eof for append }
  rbfdl = 10000B;		{ rab rop field: fast delete }
  rbkge = 2000B;		{ rab rop field: >= key value }
  rbkgt = 4000B;		{ rab rop field: > key value }
  rbmas = 2B;			{ rab rop field: mass insert }
  rbloa = 20B;			{ rab rop field: obey fill numbers on load }
  rbloc = 100B;			{ rab rop field: locate mode (vs. move mode }
  ereof = -592;			{ rab sts field: end-of-file }

TYPE
  byte = char;
  word = integer;
  doubleword =				{ 2 words (VBN) }
    RECORD
      low : word;
      high : word
    END; { doubleword record }
  tripleword =				{ 3 words (RFA) }
    RECORD
      low : word;
      middle : word;
      high : word
    END; { tripleword record }
  fabptr = ^fabrec;			{ pointer to fab }
  rabrec =
    RECORD
      bid : byte;			{ rab block identifier }
      bln : byte;			{ rab block length }
      ctx : word;			{ user defineable area }
      isi : word;			{ pointer to irab }
      sts : word;			{ completion status code }
      stv : word;			{ status value }
      rfa : tripleword;			{ record's file address }
      rac : byte;			{ record access mode }
      ksz : byte;			{ key buffer size }
      rop : word;			{ record processing options }
      usz : word;			{ input record buffer size }
      ubf : ^trmsbuf;			{ input record buffer address }
      rsz : word;			{ size of output record }
      rbf : ^trmsbuf;			{ output record address }
      kbf : ^tkeybuf;			{ key buffer address }
      krf : byte;			{ key of reference }
      mbf : byte;			{ multibuffer count }
      mbc : byte;			{ multiblock count }
      jnk1 : byte;			{ not used }
      rhb : word;			{ fixed control area buffer }
      fab : fabptr;			{ fab address }
      bkt : doubleword;			{ record number or VBN }
      jnk2 : ARRAY [1..46B] OF byte	{ not used }
    END; { rab record }
  fabrec =
    RECORD
      bid : byte;		{ Fab identifier }
      bln : byte;		{ Rab length }
      ctx : word;		{ Available to user }
      ifi : word;		{ Pointer to ifab }
      sts : word;		{ Completion code }
      stv : word;		{ More error information }
      alq : doubleword;		{ Allocation quantity }
      deq : word;		{ * Automatic extension quantity }
      fac : byte;		{ Types of record operations }
      shr : byte;		{ File sharing }
      fop : word;		{ File processing options }
      rtv : byte;		{ Window size }
      org : byte;		{ * File organization }
      rat : byte;		{ * Record attributes }
      rfm : byte;		{ * Record format }
      xab : word;		{ Pointer to first xab }
      bpa : word;		{ Location of private I/O buffer }
      bps : word;		{ Size of private I/O buffer }
      mrs : word;		{ * Maximum record size }
      mrn : doubleword;		{ * Maximum record number }
      jnl : word;		{ Undocumented field (journal?) }
      nam : word;		{ Pointer to nam block }
      fna : ^tflnm;		{ description of filespec, ptr. loaded later }
      dna : word;		{ Location of filepsec defaults }
      fns : byte;		{ Size of filespec }
      dns : byte;		{ Size of filespec defaults }
      bls : word;		{ * Block size }
      fsz : byte;		{ * Size of fixed area for VFC records }
      bks : byte;		{ * Bucket size }
      dev : byte;		{ Device characteristics }
      lch : byte;		{ Logical channel }
      jnk : ARRAY [1..34B] OF char
    END; { fab rec }
{ END RMS CONST & TYPE Definitions }
