COURSE OUTLINE
SUBJECT: PART 1 -- INTRODUCTION TO RSX11M



1.0  INTRODUCTION TO RSX11M


Sources of further information:

     1.  ISD library (near secretary's desk)

         Complete set of RSX11M manuals.  The Master Index in  Vol  1.
         tells you where to look for certain subjects.

         Read Volume 1, "Introduction to RSX11M", chapters 4 and 6.

     2.  RSX11M USER SELF INSTRUCTION COURSE (Al Watson has this)
                Read sections on:
                MCR
                Files Structure and Records
                File Commands and Utilities
                Indirect Command Files

     3.  System Help Files

         Most common system routine described in on-line  HELP.   Type
         "HELP" at any terminal to get a list of HELP files available.
                Examples: HELP DCL
                          HELP PIP SWitches

         Start looking at HELP DCL to prepare for next class.

     4.  Mini Reference (small blue book in computer room).

         Summary information on PIP, EDT, MCR,  Error  Logging,  Error
         message  codes,  and  Task  Builder.  For now, see page 61 on
         "Standard File Types".

     5.  Documentation directory.

         General documentation written at the RECORD will be placed in
         UIC [10,1] on the business system or UIC [100,100] on the CSI
         system.  The files will have a Type of ".DOC".  To  see  what
         is there, do the following:
          
                        PIP [10,1]*.DOC/LI
                or      PIP [100,100]*.DOC/LI
          













PART 1 -- INTRODUCTION TO RSX11M                                PAGE 2



1.1  HOW TYPED-IN COMMANDS ARE PROCESSED


The primary program that interprets your type-ins is MCR, the  Monitor
Console Routine.

Additional command interpreters can be added to  RSX11M  Version  3.2,
but  not  to  Version  3.1, which is what CSI uses.  Therefore the CSI
system uses MCR only.  

On the business system we have added DCL  (Digital  Command  Language)
and  will  soon be adding CCL (Console Command Language) to allow com-
mands that are simpler to use and that do more things.  

MCR always tries first.  It has many internal commands such as SET  or
ACT.   If  what  you  type is an MCR command MCR does it.  If not, MCR
looks to see if a task by that name is installed in the CPU and if so,
runs the task for you.  "Installed" means the task has been put into a
list of available tasks so that the system knows where to find  it  on
disk.   This  is  done automatically at startup for some tasks;  other
tasks can be installed later by the INS command.  Tasks installed with
a  name that starts with three dots (...PIP, ...BRU) can be recognized
by MCR as though their names were MCR commands.  Tasks  of  this  type
are also allowed to run multiple copies;  more than one person can use
them at the same time.  The  system  automatically  assigns  different
names to the second or higher copies by using the terminal number, for
example, PIP.T0 or PIP.T15.  

If MCR does not recognize the type-in, it passes it on  to  the  addi-
tional   command  interpreters.   First  is  CCL,  known  as  "...CA."
(catch-all).  If it fails to recognize it, the command  is  passed  to
DCL  (known as "...CA2").  If DCL fails to recognize it, an error mes-
sage is given, "UNRECOGNIZED COMMAND".  

On CSI, if MCR doesn't recognize a command, it responds "TASK  NOT  IN
SYSTEM".  Remember, DCL and CCL are not on the CSI system!  It is pos-
sible that CCL will eventually be put onto CSI, but since it  requires
a SYSGEN it will be a while.  

Another feature (on both systems) allows you to write a series of com-
mands  in  a  file,  called  a "command file".  These files are always
named with ".CMD" as the last part of the file name.  By typing in the
filename, preceded by an At Sign (@), you cause all of the commands in
the file to be executed indirectly, just as though you had typed  them
all  in.  Thus, "@REPORTS" causes the commands stored in "REPORTS.CMD"
to be executed.  This gives us the capability of having canned  proce-
dures to run jobs that are repeated frequently.  

The program that processes indirect command files is called  IND,  and
is  installed  with the name "...AT.".  IND will not only execute MCR,
CCL, and DCL commands, it also recognizes a set of  internal  commands
that  allow  it  to prompt the user, test for input, and conditionally
execute commands depending on the user's answers.  We will be devoting









PART 1 -- INTRODUCTION TO RSX11M                                PAGE 3



an entire session to IND later on.  



1.1.1  DCL - 

DCL, on the  business  system,  simplifies  command  syntax  and  adds
prompting  cabability.  For example, if you want to copy a file on the
CSI system you must use the program PIP, and say:  
        PIP NEWFILE.TYP=OLDFILE.TYP

With DCL you can simply say "COPY OLDFILE.TYP NEWFILE.TYP" or, if  you
forget  which  comes  first,  old  or new, just type "COPY".  DCL will
prompt you with "FROM" and "TO".  Other than prompting, DCL does noth-
ing  but translate your command into a form MCR can recognize and then
give it back to MCR to execute.  There are many DCL commands.  We will
be spending two sessions to cover them.  

For an example of what DCL does,  type  in  "DIR  *.CMD/MCR".   Adding
"/MCR" makes DCL show you the standard MCR command it uses to give you
a directory.  If you get used to DCL on the business system and  would
like  to know how to do the same thing on CSI, type the DCL command on
the business system with /MCR added.  BUT BE SURE  THE  COMMAND  WON'T
HURT  ANYTHING  ON  THE  BUSINESS  SYSTEM!  Watch out for DELETE, etc.
(Note:  there are even some MCR commands on the business  system  that
don't  exist  on  CSI, but trying won't hurt, you'll just get a syntax
error.) 

DCL does one more thing:  if it does not recognize what you type as  a
command, it will look for a file by that name in your current UIC with
a type of ".CMD".  If it finds one, it will execute it just as  though
you  had  preceded  the  word with "@".  All this does is save you the
trouble of typing "@".  Example:  DOCS.CMD in your UIC can be  run  by
typing "DOCS".  On CSI you would have to type "@DOCS".  



1.1.2  CCL - 

CCL is yet another command interpreter even more  powerful  than  DCL.
We  intend  to  use  both.  CCL can run uninstalled tasks, which saves
system resources (POOL space).  It can also perform a series  of  com-
mands  instead  of  just one line, and commands can be written so that
only certain users can use them.  

As CCL is installed (within a week or two) and commands  are  written,
documentation will be distributed and information will be added to the
HELP files.  














PART 1 -- INTRODUCTION TO RSX11M                                PAGE 4



1.2  FILES AND FILE DIRECTORIES

 
TERMS:
Volume:         a magnetic medium that RSX11M recognizes, such as a
 disk or 
                magnetic tape.
Volume Label:   the name (1-6 characters) of a volume, e.g. BGN00A.
File:           an owner-named area on a volume.
Device:         the physical unit on which a volume resides.
Device Name:    the symbolic name of a device, e.g. SI12:, MM2:.
 
Master File Directory: a list of User File Directories, stored in
 [0,0].
User File Directory:   a list of all files belonging to a certain
 user.
 

When accessing a file, the system reads the MFD to locate the UFD, and
then reads the UFD to locate the file called for.  

Each file is listed in at least one UFD (if  not  it  is  said  to  be
"lost").  

Each UFD is listed in the MFD.

Each user (identified by logon name) has a  UFD  associated  with  his
logon.   this  is  called  his UIC (user identification code).  UIC is
frequently understood as a synonym for UFD,  but  note  that  not  all
UFD's  are  associated  with a user logon.  For this course, unless we
say otherwise, we will use the terms UFD and UIC interchangeably,  and
will usually use UIC.  

UIC's are identified by two numbers (in octal, digits 8 and 9 not  al-
lowed)  that specify a "group" and a "member" number.  A group is just
a group to which the UFD belongs, and a member number  identifies  the
particular  UIC within the group.  UIC numbers are (almost always) en-
closed in square brackets:  [77,77] or [10,1].   [10,1]  identifies  a
UIC  in  group 10, member 1.  For the most part, the concepts of group
and member are not important, but in some cases all  the  files  in  a
group  may  be  protected from users whose UIC is not in the group, or
some users may be allowed to access files only within their group.  



1.3  FILE SPECIFICATIONS

 
Complete File Specification includes:
                                DEFAULT:        COMMENTS:
1.      the device it is on     SY0:
2.      the UFD of the file     Current UIC
3.      the file name           none            1 to 9 characters









PART 1 -- INTRODUCTION TO RSX11M                                PAGE 5



4.      the file type           none            0 to 3 characters
5.      the version number      highest         Octal number
 
        dev:[UIC]filename.type;version
 
Note the funny punctuation; it is required!
 
Examples:
        SI12:[222,1]DOCS.CMD;1
        SY0:[100,100]SYSABO.CMD;12
 
If you are working in UIC [100,100] which contains these files:
 
        SYSABO.CMD;2
        SYSABO.CMD;3
        SYSABO.CMD;4
 
then specifying "SYSABO.CMD" will expand to  the  following  when  the
system adds its defaults:
 
        SY0:[100,100]SYSABO.CMD;4
 
Notice that many files may exist with the same name and type, as  long
as the UIC or the version number is different:
 
        [100,100]SYSABO.CMD;4
        [77,77]SYSABO.CMD;4
        [77,77]SYSABO.CMD;3
        [77,76]SYSABO.CMD;3

Unless otherwise specified, a new file (created or copied) will have a
version  number  one  higher  than any other file of the same name and
type that exists in the current UIC.  If I were to create a  new  ver-
sion of SYSABO.CMD in [100,100], it would be assigned type number "5".
Try this within your UIC when you learn how to copy a file.  

Version numbers ascend in octal;  version 7 is followed by version 10!

One way we need to keep disk space freed up is to delete old  versions
of  files.  This is done by "purging", which we will discuss under DCL
PURGE and the PIP /PU switch.  



1.3.1  WILDCARDS - 

A "wildcard" is a character that matches anything,  like  a  Joker  in
Poker.  The wildcard character for files is "*" (asterisk).  Many pro-
grams use this.  

DIRECTORY SYSABO.CMD -- lists info about SYSABO.CMD, the highest  ver-
sion.  










PART 1 -- INTRODUCTION TO RSX11M                                PAGE 6



DIR SYSABO.CMD;* -- lists info about SYSABO.CMD, all versions.

DIR [222,*]DOCS.CMD -- lists info about all DOCS.CMD  files  contained
in group 222.  

DIR [222,3]*.CMD -- lists info about all files  with  type  ".CMD"  in
[222,3].  

DIR [*,*]*.TMP;* -- lists info about all ".TMP" files  on  entire  vo-
lume.  


                                 NOTE

               "DIR" is a  DCL  command;   on  CSI  you
               would use the form:  PIP [*,*]*.TMP;*/LI





1.3.2  SWITCHES - 

Some programs, like PIP, use switches to specify functions.  A  switch
usually  has  the  form of a slash followed by two letters.  Some pro-
grams use more than two letters, and a few (particularly those written
in the C language) use a hyphen (-) instead of a slash.  
 
        PIP *.*/BR      -- the "brief" switch for a brief directory.
        PIP *.CMD/PU    -- the "purge" switch to delete all but
                           highest version.

Some programs allow switches to be negated  by  prefacing  the  letter
part  with  a  hyphen,  e.g.   SRD *.*/PU/-LI (purge files, don't list
what's being purged.  SRD is a directory program, similar to PIP,  and
will be discussed in the next session.)



1.4  FILE SECURITY


There are four classes of users in a standard DEC system:
 
        SYSTEM --       system managers (access to everything)
        OWNER  --       creator of a file.
        GROUP  --       all users in a group.
        WORLD  --       everybody.

Each class of user can be given or denied four types of  access  to  a
file:  
 










PART 1 -- INTRODUCTION TO RSX11M                                PAGE 7



        R       -- Read access.
        W       -- Write access.
        E       -- Extend access (enlarge the file).
        D       -- Delete access.

When you see the message "PRIVELEGE VIOLATION" it means you have tried
to access a file that is protected against your current UIC.  

The default file protection is pretty broad:
 
        (RWED,RWED,RWED,R)

This means SYSTEM, OWNER, and GROUP  can  do  anything  to  the  file;
WORLD can just read it.  

The  222  group  UIC's  have   been   defined   with   protection   of
(RWED,RWED,,).   This  means that only you or a system manager can ac-
cess your files in any way.  

UIC's with group numbers from 1 to 7  have  SYSTEM  level  priveleges.
UIC [1,1] has universal access.  However, if you log on with an unpri-
veleged UIC such as [222,5], you cannot be made priveleged by  switch-
ing to [1,1].  

If you log on with a priveleged UIC such as [2,31], your  terminal  is
made  priveleged.  You then acquire the priveleges of whatever UIC you
switch to.  If you are in [77,77] you can access  files  according  to
the  priveleges of [77,77].  But if you switch to [1,1] you can access
anything.  

The system console (hardcopy printer) is always a priveleged  terminal
no  matter how it logs on:  the business system puts it in [77,77] and
the CSi system puts it in [100,100].  Working at  the  system  console
you  may get privelege violations, but if you switch to [1,1] you will
gain universal access.  Note that it is possible to protect  files  so
that SYSTEM users cannot even read them;  however, a priveleged termi-
nal in [1,1] can override that protection.  

There are also priveleged MCR COMMANDS, such as INSTALL.  The MCR man-
ual  tells  you which are which.  You must be at the console or logged
on under a priveleged UIC to use these commands.  Another such command
is  SET  /PRIV;   it  can  set  any  other  terminal to be priveleged.
Sometimes this is necessary to get someone out of a jam.  



1.5  CHANGING OR SWITCHING UIC's


At logon a default  UIC  is  established.   In  the  business  system,
[77,77] is the default for the login "X".  Every login has a different
default.  System operators on the business system have  UIC's  in  the
222 group.









PART 1 -- INTRODUCTION TO RSX11M                                PAGE 8



Files relating to many system functions reside in other UIC's, for ex-
ample  [330,330]  for the CSI Report Generator.  You must switch UIC's
to [330,330] to generate reports.

To show your current UIC (which is used as default in all file specs):
1.      SET /UIC=               works on all systems
2.      SHOW DEF[ault]          DCL, C system only. 
3.      UIC                     special program, installed on C 
                                system. This program may be added to
                                CSI.
 
 
Changing to another UIC:
1.      SET /UIC=[100,100]      works on all systems.
2.      DSET DEF 100,100        DCL, C system only. Note brackets are
                                not needed; however they may be
                                included.
3.      UIC 100,100             special program, C only (so far).
                                Again, you may include brackets.
4.      UIC DILLON              Changes to the logon UIC of DILLON.
 








































