/*
 *			v s t r i n g . h
 */

#ifdef	DOCUMENTATION

title	vstring		Header file for vstrings
index		Header file for using using vstrings

synopsis

	#include <vstrin.h>

description

	This header file is used to allow programs to access vstrings.  See
	vstring.c for additional details.
	.s
	This file defines the structure of a vstring. The fields are:
	.lm+16
	.s.i-16;char *vsdata	Pointer  to  the actual data.  This will
	always be  the  first  field,  so that a
	vstring  can be considered to be of type
	char **  if  you  only want  to read it.
	vsdata  will  be NULL if the vstring has
	been damaged. 
	.s.i-16;unsigned vslen	Number  of bytes  stored in the vstring.
	.s.i-16;unsigned vsdim	Total number of bytes there is room for.
	.s.i-16;unsigned vsext	Allocation  quantum  -  the  amount  the
	vstring is to grow by if it fills. If 0,
	the vstring cannot grow.
	.s.lm-16
	The only fields generally directly accessed by programs are vsdata and
	vslen. Note that vsdata may change over time as items are added to and
	removed from the vstring.
	.s
	The only field you should normally change is vsext, the extension
	quantum.  The value current the next time the vstring must grow will
	determine how much it grows by.
	.s
	vstring.h also includes external declarations of the appropriate type
	for the functions in vstring.c.

bugs

	A vstring is really just a special case of a flex with item size 1.
	It has been retained as a separate datatype because the type of
	operations done on strings are not always generalizable.  For example,
	there is no obvious use for an fxadds().

author
	Jerry Leichter

#endif

/*
)EDITLEVEL=15
 *
 * Edit history
 * 0.0 30-Apr-81 JSL	Invention
 * 0.1  4-May-81 JSL	Better error handling
 * 0.2 12-May-81 JSL	Decided to keep blocks after all; balloc() is now
 *			block().
 * 0.3 13-May-81 JSL	Added _BLOCKS_
 * 0.4 18-May-81 JSL	Fix up documentation so GETRNO can find it
 * 1.0 26-Jun-81 JSL	Changed name to vstring, which makes much more sense.
 * 1.1 29-Jun-81 JSL	More name changes, get consistent with flexes.
 */

#ifndef _vstring_		/* Don't do this twice */
#define _vstring_

typedef struct bheader
	{ char *vsdata;
	  unsigned vslen;
	  unsigned vsdim;
	  unsigned vsext;
	} VSTRING;

extern VSTRING *vstring(), *vsaddc(), *vsadds();
/*
 * These are all in one file, unlike the case for flexes, so there's no harm
 * in generating the external references.
 */
#endif
