.;+
.;	VDXGEN.CMD
.;
.;	Interfaces with PHASE4 to build the VD: package
.;
.;	Global symbol $NUNIT, which specifies the number of VD: units
.;	the data structures are built for, should be defined.
.;-
.;
.ENABLE SUBSTITUTION
.ENABLE GLOBAL
.;
	.SETN EXSTAT 2			! Assume failure
.;
.;    If $NUNIT (number of VD: units to build) is not defined, log an
.;    error and quit
	.IFDF $NUNIT	.GOTO EDIT
	.SETS $LGLIN "$NUNIT undefined"
	.GOTO ERROR
.;
.;    Edit VDPRE.MAC to set up number of units
.EDIT:
	@'$P4LOC'SLPUPD VDPRE.MAC V$$D11= V$$D11='$NUNIT'
	.IF <EXSTAT> EQ 1	.GOTO ASMBLE
.;
.;    Some error occurred in editing.  Give up.
	.SETS $LGLIN "Error occurred updating VDPRE.MAC."
	.GOTO ERROR
.;
.;    Assemble VDX source files
.ASMBLE:
	@VDXASM
	.IF <EXSTAT> EQ 1	.GOTO TSKBLD
.;
.;    Assembly error - log it and leave.
	.SETS $LGLIN "Error in assembly"
	.GOTO ERROR
.;
.;    Taskbuild VDX tasks
.TSKBLD:
	@VDXBUILD
	.IF <EXSTAT> EQ 1	.GOTO MOVE
.;
.;    Taskbuild error - log it and leave
	.SETS $LGLIN "Taskbuild error"
	.GOTO ERROR
.;
.;    Move task files, VDDRV.STB, and map files (maybe) to target dev & UIC
.MOVE:
	@'$P4LOC'MOVE *.TSK,VDDRV.STB '$TSK'
	.IF <EXSTAT> NE 1	.GOTO MOVERR
	.IF $MAP NE "" @'$P4LOC'MOVE *.MAP '$MAP'
	.IF <EXSTAT> NE 1	.GOTO MOVERR
.;
.;    If we got this far, everything's OK; set EXSTAT, and clean up directory
	.SETN EXSTAT 1
	DEL *.OBJ;*
	DEL *.LST;*
	DEL *.MAP;*
	DEL *.TSK;*
	DEL *.STB;*
	DEL VDDRVASM.CMD;*
	DEL VDTBLASM.CMD;*
	PUR *.*
.;
.EXIT:
	.EXIT EXSTAT
.;
.;    Error processing
.;
.MOVERR:
	.SETS $LGLIN "Error moving files to target"
.ERROR:
	@'$P4LOC'LOGENT
	.GOTO EXIT
