.ENABLE SUBSTITUTION
.ENABLE GLOBAL
.ENABLE ESCAPE
;
; USGS.CMD -- Overall command file for unloading USGS submissions for
;	      the RSX SIG tape, Fall ''81.
;
; Hopefully, this command file will get everything unloaded for you
; from the universal libraries. The universal libraries are nested,
; so to avoid confusion, you may want to work with each kit separately,
; especially if you are low on free disk space.
;
; Note: You should have some idea about the things you would like to
;       unload from the universal library. Comments about our submissions
;       can be found in the README.1ST file.
;
.ASK L Do you want to exit now to see README.1ST
.IFT L .GOTO EXIT
.TESTFILE USGS.ULB
.IF <FILERR> EQ 1 .GOTO 10
;
; Unfortunately, I cannot find USGS.ULB, which contains all of the
; submissions. Please load it into this directory!
.GOTO EXIT
.10:
.SETF $USGS
;
; This command file will ask you if you want to unload/build the
; various submissions in this directory. If you are unsure about
; what each submission has to offer, enable the long dialog below.
; You may hit <ESCAPE> to any numbered question to obtain the long
; dialog for that section.
;
.ASK $DILOG Long dialog desired
;
; FCPMU -- Multi-user ACP for RSX-11M-PLUS (only)
.IFF $DILOG .GOTO 20A
.20:
;
; FCPMU is a kit which will enable you to create a "multi-user" F11ACP
; file system. This means that you can assign a copy of F11ACP to 
; various disks, and each copy will share the same 4K program code section.
; This is especially useful for installations with a lot of memory
; (.5 Megabyte or more) and intensive file operations on several disks.
;
; Note that this kit will not work on RSX-11M systems!
.20A:
;
.ASK L 1. Do you want to unload the FCPMU kit
.IFT <ESCAPE> .GOTO 20
.IFF L .GOTO 100
;
.TESTFILE FCPMU.ULB
.IF <FILERR> NE 1 Lbr Fcpmu.Ulb=Usgs.Ulb/ex:Fcpmu   ! Unload the kit
.TESTFILE FCP.CMD
.IF <FILERR> NE 1 Lbr Fcp.cmd=Fcpmu.ulb/ex:fcp      ! Unload command file
.TESTFILE FCPTXT.TXT
.IF <FILERR> NE 1 Lbr Fcptxt.txt=Fcpmu.ulb/ex:Fcptxt
;
; See FCPTXT.TXT for a fuller explanation of how FCPMU works.
.IFF $DILOG .GOTO 30A
.30:
;
; Note that TKB must have a current patch level in order for the
; task build of FCPMU to work. The P2POP module and the SGALO module
; require the patches. If you have kept up to date with the Software
; Dispatches or the Multitasker, you probably already have these patches.
;
; Note that you have to manually apply these patches. See FCPTXT.TXT for
; the procedure.
.30A:
;
.ASK L 1A. Do you want to unload the patch files for TKB
.IFT <ESCAPE> .GOTO 30
.IFF L .GOTO 40
;
Lbr Sgalo.pat=Fcpmu.Ulb/ex:Sgalo
Lbr P2pop.pat=Fcpmu.Ulb/ex:P2pop
;
.ASK L Do you want to exit now to apply these patches
.IFT L .GOTO EXIT
.40:

@Fcp

.100:
;
; BLKIO -- Fast Fortran Block I/O Routines
.IFF $DILOG .GOTO 110A
.110:
;
; The BLKIO routines provide the fastest disk I/O possible from
; Fortran programs. These can be very helpful for programs which
; perform a lot of scratch file work. You''d be amazed how fast
; these can speed up a program
.110A:
;
.ASK L 2. Do you want to unload the BLKIO routines
.IFT <ESCAPE> .GOTO 110
.IFF L .GOTO 200
;
.TESTFILE BLKIO.ULB
.IF <FILERR> NE 1 Lbr Blkio.ulb=Usgs.ulb/ex:Blkio
.TESTFILE BLKCMD.CMD
.IF <FILERR> NE 1 Lbr Blkcmd.cmd=Blkio.ulb/ex:Blkcmd
.TESTFILE BLKIOTXT.TXT
.IF <FILERR> NE 1 Lbr Blkiotxt.txt=Blkio.ulb/ex:Blkiot
;
; See BLKIOTXT.TXT for information on using these routines!
@BLKCMD

.200:
;
; STREAM -- Various RSX-11M-PLUS configuration tools
.IFF $DILOG .GOTO 210A
.210:
;
; The STREAM package contains three mini-tools:
;
;	STTY     -- Multiple SET command stuffer for terminal setup
;       STARTUP  -- Our USGS Startup command files, as is.
;       CONFIG   -- Files to reconfigure batch streams and generate reports
.210A:
;
.ASK L 3. Do you want any of the STREAM package
.IFT <ESCAPE> .GOTO 210
.IFF L .GOTO 300
.ASK L1 A. Do you want to generate STTY
.IFF L1 .GOTO 220
;
.TESTFILE USERMAC.MLB
.IF <FILERR> NE 1 .GOSUB USERMA
.TESTFILE STREAM.ULB
.IF <FILERR> NE 1 Lbr Stream.Ulb=Usgs.ulb/ex:Stream
.TESTFILE STTY.ULB
.IF <FILERR> NE 1 Lbr Stty.ulb=Stream.Ulb/ex:Stty
.TESTFILE STTYCMD.CMD
.IF <FILERR> NE 1 Lbr Sttycmd.cmd=Stty.Ulb/ex:Sttycm
@STTYCMD

.220:
.ASK L1 Do you want to unload the USGS startup files
.IFF L1 .GOTO 230
;
.TESTFILE STREAM.ULB
.IF <FILERR> NE 1 Lbr Stream.Ulb=Usgs.ulb/ex:Stream
.TESTFILE STARTUP.ULB
.IF <FILERR> NE 1 Lbr Startup.Ulb=Stream.Ulb/ex:Startu
.TESTFILE STARTCMD.CMD
.IF <FILERR> NE 1 Lbr Startcmd.cmd=Startup.ulb/ex:Startc
@STARTCMD.CMD

.230:
.ASK L1 Do you want to unload the batch configuration files
.IFF L1 .GOTO 300
;
.TESTFILE STREAM.ULB
.IF <FILERR> NE 1 Lbr Stream.Ulb=Usgs.ulb/ex:Stream
.TESTFILE CONFIG.ULB
.IF <FILERR> NE 1 Lbr Config.Ulb=Stream.Ulb/ex:Config
.TESTFILE CONFIG.CMD
.IF <FILERR> NE 1 Lbr Config.cmd=Config.ulb/ex:Config
@CONFIG.CMD

.300:
;
; CSH -- Checkpoint Space Handler
.IFF $DILOG .GOTO 310A
.310:
;
; The checkpoint space handler is handy for getting rid of checkpoint
; files, rather than using ACS.
;
; Beware, beware --- You should apply the TKTN patch supplied first!
.310A:
;
.ASK L 4. Do you want to unload the Checkpoint Space Handler (CSH)
.IFT <ESCAPE> .GOTO 310
.IFF L .GOTO 400
.ASK L Do you want to unload the TKTN correction file
.TESTFILE USERMAC.MLB
.IF <FILERR> NE 1 .GOSUB USERMA
.TESTFILE CSH.ULB
.IF <FILERR> NE 1 Lbr Csh.ulb=Usgs.Ulb/ex:Csh
.IFT L Lbr Tktn.cor=Csh.ulb/ex:Tktn
.TESTFILE CSHCMD.CMD
.IF <FILERR> NE 1 Lbr Cshcmd.Cmd=Csh.ulb/ex:cshcmd
.TESTFILE CSHTXT.TXT
.IF <FILERR> NE 1 Lbr Cshtxt.txt=Csh.ulb/ex:cshtxt
;
; CSHTXT.TXT contains detailed information on this kit
@CSHCMD

.400:
;
; Mods to MCR, somewhat unsupported, but useful
.IFF $DILOG .GOTO 410A
.410:
;
; These modifications to MCR have improved the usability
; of our system. See the README.1ST file for the particulars. These
; modifications are unsupported....you should know what you''re doing
; before doing it!
.410A:
;
.ASK L 5. Do you want to unload the MCR correction files
.IFT <ESCAPE> .GOTO 410
.IFF L .GOTO 420
;
.TESTFILE MCR.ULB
.IF <FILERR> NE 1 Lbr Mcr.ulb=Usgs.ulb/ex:Mcr
.TESTFILE MCRNOV.CMD
.IF <FILERR> NE 1 Lbr Mcrnov.cmd=Mcr.ulb/ex:Mcrnov
.TESTFILE MCRTXT.TXT
.IF <FILERR> NE 1 Lbr Mcrtxt.txt=Mcr.ulb/ex:Mcrtxt
;
; The MCRTXT.TXT file contains detailed information on this kit
@MCRNOV.CMD
.420:
.500:
;
; Correction to SYSGEN for multi-access devices
.IFF $DILOG .GOTO 510A
.510:
;
; This correction must be applied if you want multi-access support to
; work. See the SYSGEN manual for details, or unload the text file
; be answering "YES" below.
.510A:
;
.ASK L 6. Do you want to unload the SYSGEN correction files
.IFT <ESCAPE> .GOTO 510
.IFF L .GOTO 600
.TESTFILE SYSGEN.ULB
.IF <FILERR> NE 1 Lbr Sysgen.ulb=Usgs.ulb/ex:Sysgen
.TESTFILE SGNMAS.COR
.IF <FILERR> NE 1 Lbr Sgnmas.cor=Sysgen.ulb/ex:Sgnmas
.TESTFILE SGNTXT.TXT
.IF <FILERR> NE 1 Lbr Sgntxt.txt=Sysgen.ulb/ex:Sgntxt
;
; See the file SGNTXT.TXT for full information on this kit.
.600:
;
; Versatec Line Printer driver
.IFF $DILOG .GOTO 610A
.610:
;
; This driver will talk to a Versatec device (DMA or otherwise).
; This kit has been advertised by Larry Baker in the Multitasker,
; and assumes you know something about drivers. See the documentation
; included with the kit.
.610A:
;
.ASK L 7. Do you want the Versatec package unloaded
.IFT <ESCAPE> .GOTO 610
.IFF L .GOTO 700
.TESTFILE VERSATEC.ULB
.IF <FILERR> NE 1 Lbr Versatec.Ulb=Usgs.ulb/ex:Versat
.TESTFILE VERSATEC.CMD
.IF <FILERR> NE 1 Lbr Versatec.Cmd=Versatec.ulb/ex:Versat
@VERSATEC.CMD

.700:
;
; NOTES! Larry Baker''s notes on RSX-11M-PLUS performance
;
.ASK L 8. Do you want these notes unloaded (say yes -- they''re useful)
.IFF L .GOTO EXIT
;
.TESTFILE NOTES.ULB
.IF <FILERR> NE 1 Lbr Notes.ulb=Usgs.ulb/ex:Notes
.TESTFILE NOTES.CMD
.IF <FILERR> NE 1 Lbr Notes.cmd=Notes.ulb/ex:Notes
@NOTES.CMD

.GOTO EXIT
.USERMA:
;
.TESTFILE USERMAC.ULB
.IF <FILERR> NE 1 Lbr Usermac.ulb=Usgs.ulb/ex:Userma
.TESTFILE USERCMD.CMD
.IF <FILERR> NE 1 Lbr Usercmd.cmd=Usermac.ulb/ex:Usercm
@USERCMD
.RETURN

.EXIT:
;
; End of USGS.CMD
;
