C
C	Include file for use with VAXNET program.
C
	IMPLICIT INTEGER*4 (A-Z)
	INTEGER*2 LIOSB(4), RIOSB(4), XIOSB(4), TYPEAHEAD_COUNT(4), BAUD_RATE
	INTEGER*4 TERMTBL(2), NOTERM(2)
	DATA TERMTBL,NOTERM /0,"020000,0,0/
C
C	Parameters.
C
	CHARACTER*(*) SS, DS, NULL, BELL
	PARAMETER (SS = CHAR(13)//CHAR(10)) ! Single space.
	PARAMETER (DS = SS//SS)		! Double space.
	PARAMETER (BELL = CHAR(7))	! Bell.
	PARAMETER (NULL = CHAR(0))	! NULL.
	PARAMETER EOT = 4		! End of transmission.
	PARAMETER ENQ = 5		! Enquire.
	PARAMETER ACK = 6		! Acknowlegment.
	PARAMETER LF  = 10		! Line feed.
	PARAMETER CR  = 13		! Carriage return.
	PARAMETER NAK = 21		! Negative Acknowlegment.
	PARAMETER SYN = 22		! Synchronize byte.
	PARAMETER CAN = 24		! Cancel transmission.
	PARAMETER EOF = 26		! End of file.
	PARAMETER FILE_UNIT = 1		! Unit # for VAX file.
	PARAMETER LOG_UNIT = 2		! Unit # for log file.
	PARAMETER CONTROL_Y = 25	! Control/Y.
	PARAMETER ESCAPE = 27		! Escape.
	PARAMETER BUFFER_SIZE = 512	! Buffer size.
	PARAMETER TYPEAHEAD_SIZE = 78	! Typeahead buffer size.
	PARAMETER TIMEOUT_COUNT = 60	! Timeout read count.
	PARAMETER RETRY_LIMIT = 8	! Maximum # of retries.
	LOGICAL*1 RBUFFER(BUFFER_SIZE)	! Receive buffer.
	LOGICAL*1 XBUFFER(BUFFER_SIZE)	! Transmit buffer.
	LOGICAL*1 TBUFFER(BUFFER_SIZE)	! Temporary buffer.
	LOGICAL*1 LBUFFER(TYPEAHEAD_SIZE)! Local buffer.
C
C	Flags.
C
	LOGICAL	CONTROLC_TYPED, IN_A_COMMAND, LOGFILE,
	1	RECEIVER_BUSY, XMITTER_BUSY, READ_ONE, LOCAL_ECHO,
	1	DEBUG_MODE, REMOTE, HANGUP, DUMP_MODE
C
C	Direction for GET/SEND.
C
	PARAMETER IN=1, OUT=2
C
C	The filename(s) on the VAX and the REMOTE.
C
	CHARACTER*50 VAX_FILE, REMOTE_FILE

	COMMON /BUFFERS/ RBUFFER, XBUFFER, LBUFFER, TBUFFER, VAX_FILE,
	1 	REMOTE_FILE
	COMMON /CHANNELS/ LOCAL_CHANNEL, REMOTE_CHANNEL
	COMMON /COUNTS/ BYTE_COUNT, RECORD_COUNT, RBYTE_COUNT, LBYTE_COUNT,
	1		TIMEOUTS, PARITY_ERRORS, NAKS_RECEIVED, NAKS_XMITTED,
	1		ENQS_RECEIVED, ENQS_XMITTED
	COMMON /FLAGS/ LIOSB, RIOSB, XIOSB, RECEIVER_BUSY, XMITTER_BUSY,
	1	TERMTBL, NOTERM, TYPEAHEAD_COUNT, TERMINATOR,
	1	READ_ONE, LOCAL_ECHO, DEBUG_MODE, HANGUP, REMOTE,
	1	CONTROLC_TYPED, IN_A_COMMAND, LOGFILE, RINDEX,
	1	MODE, FLOW, VSIZE, RSIZE, DUMP_MODE
	COMMON /STATUS/ LOCAL_STATUS, REMOTE_STATUS, FUNCTION

C
C	Define I/O codes.
C
	INCLUDE 'IODEF.FOR/NOLIST'
C
C	Define Status Returns.
C
	INCLUDE 'SSDEF.FOR/NOLIST'
