
{***********************************************************************
                     BEGIN PRM CONST and TYPE
        FILE [300,47]PrmPrefix.Pas
          Refer to file [300,47]PrmCalls.Pas for Procedure Calls 
 *********************************************************************** 
}
  
CONST
  { * Error values returned in status word 1 and word 2 with each PRM call.
    * All errors set Status[1] to a negative value.

  PrINI	= -5001 ;   		{  file not properly initialized }
  PrRNE	= -5002 ;  		{ file and user specified record not equal }
  PrRsz	= -5003 ;  		{ record size must be loaded before PRMRet }
  PrKY0	= -5004 ;   		{ specify key 0 first }
  PrKNS	= -5005 ;   		{ no key number specified }
  PrAsc	= -5006 ;   		{ keys specified in a non-ascending order }
  ErDup	= -544 ;		{ insert duplicate rec with no dups allowed }
  ErEof = -592 ;		{ record processing reached end-of-file }
  ErFac = -656 ;		{ record opr does not match declared access }
  ErFnf = -736 ;		{ file not found during open }
  ErRlk = -1440 ;		{ target record was locked by another task }
  ErRnf = -1472 ;		{ random get or find did not locate record }
  NameSize	= 30 ;		{ sz of RMS input file name, do not alter }



TYPE
  TwoWord	= ARRAY [1..2] OF integer ;	{ record number size }

{ Following RecDef and KeyDef RECORDS are EXAMPLES only -
        define similiar RECORDS in MAIN Program TYPE specifications 
  RecDef = RECORD	 user defines field names and sizes 
    CASE integer OF	
      1 : (FXDat1 : ARRAY [1..10] OF CHAR ;
           FXDat2 : integer ) ;
      2 : (FYItem1 : ARRAY [1..30] OF CHAR ;
           FYItem2 : REAL ) ;
    END ;
  KeyDef = RECORD
    CASE integer OF    " user defines keylabels and sizes, as many as req. "
      1 : ( KeyX : ARRAY [1..10] OF CHAR) ;
      2 : ( KeyY : ARRAY [1..12] OF CHAR) ;
      3 : ( RNum : TwoWord ) ;   " use this def. of relative rec. # if req. "
    END ;
}

  RmsFileName	= ARRAY [1..NameSize] OF CHAR ;	{ file name, do not alter }
  RmsStatus	= ARRAY [1..2] OF integer ;	{ returned rms status codes }

  OrgTypes	= (SEQ,REL,IDX) ;	{ block i/o not supported }
  AllowTypes	= (Share,NoShare) ;      { what others can do }
  AccessTypes	= (PRead,PWrite,PBoth) ; { what you can do to the file }
  FormType = (FFIX,FVAR,FSTREAM) ;	{ record format type }

  RmsFileDesc	= RECORD
    Org		: OrgTypes ;	{ spec. file type, NO DEFAULT }
    FileName	: RmsFileName ;	{ full spec. of rms file, NO DEFAULT }
    LogChan	: integer ;	{ spec. ch. n, NO DEF., n<= TKB UNITS=n }
    Allow	: AllowTypes ;	{ what others may do with file, DEF Share }
    Access	: AccessTypes ;	{ what you may do to the file, DEFAULT Read }
    RecordSize  : INTEGER ;	{ MUST = max. file rec. size, NO DEFAULT }
    Windows	: INTEGER ;	{ no. of ret. windows, DEFAULT usually 7 }

    { enable the following options with a capital "Y", ANY OTHER = DEFAULT }
    DeferWrite	: CHAR ;	{ IDX, defer write, def. write each record }
    Unlock    	: CHAR ;  	{ REL & IDX, don't lock if abort, DEF. LOCK }
    ObeyFill	: CHAR ;	{ obey bucket fill numbers, DEF. FILL TO MAX }
    MassInsert	: CHAR ;	{ IDX, ref. rms-11 macro ref. man. rab rop }
    FileEnd	: CHAR ;	{ SEQ only, place file stream at end of file }

    { file creation fields }
    RecForm	: FormType ;	{ rec. format, FSTREAM for seq., Def.= FFix }
    Allocation  : TwoWord ;	{ no. blocks allocated to file, DEF. 0 BLKS }
    BucketSize	: integer ;	{ data bucket size, DEFAULT BUCKETSIZE = 1 }
    ExtQua	: integer ;	{ no. blks dynamic extend file, DEFAULT 1}
    { Enable following with capital "Y", if not loaded, default is selected }
    Contiguous	: CHAR ;	{ create a contiguous file, DEF. FRAGMENTED }
    Temporary	: char ;	{ delete the file when closed, DEF. NO DEL. }

    WorkSpace	: PACKED ARRAY [1..160] OF char ;
  END ;	{ RmsFileDesc Record }

  SearchTypes	= (EQ,GT,GE,RFA,NEX,REC) ; { for GET use KeyData(EQ'=',GT'>',
                    GE'>='), RFA, next seq. rec(NEX) or Rec. # (org=REL) }
  ThreeWord	= ARRAY [1..3] OF Integer ;	{ for RFA's, big file huh }
  RecOps	= (PGET,PFIND,PPUT,PUPDATE) ; { PRM record operations }
  RetRecord = RECORD
    { - USE with PRMRET, INPUT - to GET and FIND - INPUT/OUTPUT ref. to PRM }
    KeyNum	: Threeword ;	{ INPUT- IDX Key # or RFA, search defines }
    Search	: SearchTypes ;	{ INPUT - spec. search opr }
    RecSize	: integer ;	{ INPUT - sz rec. to GET, (sz of rec. buffer)
                                  OUTPUT- sz rec. returned to user rec. buf }
    RFAout	: ThreeWord ;	{ OUTPUT- valid if search <> RFA }
    KeySize	: integer ;	{ INPUT - size of key data, <= full key size }
    KeyData	: KeyDef ;	{ INPUT - IDX or REL, key string or rec. # }
  END ;	{ RetRecord RECORD Definition }

  StoRecord = RECORD
      { USE with PRMSTO, Input to PUT and UPDATE - INPUT/OUTPUT ref. to PRM }
      RecSize	: integer ;	{ INPUT - spec. part or all or rec. buffer 
                                  data to be stored, <= full rec. sz }
      RFAOut	: ThreeWord ;	{ OUTPUT - rfa where record was stored }
      Cell	: KeyDef ;	{ INPUT - REL ONLY, spec. rec. # for store }
    END ;	{ StoRecord Record }

  KType = (StrKey,IntKey) ;	{ string or unsigned integer key type }
  { Use with MULTIPLE calls of PRMKEY to define ALL keys of an indexed file. 
    MUST be used at least once prior to PrmCre of an indexed file type }
  IdxKeyDesc = RECORD
      KeyNum	: Integer ;	{ key of ref. #, def. asc. order, start 0 }
      KeyPos	: Integer ;	{ byte position of key in rec., start byte 0 }
      KeySiz	: Integer ;	{ size of the key defining, max. = 255 }
      KeyTyp	: KType ;	{ string or unsigned integer, def.=string }
      KeyDup	: char ;	{ 'Y' to allow duplicate keys, def. no dup }
      KeyChg	: char ;	{ 'Y' for key changes, alt. only, def no chg }
      KeyNul	: char ;	{ null key value, alt. string keys only }
    END ;	{ IdxKeyDesc }


  {***********************************************************************
 *                   END PRM CONST and TYPE                            *
 *********************************************************************** }
  
 
