.; TREADGEN  --  VERSION 3.2A FOR DECUS RELEASE (7/20/81)
.;
	.ENABLE SUBSTITUTION
;
; TRWGEN - GENERATES TREAD/TWRITE SUBROUTINE PACKAGE
.;
	.IFINS ...MAC .GOTO 10
.;
; THE MACRO ASSEMBLER MUST BE INSTALLED TO RUN THIS COMMAND FILE,
; PLEASE INSTALL IT AT THIS TIME.
/
.10:
	.IFINS ...LBR .GOTO 20
.;
; THE LIBRARIAN TASK MAY BE NEEDED TO RUN THIS FILE TO YOUR
; SATISFACTION. YOU SHOULD INSTALL IT AT THIS TIME IF DESIRED.
;
.20:
;
; THE RESPONSE TO THE NEXT QUESTION DETERMINES HOW MANY TAPE
; DRIVES ANY ONE USER OF THE TREAD/TWRITE SUBROUTINES WILL HAVE
; ACCESS TO AT ONE TIME THROUGH THE TREAD SYSTEM.
;
.ASKN [1.:24.:1.] TPUNIT HOW MANY TAPE DRIVES ARE ON YOUR SYSTEM
;
; THE NEXT QUESTION IS USED TO DEFINE LOCAL EVENT FLAGS
; USED BY TREAD, TWRITE. ONE EVENT FLAG IS NEEDED
; FOR EACH TAPE UNIT USED DURING A PROGRAM PLUS ONE
; FLAG FOR THE TERMINAL I/O DONE BY TREAD, TWRITE.
;
.SETN I 24.-TPUNIT
.ASKN [1:I:I] DEFEVF WHAT IS THE STARTING LOCAL EVENT FLAG TO BE USED
.DEC DEFEVF
;
; WHEN TRANSLATING INPUT DATA FROM EBCDIC, ALL LOWER CASE CHARACTERS
; CAN BE CONVERTED TO UPPER CASE. ANSWER YES TO THE NEXT QUESTION
; TO SELECT THIS OPTION
;
.ASK UPPER2 TRANSLATE TO UPPER CASE FROM EBCDIC
.SETN UPPER 0
.IFT UPPER2 .SETN UPPER 1
;
; THE FOLLOWING OPTION MAY BE SELECTED IF THE
; PRIMARY USE OF THE ROUTINES IS TO BE FROM FORTRAN
; PROGRAMS. IF THAT IS THE CASE, A CALL IS MADE TO THE
; FORTRAN SYSTEM SUBROUTINE "USEREX" WHEN THE TREAD, TWRITE
; SYSTEM IS INITIALIZED. IF YOUR NORMAL PROGRAMMING
; MAKES EXTENSIVE USE OF "USEREX" IT IS SUGGESTED THAT
; YOU NOT INCLUDE THIS OPTION. THIS OPTION IS HELPFUL
; IN THAT IT CAUSES THE NECCESARY TREAD, TWRITE CLOSE
; ROUTINES TO BE CALLED ON PROGRAM EXIT. IF IT IS NOT SELECTED
; THEN THE USER MUST SPECIFICALLY INCLUDE SUBROUTINE CALLS
; TO THE TREAD-TWRITE CLOSE ROUTINES IN HIS PROGRAM.
;
.ASK FORTRN SHOULD TREAD/TWRITE AUTOMATIC CLEANUP BE INCLUDED
.SETS FORT ";"
.IFT FORTRN .SETS FORT ""
;
; THE FOLLOWING QUESTION IS USED TO DETERMINE HOW MANY ADDITIONAL
; RE-TRIES ARE ATTEMPTED ON INPUT I/O OPERATIONS. THE SYSTEM
; DRIVERS USUALLY REPEATE A FAULTY I/O OPERATION 9 TIMES, SO
; THE ACTUAL NUMBER OF OPERATIONS ATTEMPTED IS 9*RETRY+9.
; THIS OPTION IS HELPFUL IN CUTTING DOWN THE NUMBER OF BAD
; BLOCKS RECEIVED FROM TAPE DRIVES. A REALISTIC VALUE FOR THIS
; OPTION IS IN THE RANGE 2-3. A RESPONSE OF ZERO EXCLUDES THE OPTION.
;
.ASKN [0:10.:3.] RETRY HOW MANY RETRIES SHOULD BE ATTEMTED ON INPUT ERRORS
;
; ANSWER YES TO THE NEXT QUESTION IF RUNNING RSX VERSION 3.2 OR LATTER
; OR AN EQUIVALENT VERSION OF IAS.
;
.ASK RSXV ARE YOU RUNNING RSX VERSION 3.2 OR LATTER
.SETS RSXV32 ";"
.IFT RSXV .SETS RSXV32 ""
;
; IF YOUR MACHINE DOES NOT HAVE A HARDWARE "SOB" INSTRUCTION,
; OR IF YOU ARE UNSURE, ANSWER NO TO THE NEXT QUESTION
;
.ASK EIS DOES YOUR MACHINE HAVE A HARDWARE SOB INSTRUCTION
;
;
;
; YOU HAVE SELECTED THE FOLLOWING OPTIONS:
;
; NUMBER OF MAXIMUM TAPE UNITS IN TREAD/TWRITE USE BY ONE USER='TPUNIT'
.SETN I DEFEVF+1
; FIRST DEFAULT EVENT FLAG USED='I'
.SETN I DEFEVF+TPUNIT
; LAST DEFAULT EVENT FLAG USED='I'
.INC I
; DEFAULT EVENT FLAG USED FOR TERMINAL I/O ='I'
.IFT UPPER2 ; TRANSLATION TO UPPER CASE FROM EBCDIC
.IFT FORTRN ; AUTOMATIC CALLS TO CLEANUP ROUTINES RCLOSE AND WCLOSE
.IF RETRY > 0 ; 'RETRY'*9+9 ADDITIONAL RETRIES ON AN INPUT I/O ERROR
;
; THINKING...
.;
.; OPEN AND WRITE THE ASSEMBLY PARAMETER FILE BASED ON THE INFO
.; SUPPLIED ABOVE.
.;
.OPEN TREADPARM.MAC
.ENABLE DATA
	.TITLE	TREAD TAPE SYSTEM
	.IDENT	/V03.02A/
	.SBTTL	USER DEFINED SYMBOLS
;+
; TREADPARM   FM   7/20/81
.DISABLE DATA
.IFT RSXV .DATA ;
.IFT RSXV .DATA ; GENERATED ON '<DATE>' BY TAPGEN
.ENABLE DATA
;
; THIS FILE ESTABLISHES ALL LOCAL SYMBOLS AND MACROS
; NEEDED BY THE TREAD, TWRITE SUBROUTINE SYSTEM
; 
; THE NEXT SYMBOL SHOULD REFLECT THE ACTUAL NUMBER OF
; TAPE DRIVES ON YOUR SYSTEM.
;
TPUNIT='TPUNIT'.
;
; THE NEXT SYMBOL IS USED TO DEFINE LOCAL EVENT FLAGS
; USED BY TREAD, TWRITE. ONE EVENT FLAG IS NEEDED
; FOR EACH TAPE UNIT USED DURING A PROGRAM PLUS ONE
; FLAG FOR THE TERMINAL I/O DONE BY TREAD, TWRITE.
; EVENT FLAGS ARE ALLOCATED CONSECUTIVELY FROM THE
; EVENT FLAG INDICATED BELOW. FOR EXAMPLE, IF YOU HAVE 3 TAPE
; DRIVES ON YOUR SYSTEM AND YOU SPECIFY EVENT FLAG 20.
; THEN EVENT FLAGS 21,22,23 ARE USED FOR TAPE I/O
; AND EVENT FLAG 24 IS USED FOR TERMINAL I/O.
;
DEFEVF='DEFEVF'.
TIEVF=TPUNIT+DEFEVF+1
;
; WHEN THE TRANSLATION FROM EBCDIC OPTION IS SELECTED FOR TREAD,
; SPECIFYING A NON-ZERO VALUE FOR THE FOLLOWING
; SYMBOL WILL CAUSE ANY LOWER CASE EBCDIC CHARACTERS TO
; BE CONVERTED TO UPPER CASE ASCII CHARACTERS.
;
UPPER='UPPER'
;
; THE FOLLOWING SYMBOL MAY BE DEFINED IF THE
; PRIMARY USE OF THE ROUTINES IS TO BE FROM FORTRAN
; PROGRAMS. IF THAT IS THE CASE, A CALL IS MADE TO THE
; FORTRAN SYSTEM SUBROUTINE "USEREX" WHEN THE TREAD, TWRITE
; SYSTEM IS INITIALIZED. IF YOUR NORMAL PROGRAMMING
; MAKES EXTENSIVE USE OF "USEREX" IT IS SUGGESTED THAT
; YOU NOT INCLUDE THIS OPTION. THIS OPTION IS HELPFUL
; IN THAT IT CAUSES THE NECCESARY TREAD, TWRITE CLOSE
; ROUTINES TO BE CALLED ON PROGRAM EXIT. IF IT IS NOT SELECTED
; THEN THE USER MUST SPECIFICALLY INCLUDE SUBROUTINE CALLS
; TO THE TREAD-TWRITE CLOSE ROUTINES IN HIS PROGRAM.
; IF YOU CHOOSE NOT TO INCLUDE THIS OPTION, PLACE A COMMENT
; BEFORE THE SYMBOL.
;
'FORT'FORTRN=1
;
; THE FOLLOWING SYMBOL IS USED TO DETERMINE HOW MANY RE-TRIES
; ARE ATTEMPTED ON INPUT I/O OPERATIONS. THE SYSTEM
; DRIVERS USUALLY REPEATE A FAULTY I/O OPERATION 9 TIMES, SO
; THE ACTUAL NUMBER OF OPERATIONS ATTEMPTED IS 9*RETRY.
;
RETRY='RETRY'.
;
; THE FOLLOWING CONDITIONAL SHOULD BE DEFINED IF YOU WILL USE THE
; ROUTINES WITH RSX VERSION 3.2 OR LATER
;
'RSXV32'RSXV32=1
;
; DEFINE NEXT SYMBOL FOR CHI CODE DEFAULTS
;
;CHI=1
;-
.DISABLE DATA
.IFT EIS .GOTO 100
.ENABLE DATA
	.MACRO SOB,R,A
	DEC	R
	BNE	A
	.ENDM
.DISABLE DATA
.100: .CLOSE
;
; WE NOW ASSEMBLE THE SUBROUTINE SYSTEM
;
MAC TREAD,TREAD=TREADPARM,TREAD
MAC ASTOEB,ASTOEB=ASTOEB
MAC EBTOAS,EBTOAS=TREADPARM,EBTOAS
;
.ASK OKAY DID THE TREAD ROUTINES ASSEMBLE CORRECTLY
.IFT OKAY .GOTO 110
;
; TAKE STEPS NEED TO CORRECT THE PROBLEM, CALL ME (FRANK MANION)
; AT 609-779-0911 IF NECESSARY.
;
/
.110:;
; WE WILL NOW, IF YOU WISH, CREATE THE LIBRARY FILE "TREAD.OLB"
; TO CONTAIN THE TREAD/TWRITE SYSTEM. IF YOU WISH FOR THE
; TREAD/TWRITE SUBROUTINES TO BE PLACED IN SYSLIB, THEN
; DO THE FOLLOWING:
;
; LOG IN UNDER A PRIVLEGED ACCOUNT (IF NOT ALREADY)
; ISSUE THE COMMAND
;
;	LBR LB:[1,1]SYSLIB/IN='<SYDISK>''<SYUNIT>':'<UIC>'TREAD,ASTOEB,EBTOAS
;
.ASK LIB SHOULD TREAD.OLB BE CREATED TO CONTAIN THE TREAD SYSTEM
.IFF LIB .GOTO 200
;
LBR TREAD/CR:20.:64.:64.:OBJ=TREAD,ASTOEB,EBTOAS
.200:;
; TREAD IS NOW AVAILABLE FOR USE ON YOUR SYSTEM
.IFT LIB .GOTO 210
; SINCE YOU HAVE NOT SPECIFIED A LIBRARY TO CONTAIN
; THE TREAD ROUTINES, YOU MUST INCLUDE THE MODULES
; "TREAD", "ASTOEB", AND "EBTOAS" IN THE INPUT STRING
; TO THE TASK BUILDER FOR EACH PROGRAM WHICH WILL
; USE THE ROUTINES.
/
.210:; SINCE YOU HAVE SPECIFIED A LIBRARY TO CONTAIN
; THE TREAD ROUTINES (TREAD.OLB), ALL THAT YOU
; MUST DO TO TASK BUILD A TASK USING THE ROUTINES
; IS TO LINK WITH THE LIBRARY.
/
