;	F C P C O 1 B L D . C M D
;
; BUILD CORE RESIDENT F11ACP (FCPCO1) FOR MAPPED RSX11M
;	NAME - FCPCO1
;	.ODL - FCPCORBLD.ODL
;	SIZE - 6. KW
;	FCB LIST - 32 FCB'S
;	SEPARATE DIRECTORY BUFFERS - 3
;
;
TK:[1,54]FCPCO1/AL/AC/MM/-FP,MP:[1,34]FCPCO1/-SP=FCPCO1BLD.ODL/MP
;
; OPTIONS INPUT
;
TASK=F11ACP
STACK=32
UNITS=1
UIC=[1,1]
PRI=149
PAR=FCPPAR:0:0
;	PAR=FCPPAR:0:30100
TSKV=.SSTVC:7
;
; THE MAXIMUM SIZE FOR THIS FCP IS 12K. ONLY THE DIRECTORY BUFFER, HOWEVER,
; CAN LIE IN THE LAST 4K (APR7).  THE FOLLOWING BUFFERS MUST BE IN THE LOWER 8K
; (APR5 AND APR6).
;
;
; ALLOCATE A SEPARATE BUFFER FOR INDEX FILE BITMAP
;
;	EXTSCT=$$BUF0:1006
;
; DEFAULT IS ONE BUFFER SHARED BETWEEN BITMAP AND FILE HEADERS (AND DIRECTORY
; BLOCKS).  THIS ACTION WILL SPEED UP APPLICATIONS THAT DO A LOT OF FILE
; CREATION AND DELETION.
;
;
;
; ALLOCATE A SEPARATE BUFFER FOR FILE HEADERS
;
EXTSCT=$$BUF1:1006
;
; DEFAULT FROM ASSEMBLY IS ONE BUFFER SHARED BETWEEN FILE HEADERS
; AND DIRECTORY BLOCKS (AND INDEX FILE BITMAP).  THIS ACTION WILL BENEFIT ANY
; APPLICATION THAT CAN AFFORD THE MEMORY.
;
;
;
; ALLOCATE PRIVATE FCB POOL SPACE
;
; EACH FCB = 52 OCTAL
;
;	EXTSCT=$$AFR1:XXXX
;
;	,WHERE XXXX = N*52 (OCTAL) AND N = NUMBER FCB'S DESIRED
;
EXTSCT=$$AFR1:2500
;
;
; *** NOTE ***
; THE PRECEDING BUFFERS AND EXTSCT'S MUST LIE IN ADDRESS SPACE BELOW APR7.
; DO NOT EXTSCT PAST 157777 OCTAL!!
;
; THE DIRECTORY BUFFER BELOW MAY LIE, IN WHOLE OR IN PART, WITHIN THE ADDRESS
; SPACE OF APR7.  CONSEQUENTLY, THE MAXIMUM ALLOWABLE FOR THIS EXTSCT IS
; <3.5K + N> OR <17000 (OCTAL) + N> WHERE N REPRESENTS THE AMOUNT OF SPACE UNDER
; APR7 THAT IS STILL AVAILABLE AFTER THE PRECEDING EXTSCT'S HAVE BEEN APPLIED.
;
;
; ALLOCATE ADDITIONAL BUFFER SPACE FOR DIRECTORY BLOCKS
;
;	EXTSCT=$$BUF3:XXXX
;
;	,WHERE XXXX REPRESENTS 1000 FOR EACH 'ADDITIONAL' BLOCK
;	DESIRED.
;
; DEFAULT FROM ASSEMBLY IS ONE DIRECTORY BLOCK.  NOTE THAT THIS
; ACTION SHOULD BE IN ADDITION TO ALLOCATING A SEPARATE BUFFER
; FOR FILE HEADERS.  ALLOCATING ADDITIONAL BUFFER SPACE FOR DIRECTORY
; BLOCKS WITHOUT A SEPARATE BUFFER FOR FILE HEADERS DOES NOT
; ACCOMPLISH VERY MUCH.
;
EXTSCT=$$BUF3:2000
;
;
;
/
