.; Command file to read crash dumps, name according to the
.; date and crash, and get initial CDA listing using the
.; options /ACT/HDR/PCB.
.;
.; The name is the form NAMEMMDDX, where NAME is the system
.; name, MM is the month, DD is the day, and X is the crash
.; of the day (A for the first, B for the second, etc.)
.;
	SET /UIC=[1,17]
	.ENABLE SUBSTITUTION
	.SETS	$NAME	"XXXX"
.;
.; Get date and parse out month and day.
.;
	.SETS	$DATE	<DATE>
	.PARSE	$DATE	"--" $DD MM YR
	.IF MM ="JAN" .SETS $MM "01"
	.IF MM ="FEB" .SETS $MM "02"
	.IF MM ="MAR" .SETS $MM "03"
	.IF MM ="APR" .SETS $MM "04"
	.IF MM ="MAY" .SETS $MM "05"
	.IF MM ="JUN" .SETS $MM "06"
	.IF MM ="JUL" .SETS $MM "07"
	.IF MM ="AUG" .SETS $MM "08"
	.IF MM ="SEP" .SETS $MM "09"
	.IF MM ="OCT" .SETS $MM "10"
	.IF MM ="NOV" .SETS $MM "11"
	.IF MM ="DEC" .SETS $MM "12"
.;
.; Loop and find which crash sequence number to use.
.;
	.SETN	$POS	0
	.SETS	ALBET	"ABCDEFGHIJKLMNOPQRSTUVWXYZ"
.100:	.INC	$POS
	.SETS	$X 	ALBET[$POS:$POS]
	.SETS	$FILE	$NAME+$MM+$DD+$X
	.TESTFILE	'$FILE'.CDA
	.IF	<FILERR> = 1 .GOTO 100
.;
.; Install necessary tasks, load driver, and get dump.
.;
	.IFNINS ...LOA	INS $LOA
	.IFNINS ...UNL	INS $UNL
	.IFNINS ...CDA	INS $CDA
	.IFNLOA MM:	LOA MM:/HIGH/PAR=GEN
	.SETS	F	$FILE
	CDA 'F'/-SP,'F'/MEMSIZ:'<MEMSIZ>'.=[1,54]/STB,MM:/PCB/ACT/HDR
.;
.; Clean-up from command file.
.;
	UNL MM:
	REM CDA

