struct buffer {
	struct buffer *b_link;
	char b_buf[32];
	};

struct msghdr {
	struct msghdr *m_older;
	struct msghdr *m_newer;
	struct buffer *m_bufp;
	char *m_pcb;
	int m_size;
	int m_time;
	int m_mask;
	};

struct trailr {
	struct trailr *t_link;
	char *t_pcb;
	char *t_astn;
	char *t_asti;
	int t_astp;
	int t_mask;
	char *t_astb;
	};

struct aethdr {
	struct aethdr *a_link;
	char *a_name;
	char *a_pswd;
	int a_mask;
	struct trailr *a_tlist;
	struct msghdr *a_newer;
	struct msghdr *a_older;
	};

union genbuf {
	struct msghdr msg;
	struct aethdr aet;
	struct trailr trl;
	};

union names {
	char n_key[16];
	union names *n_ptr;
	};

#define DELTA_TIME 5
#define NIL_BUF	(struct buffer *)0
#define NIL_AET	(struct aethdr *)0
#define NIL_MSG (struct msghdr *)0
#define NIL_TLR (struct trailr *)0
#define NIL_CHR (char *)0
#define NIL_NAM (union names *)0
#define OK	0
#define ERR	-3
#define CREATED 1
#define ACCESSED 2
#define BUFFER_OVERFLOW -1
#define TIMED_OUT -2
#define MIN_LIFETIME 30		/* minimum lifetime of a packet */
#define MAX_LIFETIME 600	/* maximum lifetime of a packet (10 min) */

extern struct aethdr *aether;	/* global anchor of aether list */
extern struct msghdr *msg_list;	/* listhead for msg header free list */
extern struct buffer *buf_list;	/* listhead for buffer free list */
extern union names *nam_list;	/* listhead for name buffer free list */
extern char *aet_name;		/* pointer to name of aether */
extern char *password;		/* pointer to password */
extern char *pcb;		/* process id block address */
extern char *nml_ast;		/* "normal" ast address */
extern char *int_ast;		/* "interrupt" ast address */
extern int ast_parm;		/* ast parameter */
extern int if_access;		/* non-zero if access upon create collision */
extern int type;		/* type of message - normal | interrupt */
extern struct aethdr *descript;	/* descriptor passed by requestor */
extern char *buf_ptr;		/* pointer to source or destination buffer */
extern int buf_size;		/* size of buffer */
extern int life_tim;		/* lifetime of message */
extern int status;		/* final status to return to user */

struct aethdr *aet_access()
{
	register int m;
	register struct trailr *t;
	register struct aethdr *a;
	struct aethdr *find_aether();
	struct msghdr *gethdr();

	status = ERR;
	if ((a = find_aether(aet_name)) != NIL_AET)
	    if (strcmp(password, a -> a_pswd) == 0)
	        if ((m = get_f_bit(a -> a_mask)) != 0)
		  if ((t = (struct trailr *)gethdr()) != NIL_TLR)
		    {
		    a -> a_mask |= m;
		    t -> t_mask = m;
		    t -> t_link = a -> a_tlist;
		    a -> a_tlist = t;
		    t -> t_pcb = pcb;
		    t -> t_astn = nml_ast;
		    t -> t_asti = int_ast;
		    t -> t_astp = ast_parm;
	            status = ACCESSED;
	            descript = a;
		    return(a);
		    }
	return(NIL_AET);
}

aet_cleanup()
{
	register struct aethdr *a, *b;
	struct trailr *aet_deaccess();

	for (a = aether; a != NIL_AET; a = b)
	  {
	  b = a -> a_link;		/* save link info */
	  descript = a;			/* deaccess from this aether */
	  while (aet_deaccess() != NIL_TLR)
	    ;
	  }
}

struct aethdr *aet_create()
{
	register struct aethdr *a;
	register struct trailr *t;
	struct msghdr *gethdr();
	struct aethdr *find_aether();
	char *name, *pass;
	char *gtlbuf();

	status = ERR;
	name = NIL_CHR;
	t = NIL_TLR;
	a = NIL_AET;
	if (find_aether(aet_name) == NIL_AET)
	    {
	    if ((a = (struct aethdr *)gethdr()) != NIL_AET)
	        if ((t = (struct trailr *)gethdr()) != NIL_TLR)
	            if ((name = gtlbuf()) != NIL_CHR)
	                if ((pass = gtlbuf()) != NIL_CHR)
	                    {
	                    strcpy(pass, password);
			    strcpy(name, aet_name);
			    t -> t_link = NIL_TLR;
			    t -> t_pcb = pcb;
			    t -> t_astn = nml_ast;
			    t -> t_asti = int_ast;
			    t -> t_astp = ast_parm;
			    t -> t_mask = 1;
			    a -> a_link = aether;
			    aether = a;
			    a -> a_name = name;
			    a -> a_pswd = pass;
			    a -> a_mask = 1;
			    a -> a_tlist = t;
			    a -> a_newer = NIL_MSG;
			    a -> a_older = NIL_MSG;
	                    status = CREATED;
	                    descript = a;
			    return(a);
			    }
	    }
	else if (if_access != 0)
	    return(aet_access());
	ptlbuf(name);
	puthdr((struct msghdr *)t);
	puthdr((struct msghdr *)a);
	return(NIL_AET);
}

struct aethdr *find_aether(name)
char *name;
{
	register struct aethdr *a;

	for (a=aether; a != NIL_AET; a = a -> a_link)
	    if (strcmp(name, a -> a_name) == 0)
		break;
	return(a);
}

struct buffer *getbuf(n)
int n;
{
	register struct buffer *b, *c;

	for (b = buf_list; b != NIL_BUF; b = b -> b_link)
	    if ((n -= 32) <= 0)
		break;
	if (n > 0)
	    return(NIL_BUF);
	else
	    {
	    c = buf_list;
	    buf_list = b -> b_link;
	    b -> b_link = NIL_BUF;
	    return(c);
	    }
}
get_f_bit(mask)
int mask;
{
	register unsigned int sgl_bit;

	for (sgl_bit = 2; sgl_bit != 0; sgl_bit <<= 1)
	    if ((mask & sgl_bit) == 0)
		break;
	return(sgl_bit);
}

struct msghdr *gethdr()
{
	register struct msghdr *m;

	m = msg_list;
	if (m != NIL_MSG)
	    {
	    msg_list = m -> m_older;
	    m -> m_bufp = NIL_BUF;
	    }
	return(m);
}

char *gtlbuf()
{
	register union names *n;

	n = nam_list;
	if (n != NIL_NAM)
	    nam_list = n -> n_ptr;
	return((char *)n);
}

inshdr(a, m)
struct aethdr *a;
struct msghdr *m;
{
	register struct msghdr *n;

	if ((n = a -> a_older) != NIL_MSG)	/* non-empty list */
	  {
	  n -> m_newer = m;
	  m -> m_newer = NIL_MSG;
	  m -> m_older = n;
	  a -> a_older = m;
	  }
	else				/* empty list */
	  {
	  a -> a_older = m;
	  a -> a_newer = m;
	  m -> m_older = NIL_MSG;
	  m -> m_newer = NIL_MSG;
	  }
}

ptlbuf(c)
char *c;
{
	register union names *n;

	if (c != NIL_CHR)
	    {
	    n = (union names *)c;
	    n -> n_ptr = nam_list;
	    nam_list = n;
	    }
}

putbuf(m)
struct msghdr *m;
{
	register struct buffer *b, *c;

	for (b = m -> m_bufp; b != NIL_BUF; b = c)
	  {
	  c = b -> b_link;
	  b -> b_link = buf_list;
	  buf_list = b;
	  }
	m -> m_bufp = NIL_BUF;
}

puthdr(m)
struct msghdr *m;
{
	if (m != NIL_MSG)
	    {
	    m -> m_older = msg_list;
	    msg_list = m;
	    }
}

remhdr(a, m)
struct aethdr *a;
struct msghdr *m;
{
	register struct msghdr *n;

	if ((n = m -> m_older) != NIL_MSG)
	  n -> m_newer = m -> m_newer;
	else
	  a -> a_newer = m -> m_newer;
	if ((n = m -> m_newer) != NIL_MSG)
	  n -> m_older = m -> m_older;
	else
	  a -> a_older = m -> m_older;
}

aet_timer()
{
	register struct aethdr *a;
	register struct msghdr *m, *nxt;

	for (a = aether; a != NIL_AET; a = a -> a_link)
	    {
	    for ( m = a -> a_older; m != NIL_MSG; m = nxt)
	        {
	        nxt = m -> m_older;
	        if ((m -> m_time -= DELTA_TIME) <= 0)
	            {
		    remhdr(a, m);
	            putbuf(m);
	            puthdr(m);
	            }
	        }
	    }
}

struct aethdr *val_ptr(desc)
struct aethdr *desc;
{
	register struct aethdr *a;

	for (a = aether; a != NIL_AET; a = a -> a_link)
	    if (a == desc)
		break;
	return(a);
}

struct trailr *aet_deaccess()
{
	register struct aethdr *a;
	register struct trailr *t, *u;
	register struct msghdr *m, *n;
	register int mask;

	status = OK;
	if ((a = val_ptr(descript)) != NIL_AET)
	  {
	  for (t=NIL_TLR, u=a->a_tlist; u!=NIL_TLR; t=u, u=t->t_link)
	    if (u -> t_pcb == pcb)	/* this one */
	      {
	      if (t == NIL_TLR)	/* unlink trailer */
	        a -> a_tlist = u -> t_link;
	      else
	        t -> t_link = u -> t_link;
	      mask = ~(u -> t_mask);		/* complement of mask bit */
	      a -> a_mask &= mask;		/* clear conn bit */
	      puthdr((struct msghdr *)u);		/* return block */
	      for (m=a->a_older; m != NIL_MSG; m=n)
	        {
	        n = m -> m_older;
	        if ((m -> m_mask &= mask) == 0)
	          {
	          remhdr(a, m);
	          putbuf(m);
	          puthdr(m);
	          }
	        }
	      break;
	      }
	  if (a -> a_mask == 0)	/* aether is done */
	    rem_aether(a);
	  return(u);
	  }
	else
	  return(NIL_TLR);
}

rem_aether(a)
struct aethdr *a;
{
	register struct aethdr *b, *c;

	for (b=NIL_AET, c=aether; c != NIL_AET; b=c, c = b -> a_link)
	  if (c == a)		/* found it */
	    {
	    if (b == NIL_AET)
	      aether = c -> a_link;
	    else
	      b -> a_link = c -> a_link;
	    ptlbuf(c -> a_name);		/* return little buffers */
	    ptlbuf(c -> a_pswd);
	    puthdr((struct msghdr *)c);		/* return aether header */
	    break;
	    }
}

struct trailr *val_pcb(a)
struct aethdr *a;
{
	register struct trailr *t;

	for (t = a -> a_tlist; t != NIL_TLR; t = t -> t_link)
	  if (t -> t_pcb == pcb)
	    break;
	return(t);
}

struct msghdr *aet_receive()
{
	register struct aethdr *a;
	register struct trailr *t;
	register struct msghdr *m;

	status = ERR;
	if ((a = val_ptr(descript)) != NIL_AET)
	  if ((t = val_pcb(a)) != NIL_TLR)
	    for (m = a -> a_newer; m != NIL_MSG; m = m -> m_newer)
	      if ((m -> m_mask & t -> t_mask) != 0)	/* not read yet */
	        {
	        sys_usr(m);
	        if ((m -> m_mask &= ~(t -> t_mask)) == 0)
	          {
	          remhdr(a, m);
	          putbuf(m);
	          puthdr(m);
	          }
	        return(m);
	        }
	return(NIL_MSG);
}

sys_usr(m)
struct msghdr *m;
{
	register char *s, *u;
	register int n, c;
	register struct buffer *b;

	u = buf_ptr;
	n = m -> m_size;
	if (n > buf_size)
	  {
	  n = buf_size;
	  status = BUFFER_OVERFLOW;
	  }
	else
	  status = n;
	b = m -> m_bufp;
	while (n > 0)
	  {
	  s = &(b -> b_buf);
	  for (c = 32; n > 0 && c > 0; n--, c--)
	    *u++ = *s++;
	  b = b -> b_link;
	  }
}

usr_sys(m)
struct msghdr *m;
{
	register char *s, *u;
	register int n, c;
	register struct buffer *b;

	u = buf_ptr;
	n = m -> m_size;
	b = m -> m_bufp;
	while (n > 0)
	  {
	  s = &(b -> b_buf);
	  for (c = 32; n > 0 && c > 0; n--, c--)
	    *s++ = *u++;
	  b = b -> b_link;
	  }
}

struct msghdr *aet_send()
{
	register struct aethdr *a;
	register struct trailr *t;
	register int mask, time;
	struct msghdr *insert_msg();

	status = ERR;
	if ((a = val_ptr(descript)) != NIL_AET)
	  if ((t = val_pcb(a)) != NIL_TLR)
	    {
	    mask = a -> a_mask & ~(t -> t_mask);
	    time = life_tim;
	    if (time < MIN_LIFETIME)
	      time = MIN_LIFETIME;
	    else if (time > MAX_LIFETIME)
	      time = MAX_LIFETIME;
	    return(insert_msg(a, mask, time));
	    }
	return(NIL_MSG);
}

struct msghdr *aet_osend()
{
	register struct aethdr *a;
	register struct msghdr *m;
	struct msghdr *insert_msg();

	status = ERR;
	if ((a = find_aether(aet_name)) != NIL_AET)
	  {
	  for (m = a -> a_newer; m != NIL_MSG; m = m -> m_newer)
	    if (m -> m_pcb == pcb)
	      break;
	  if (m == NIL_MSG && (a -> a_mask & 1) != 0)
	    return(insert_msg(a, 1, MIN_LIFETIME));
	  }
	return(NIL_MSG);
}

struct msghdr *insert_msg(a, mask, time)
struct aethdr *a;
int mask, time;
{
	register struct msghdr *m;

	if ((m = gethdr()) != NIL_MSG)
	  if ((m -> m_bufp = getbuf(buf_size)) != NIL_BUF)
	    if (all_ast(a, mask) == OK)
	      {
	      m -> m_size = buf_size;
	      m -> m_time = time;
	      m -> m_mask = mask;
	      m -> m_pcb = pcb;
	      usr_sys(m);
	      inshdr(a, m);
	      que_ast(a);
	      status = OK;
	      return(m);
	      }
	    else
	      {
	      putbuf(m);	/* return buffers */
	      puthdr(m);	/* return header */
	      }
	  else
	    puthdr(m);		/* return header */
	return(NIL_MSG);
}

aet_isend()
{
	register struct aethdr *a;
	register struct trailr *t;
	register int mask;

	status = ERR;
	if ((a = val_ptr(descript)) != NIL_AET)
	  if ((t = val_pcb(a)) != NIL_TLR)
	    {
	    mask = a -> a_mask & ~(t -> t_mask);
	    if (all_ast(a, mask) == OK)
	      {
	      que_ast(a);
	      status = OK;
	      }
	    }
}
