#-h- wc.r            2943  asc  25-apr-81 07:11:37  [002,100]
#-h- defns             48  asc  25-apr-81 07:08:34  [002,100]
 # include ratdef
 define(MAXNAME,FILENAMESIZE)
#-h- main            1530  asc  25-apr-81 07:08:34  [002,100]
# wc - count lines, words, and characters in named files or STDIN
 DRIVER(wc)

   character arg(MAXLINE)
   integer open, getarg, index
   integer fd, i, j, words, lines, chars, nfiles
   integer nl(2), nw(2), nc(2), tl(2), tw(2), tc(2)
   string total "total"
   string usestr "usage:  wc [-lwc] [file] ..."
   string null ""

   data words /YES/, lines /YES/, chars /YES/   # -lwc is default

   call query(usestr)
   initdi(tl)
   initdi(tw)
   initdi(tc)
   for (i = 1; getarg(i, arg, MAXNAME) ^= EOF; i = i + 1)
      if (arg(1) == MINUS & arg(2) ^= EOS) {
         lines = NO
         words = NO
         chars = NO
	call fold(arg)
	if (index(arg, LETL) > 0)
		lines = YES
	if (index(arg, LETW) > 0)
		words = YES
	if (index(arg, LETC) > 0)
		chars = YES
         }
      else {
         nfiles = nfiles + 1
         if (arg(1) == MINUS)
            fd = STDIN
         else
            fd = open(arg, READ)
         if (fd == ERR) {
            call putlin(arg, ERROUT)
            call remark(": can't open.")
            }
         else {
            call dowc(fd, nl, nw, nc)
            call printc(arg, nl, nw, nc, lines, words, chars)
	    adddi(nl,tl)
	    adddi(nw,tw)
	    adddi(nc,tc)
            if (fd ^= STDIN)
               call close(fd)
            }
         }
   if (nfiles == 0) {   # no args, do STDIN
      call dowc(STDIN, nl, nw, nc)
      call printc(null, nl, nw, nc, lines, words, chars)
      }
   else if (nfiles > 1)
      call printc(total, tl, tw, tc, lines, words, chars)
   DRETURN
   end
#-h- dowc             489  asc  25-apr-81 07:08:36  [002,100]
# dowc - count lines, words, and characters in fd
   subroutine dowc(fd, nl, nw, nc)
   integer fd, nl(2), nw(2), nc(2)
   character getch
   character c
   integer inword
 
   initdi(nl)
   initdi(nw)
   initdi(nc)
   inword = NO
   while (getch(c, fd) ^= EOF) {
      incrdi(nc)
      if (c == NEWLINE)
	 incrdi(nl)
      if (c == BLANK | c == NEWLINE | c == TAB)
         inword = NO
      else if (inword == NO) {
         inword = YES
	 incrdi(nw)
         }
      }
   return
   end
#-h- printc           628  asc  25-apr-81 07:08:37  [002,100]
# printc - print count statistics for arg
   subroutine printc(arg, nl, nw, nc, lines, words, chars)
   character arg(ARB), buf(MAXCHARS)
   integer ditoc
   integer nl(2), nw(2), nc(2), lines, words, chars, junk

   if (lines == YES)
      {
      junk = ditoc(nl, buf, MAXCHARS)
      call putstr(buf, 8, STDOUT)
      }
   if (words == YES)
      {
      junk = ditoc(nw, buf, MAXCHARS)
      call putstr(buf, 8, STDOUT)
      }
   if (chars == YES)
      {
      junk = ditoc(nc, buf, MAXCHARS)
      call putstr(buf, 8, STDOUT)
      }
   call putc(BLANK)
   call putlin(arg, STDOUT)
   call putc(NEWLINE)
   return
   end
#-h- wc.rof           922  asc  11-may-81 12:23:41  [002,100]
.pl 60
.bp 1
.in 0
.he 'WC (1)'2/15/79'WC (1)'
.sp 2
.in +3
.fi
.ti -3
NAME
.br
wc - count lines, words, and characters in files
.nf
.sp
.ti -3
SYNOPSIS
.br
wc [-lwc] [file] ...
.fi
.sp
.ti -3
DESCRIPTION
.br
Wc prints the number of lines, words, and characters in the named
files.
The filename "-" specifies the standard input.
A total is also printed.  A "word" is any sequence of characters
delimited by white space.
.sp
The options -l, -w, and -c specify, respectively, that only the line,
word, or character count be printed.  For example,
.sp
.in +3
.nf
wc -lc foo
.in -3
.sp
.fi
prints the number of lines and characters in "foo".
.sp
If no files are given, wc reads its standard input and the total
count is suppressed.
.fi
.sp
.ne 2
.ti -3
DIAGNOSTICS
.br
name: can't open
.in +5
Printed when an input file can't be opened; processing ceases
.in -5
.sp
.ti -3
AUTHORS
.br
David Hanson and friends (U. of Arizona)
