#-h- kwicsym          182  asc  24-apr-81 18:00:00  [002,100]
 ## definitions for kwic and unrot tools
 # put on a filed called 'kwicsym'
 
 define(FOLD,DOLLAR)	#character to indicate beginning of folded line
 define(MAXOUT,80)	#width of index
#-h- unrot.r         2170  asc  24-apr-81 18:00:02  [002,100]
#-h- main             616  asc  24-apr-81 17:59:51  [002,100]
 ## unrot - unrotate lines rotated by kwic

 include kwicsym
 DRIVER(unrot)
 
 character buf(MAXLINE)
 integer getarg, open, ctoi
 integer i, int, width, j, n
 
 data width /MAXOUT/
  
 call query("usage:  unrot [-n] [file] ...")
 for (i=1; getarg(i,buf,MAXLINE)!=EOF; i=i+1)
	{
	if (buf(1) == MINUS & buf(2) != EOS)
		{
		j = 2
		n = ctoi(buf,j)
		if (n > 0)
			width = n
		next
		}
	else if (buf(1) == MINUS)
		int = STDIN
	else
		{
		int = open(buf, READ)
		if (int == ERR)
			call cant(buf)
		}
	call nrot (int, width)
	if (int != STDIN)
		call close(int)
	}
 
 if (i==1)
	call nrot (STDIN, width)
 DRETURN
 end
#-h- nrot            1074  asc  24-apr-81 17:59:52  [002,100]
 ## nrot - unrotate lines from file -int-
 subroutine nrot(int, width)
 character inbuf(MAXLINE), outbuf(MAXLINE)
 integer getlin, index
 integer int, i, j, width, middle
 
 middle = max(width/2, 1)
 while (getlin(inbuf, int) != EOF)
	{
	for (i=1; i<width; i=i+1)		#blank line
		outbuf(i) = BLANK
	j = middle
	for (i=1; inbuf(i)!=FOLD & inbuf(i)!=NEWLINE; i=i+1)
		{
		j = j + 1			#copy up to FOLD
		if (i>1 & inbuf(i-1) == BLANK)
			if (nextj(+1,inbuf,i,j) >= width - 1)
				j = 1
			if (j >= width - 1)
				j = 1
		outbuf(j) = inbuf(i)
		}
	if (inbuf(i) == FOLD)			#copy second half
		{
		j = middle			#working backwards
		for (i=index(inbuf,NEWLINE)-1; i>0; i=i-1)
			{
			if (inbuf(i) == FOLD)
				break
			j = j -1
			if (inbuf(i+1) == BLANK)
				if (nextj(-1,inbuf,i,j) <= 0)
					j = width - 2
			if (j <= 0)
				j = width - 2
			outbuf(j) = inbuf(i)
			}
		}
	for (i=width-2; i > 0; i=i-1)
		if (outbuf(i) != BLANK)		#delete trailing blanks
			break
	outbuf(i+1) = NEWLINE			#terminate line properly
	outbuf(i+2) = EOS
	call putlin(outbuf, STDOUT)
	}
 
 return
 end
#-h- nextj            294  asc  24-apr-81 17:59:54  [002,100]
	## nextj - see if enough space for another word
	integer function nextj(incmnt,buf,i,j)
	character buf(ARB)
	integer incmnt, i, j, k
 
	nextj = j
	for (k=i; k>0; k = k + incmnt)
		{
		if (buf(k) == BLANK | buf(k) == FOLD | buf(k) == NEWLINE)
			break
		nextj = nextj + incmnt
		}
	return
	end
#-h- unrot.rof        859  asc  11-may-81 12:21:12  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'UNROT'1/15/79'UNROT'
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
unrot - unrotate lines rotated by kwic
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
unrot [-n] [file] ...
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
Unrot
processes the rotated output of 'kwic' to generate a keyword-in-context
index.
 
The -n flag may be used to specify the width of the output lines.
The default is 80.
 
If no input files are given, or the filename '-' appears, lines will
be read from standard input.
.sp 1
.in 
FILES 
.br 
.in 7 
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
kwic; sort
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
A message is printed if an input file cannot be opened; further processing
is terminated.
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
.sp 1 
Original from Kernighan and Plauger's 'Software Tools', with modifications
by Debbie Scherrer.
.sp 1 
.in 
BUGS 
.br 
.in 7 
