#-h- trsym            103  asc  25-apr-81 09:40:05  [002,100]
  ## definitions for TR tool
  # put on a file named 'trsym'
 # used only by tr
 
  define(MAXSET,100)
#-h- tr.r            2287  asc  25-apr-81 09:40:06  [002,100]
#-h- main            1421  asc  25-apr-81 09:39:50  [002,100]
 ## tr - transliterate characters on a file

 include trsym
 
 DRIVER(tr)
 
    character getc
    character arg(MAXLINE), c, from(MAXSET), to(MAXSET)
    integer getarg, length, makset, xindex
    integer allbut, collap, i, lastto

    string usestr "usage:  tr from [to]."
 
    call query(usestr)
    if (getarg(1, arg, MAXLINE) == EOF)
       call error(usestr)
    else if (arg(1) == NOT) {
       allbut = YES
       if (makset(arg, 2, from, MAXSET) == NO)
          call error('from: too large.')
       }
    else {
       allbut = NO
       if (makset(arg, 1, from, MAXSET) == NO)
          call error('from: too large.')
       }
    if (getarg(2, arg, MAXLINE) == EOF)
       to(1) = EOS
    else if (makset(arg, 1, to, MAXSET) == NO)
          call error('to: too large.')
 
    lastto = length(to)
    if (length(from) > lastto | allbut == YES)
       collap = YES
    else
       collap = NO
    repeat {
       i = xindex(from, getc(c), allbut, lastto)
       if (collap == YES & i >= lastto & lastto > 0) {  # collapse
          call putc(to(lastto))
          repeat
             i = xindex(from, getc(c), allbut, lastto)
             until (i < lastto)
          }
       if (c == EOF)
          break
       if (i > 0 & lastto > 0)   # translate
          call putc(to(i))
       else if (i == 0)      # copy
          call putc(c)
                   # else delete
       }
 
 #***
    DRETURN
    end
#-h- makset           301  asc  25-apr-81 09:39:52  [002,100]
 ## makset - make set from  array(k)  in  set
    integer function makset(array, k, set, size)
    integer addset
    integer i, j, k, size
    character array(ARB), set(size)
 
    i = k
    j = 1
    call filset(EOS, array, i, set, j, size)
    makset = addset(EOS, set, j, size)
    return
    end
#-h- xindex           379  asc  25-apr-81 09:39:52  [002,100]
 ## xindex - invert condition returned by index
    integer function xindex(array, c, allbut, lastto)
    character array(ARB), c
    integer index
    integer allbut, lastto
 
    if (c == EOF)
       xindex = 0
    else if (allbut == NO)
       xindex = index(array, c)
    else if (index(array, c) > 0)
       xindex = 0
    else
       xindex = lastto + 1
    return
    end
#-h- tr.rof          2583  asc  11-may-81 12:16:21  [002,100]
.pl 60 
.bp 
.in 0 
.rm 70 
.he 'TR'07/06/78'TR' 
.fo ''-#-'' 
.fi 
.in 7 
.ti -7 
NAME 
.br 
tr - character transliteration 
.sp 1 
.ti -7 
SYNOPSIS 
.br 
tr <infile >outfile from [to] 
.sp 1 
.ti -7 
DESCRIPTION 
.br 
"TR" copies the standard input to the standard output with 
substitution or deletion of selected characters.  Input 
characters found in "FROM" are mapped into the corresponding 
characters of "TO".
Ranges of characters may be specified by separating 
the extremes by a dash.
For example, a-z stands for the string of characters whose ascii
codes run from character a through character z.
 
If the number of characters 
in "FROM" is the same as in "TO", a one to one corresponding 
translation will be performed on all occurrences of the characters 
in "FROM".
If the number of characters in "FROM" is more than in "TO", the 
implication is that the last character in the "TO" string is 
to be replicated as often as necessary to make a string as long 
as the "FROM" string, and that this replicated character should 
be collapsed into only one.  If the "TO" string is missing or 
empty, "TR" will take this condition as a request to delete 
all occurrences of characters in the "FROM" string. 
.sp 1 
"TR" differs from the tool "CH" since it deals only with 
single characters or ranges of characters, while "CH" deals 
with character strings.  For example  tr xy yx  would change 
all x's into y's and all y's into x's, whereas ch xy yx 
change all the patterns "xy" into "yx". 
.sp 1 
One of the most common functions of "TR" is to translate 
upper case letters to lower case, and vice versa.  Thus, 
  
.ce 
tr A-Z a-z 
  
would map all upper case letters to lower 
case.
Users of systems which cannot pass
both upper and lower case characters on a command line 
should remember to include the appropriate escape flags.
.sp 1 
.ti -7 
FILES 
.br 
None 
.sp 1 
.ti -7 
SEE ALSO 
.br 
.nf 
Tools "find" and "ch". 
The "Software Tools" book, p.51-61. 
The "UNIX Programmer's Manual", p. TR(I). 
.fi 
.sp 1 
.ti -7 
DIAGNOSTICS 
.br 
"usage: translit from to." 
.br 
.in +5 
The command line passed to transit is in error. 
.br 
.in -5 
"from: too large." 
.br 
.in +5 
The string for "from" is too large.  Current limit is 100 characters 
including E0S. 
.br 
.in -5 
"to: too large." 
.br 
.in +5 
The string for "to" is too large.  Current limit is 100 characters 
including EOS. 
.sp 1 
.in -5 
.ti -7 
AUTHORS 
.br 
Original code from Kernighan and Plaugers's "Software Tools", 
with modifications by Debbie Scherrer. 
.sp 1 
.ti -7 
BUGS/DEFICIENCIES 
.br 
