#-h- ruler.r         1227  asc  26-apr-81 20:48:32  [002,100]
#-h- main            1165  asc  26-apr-81 20:48:21  [002,100]
## Ruler - Draw a `ruler' <n> columns wide on STDOUT.

 DRIVER(ruler)
define(NUMSTRSIZE,12)

character nstr(NUMSTRSIZE)
integer   i, n
integer   alldig, ctoi, getarg # function(s)
string    digstr "0123456789"
string    usestr "usage:  ruler [n]."

call query(usestr)
if( getarg( 1, nstr, NUMSTRSIZE) == EOF )
  n = 80 # Default width
else if( alldig( nstr) == NO ) # Output error message
  call error(usestr)
else
{
  i = 1
  n = ctoi( nstr, i)
  n = min( n, MAXLINE) # Limit  1 <= width <= MAXLINE
  n = max( n, 1)
}

for( i = 1 ; i <= n ; i = i + 1 ) # Output top row of ruling.
  if( mod( i, 10) == 0 )
    call putc( PLUS)
  else
    call putc( MINUS)

call putc( NEWLINE)

for( i = 1 ; i <= n ; i = i + 1 ) # Output `tens' digits.
  if( mod( i, 10) == 0 )
    call putc( digstr( mod( mod( i, 100)/10, 10) + 1 ))
  else
    call putc( BLANK)

call putc( NEWLINE)

for( i = 1 ; i <= n ; i = i + 1 ) # Output `ones' digits.
  call putc( digstr( mod( i, 10) + 1 ))

call putc( NEWLINE)

for( i = 1 ; i <= n ; i = i + 1 ) # Output bottom row of ruling.
  if( mod( i, 10) == 0 )
    call putc( PLUS)
  else
    call putc( MINUS)

call putc( NEWLINE)


 DRETURN
end
#-h- ruler.rof        709  asc  08-may-81 17:24:39  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he ;RULER;10/29/80;RULER;
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
ruler - display ruler on terminal screen
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
ruler [n]
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
ruler displays a ruler on the terminal.  This is especially useful when
using field or other utilities which require knowledge of the column
positions of portions of the screen.  The optional numeric argument
indicates how many columns to format in the ruler.
.sp 1
.in 
FILES 
.br 
.in 7 
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
field - utility for field manipulation
.br
sort - file sorter
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
Joe Sventek
.sp 1 
.in 
BUGS 
.br 
.in 7 
