#-h- mailsym          268  asc  29-apr-81 19:47:29  [002,100]
# symbol definitions used by:   mail,   postmn
# should be placed on a file named     mailsym
#
 define(UNKNOWN,-1)
 define(USERSIZE,40)
 define(TERMEOF,"^Z")
 define(TIMEZONE,"PST")
 define(RIGHTMARGIN,72)
 define(MEM_SIZE,2000) # size of dynamic storage in integers
#-h- cmail            445  asc  29-apr-81 19:47:30  [002,100]
# common block used by:  mail
# should be placed on a file named     cmail
#
 common / cmail /  nusers, regist, edit, temp1(FILENAMESIZE),
		   temp2(FILENAMESIZE)

 integer nusers		#  number of validated users to send mail to
 integer regist		#  whether mail is registered or not
 integer edit		#  whether to invoke editor to generate mail to send
 character temp1	#  name of mail temporary file
 character temp2	#  name of mail temporary file
#-h- mail.r          8802  asc  29-apr-81 19:47:32  [002,100]
#-h- main             837  asc  24-apr-81 10:15:34  [002,100]
 DRIVER(mail)
 
 include mailsym
 
 character arg(FILENAMESIZE), buf(MAXLINE), file(FILENAMESIZE)
 integer i, int, n, junk
 integer getarg, equal, open, getlin, index, getwrd
 
 include cmail

 string all "all"
 string flags "+-?"

 call query("usage:  mail [-lmlist] [-re] [all] [addressee] ...")
 call malint(arg, file, buf)
 for (i=1; getarg(i, arg, FILENAMESIZE) != EOF; i=i+1)
    {
    call fold(arg)
    if (equal(arg, all) == YES)
	{
	call adrfil(file)
	int = open(file, READ)
	if (int != ERR)
	    {
	    while (getlin(buf, int) != EOF)
		{
		n = 1
		junk = getwrd(buf, n, arg)
		if (junk > 0)
		    call addusr(arg, buf)
		}
	    call close(int)
	    }
	}
    else if (index(flags, arg(1)) > 0)
	call malcmd(arg, file, buf)
    else
	call addusr(arg, buf)
    }
 if (nusers != 0)
    call sdmail(buf, arg, file)

 DRETURN
 end
#-h- addusr           689  asc  24-apr-81 10:15:35  [002,100]
 #	addusr -- subroutine to add user to stack of users for mail

 subroutine addusr(arg, temp)

 character arg(USERSIZE), temp(FILENAMESIZE)
 integer int, init
 integer create, tblook

 include cmail

 string t1 "mt1"
 string t2 "mt2"

 data init /YES/

 if (init == YES)
    {
    call scratf(t1, temp1)
    call scratf(t2, temp2)
    int = create(temp1, WRITE)
    if (int == ERR)
	call merror(temp1)
    init = NO
    }
 if (arg(1) == EOS)
    call close(int)
 else if (tblook(arg, temp) == YES)
    {
    nusers = nusers + 1
    call putlin(arg, int)
    call putch(NEWLINE, int)
    }
 else
    {
    call putlin("Invalid user name: ", ERROUT)
    call remark(arg)
    }

 return
 end
#-h- badarg           130  asc  24-apr-81 10:15:36  [002,100]
 subroutine badarg(arg)

 character arg(ARB)

 call putlin("Ignoring invalid argument: ", ERROUT)
 call remark(arg)

 return
 end
#-h- cleanf            98  asc  28-apr-81 00:10:57  [002,100]
 subroutine cleanf

 include cmail

 call remove(temp1)
 call remove(temp2)
 call endst(OK)

 end
#-h- dotost           673  asc  24-apr-81 10:15:38  [002,100]
 subroutine dotost(out, user)

 integer out, in, i, j, n
 integer open, length, getlin
 character user(USERSIZE)

 include cmail

 string tos "To:     "
 string bls "        "

 in = open(temp1, READ)
 if (in == ERR)
    call merror(temp1)
 call putlin(tos, out)
 j = 9
 for (i=getlin(user,in); i !=  EOF; i=getlin(user,in))
    {
    user(i) = EOS
    n = j + length(user) + 1
    if (n > RIGHTMARGIN)
	{
	call putch(COMMA, out)
	call putch(NEWLINE, out)
	call putlin(bls, out)
	j = 9
	}
    if (j > 9)
	call putch(COMMA, out)
    call putch(BLANK, out)
    call putlin(user, out)
    j = j + length(user) + 2
    }
 call putch(NEWLINE, out)
 call close(in)

 return
 end
#-h- editit           475  asc  29-apr-81 19:44:33  [002,100]
 subroutine editit(file, buf)

 character file(FILENAMESIZE), buf(ARB), proc(FILENAMESIZE), pid(PIDSIZE)
 integer i, spawn, loccom

 string suffix IMAGE_SUFFIX
 string ed "ed"

 call impath(buf)
 if (loccom(ed, buf, suffix, proc) != BINARY)
    call error("Cannot locate ed image file.")
 i = 1
 call stcopy(ed, 1, buf, i)
 call chcopy(BLANK, buf, i)
 call scopy(file, 1, buf, i)
 if (spawn(proc, buf, pid, WAIT) == ERR)
    call error("Error in spawning ed!")

 return
 end
#-h- gsbjct           277  asc  24-apr-81 10:15:40  [002,100]
 subroutine gsbjct(buf)

 character buf(MAXLINE)
 integer n
 integer isatty, prompt

 string subjct "Subject: "

 if (isatty(STDIN) == YES)
    {
    n = prompt(subjct, buf, STDIN)
    if (n >= 1)
	buf(n) = EOS
    else
	buf(1) = EOS
    }
 else
    buf(1) = EOS

 return
 end
#-h- malcmd           926  asc  24-apr-81 10:15:40  [002,100]
 ##	malcmd -- interprets command selectes for mail
 
 subroutine malcmd(iarg, out, buf)
 
 character iarg(FILENAMESIZE), mllist(FILENAMESIZE), out(FILENAMESIZE),
	   buf(MAXLINE)
 integer i, int, open, getlin, getwrd, index
 
 include cmail
 
 if (iarg(1) == MINUS & iarg(2) == LETL)
    {
    call scopy(iarg, 3, mllist, 1)
    int = open(mllist, READ)
    if (int != ERR)
	{
	while (getlin(buf, int) != EOF)
	    {
	    i = index(buf, SHARP)	# pound sign signals start of comment
	    if (i > 0)
		buf(i) = EOS		# terminate scan for users there
	    i = 1
	    while (getwrd(buf, i, out) > 0)
		call addusr(out, iarg)
	    }
	call close(int)
	}
    else
	{
	call putlin("Error in opening mailing list file: ", ERROUT)
	call remark(mllist)
	}
    }
 else if (iarg(1) == MINUS)
    {
    if (index(iarg, LETR) > 0)
        regist = YES
    if (index(iarg, LETE) > 0)
	edit = YES
    }
 else
    call badarg(iarg)
 return
 end
#-h- malinp          1263  asc  24-apr-81 10:15:42  [002,100]
 subroutine malinp(temp, file, buf, edit)

 integer edit, int, open, isatty, create, getlin, inp, fsize, prompt
 character file(FILENAMESIZE), buf(MAXLINE), clower, temp(FILENAMESIZE)

 string mts "mts"

 int = create(temp, WRITE)
 if (int == ERR)
    call merror(temp)
 call gsbjct(buf)
 call pstmrk(int, buf)
 inp = STDIN
 if (isatty(STDIN) == YES)
    {
    if (edit == YES)
        {
        call scratf(mts, file)
        call remark("You are now entering ed to create your mail")
        call remark("Please wait for ed to respond with 0")
        call editit(file, buf)
        inp = open(file, READ)
        if (inp == ERR | fsize(file) == 0)
            {
	    call close(inp)
            call remove(file)
            call close(int)
            call cleanf
            }
        }
    else
        {
        call putlin("Input message: (q to quit or ", ERROUT)
        call putlin(TERMEOF, ERROUT)
        call remark(" to send)")
        }
    }
 while (getlin(buf, inp) != EOF)
    if (clower(buf(1)) == LETQ & buf(2) == NEWLINE & edit == NO)
        {
        call close(int)
        call cleanf
        }
    else
        call putlin(buf, int)
 call close(int)
 if (inp != STDIN)
    {
    call close(inp)
    call remove(file)
    }

 return
 end
#-h- malint           583  asc  24-apr-81 10:15:43  [002,100]
 subroutine malint(arg, file, buf)

 character arg(FILENAMESIZE), file(FILENAMESIZE), buf(MAXLINE)
 integer int, i, junk
 integer open, getlin, getwrd

 include cmail

 DS_DECL(Mem,MEM_SIZE)	# dynamic storage region for symbol table

 nusers = 0
 regist = NO
 edit = NO
 call adrfil(file)
 call tbinit(MEM_SIZE)
 int = open(file, READ)
 if (int != ERR)
    {
    while (getlin(buf, int) != EOF)
	{
	i = 1
	junk = getwrd(buf, i, arg)
	junk = getwrd(buf, i, file)
	call tbinst(arg, file)
	}
    call close(int)
    }
 else
    call error("Cannot open local users file.")

 return
 end
#-h- merror           149  asc  24-apr-81 10:15:44  [002,100]
 subroutine merror(buf)

 character buf(ARB)

 call putlin("Cannot open mail temporary file: ", ERROUT)
 call remark(buf)
 call cleanf

 return
 end
#-h- pstmrk           827  asc  27-apr-81 23:37:40  [002,100]
 subroutine pstmrk(int, subjct)
 
 character idate(10), itime(10), user(USERSIZE), cupper
 character hdrpat(4), subjct(ARB)
 integer int, now(7)

 string dates "Date:    "
 string dashst " - "
 string timzon TIMEZONE
 string froms "From:    "
 string subjs "Subject: "

 data hdrpat/1, 1, NEWLINE, EOS/

 call mailid(user)
 user(1) = cupper(user(1))
 call getnow(now)
 call fmtdat(idate, itime, now, LETTER)
 call putlin(hdrpat, int)
 call putlin(dates, int)
 call putlin(idate, int)
 call putch(BLANK, int)
 call putlin(itime, int)
 call putlin(dashst, int)
 call putlin(timzon, int)
 call putch(NEWLINE, int)
 call putlin(froms, int)
 call putlin(user, int)
 call putch(NEWLINE, int)
 call putlin(subjs, int)
 call putlin(subjct, int)
 call putch(NEWLINE, int)
 call dotost(int, user)
 call putch(NEWLINE, int)

 return
 end
#-h- sdmail          1069  asc  24-apr-81 10:15:46  [002,100]
 subroutine sdmail(buf, file, user)

 character buf(MAXLINE), file(FILENAMESIZE), user(FILENAMESIZE)
 integer inp, int, n, junk, out
 integer open, getlin, tblook, create
 linepointer topfil

 include cmail

 string mymail "mymail"

 call addusr(EOS)
 call malinp(temp2, file, buf, edit)
 inp = open(temp2, READ)
 if (inp == ERR)
    call merror(temp2)
 call markl(inp, topfil)
 int = open(temp1, READ)
 if (int ==  ERR)
    {
    call close(inp)
    call merror(temp1)
    }
 for (n=getlin(buf,int); n != EOF; n=getlin(buf,int))
    {
    buf(n) = EOS
    junk = tblook(buf, file)
    call concat(file, mymail, file)
    call seek(topfil, inp)
    out = create(file, APPEND)
    if (out == ERR)
        {
        call putlin("Cannot send mail to ", ERROUT)
        call remark(buf)
        }
    else
        {
	call fcopy(inp, out)
        call close(out)
        if (regist == YES)
            {
            call putlin("Mail posted to ", ERROUT)
            call remark(buf)
            }
        }
    }
 call close(int)
 call close(inp)
 call cleanf
 return
 end
#-h- mail.rof        2239  asc  08-may-81 16:45:50  [002,100]
.in 5
.rm 70
.pl 60
.he 'MAIL'1/11/79'MAIL'
.fo //-#-/
.bp 1
NAME
.in +3

mail
- utility for sending mail to local users

.ti -3
SYNOPSIS

mail [-er] [-listfile] ... [addressee] ...

.ti -3
DESCRIPTION

mail
is a tool designed to allow the user to send mail to
fellow users of any system which supports the software tools shell.  It
operates as follows:

.in +5
.rm -2
The addressees specified in
the command line and in any mailing list files specified are
validated.  If there were any valid users, the standard input is
read up to an end-of-file and then mailed to each valid user with
an appropriate postmark. (Note: if one wishes to terminate the mail
session without sending any mail, type a line consisting of only
the letter
q
[for quit] during the input of mail.)
Mailing list files are specified with
the
-l
switch in the command line.  The structure of the mailing
list files is described below.  The
-r
switch indicates to
mail
that the user wishes to be notified as the mail is posted to each
addressee ('posted' implying that the mail has been appended successfully to the
addressee's mail file).  The names of valid users may be obtained
by prior invocation of the
users
command.  The
-e
flag will cause the editor "ed" to be invoked, allowing the user
to perform complex mail composition.
.sp
.in -5
.rm +2
The mailing list files have a very simple structure: user names
separated by blanks and tabs, with as many users per line as
desired.  A pound sign (#) appearing anywhere on a line indicates
the start of a comment field, and the rest of the line is ignored
by mail.  This allows the user complete flexibility in commenting
her/his mailing lists for informational purposes.
.sp
Broadcast mailings are supported, also.  One must merely specify
`all'
as an addressee in the command line.
.sp
.ti -3
FILES
.sp
mymail
- file for storage of each users mail
.br
mbox
- file for storage of saved mail
.br
three temporary files are used by mail
.sp
.ti -3
SEE ALSO
.sp
users
- a program to list users on current host
.br
postmn
- a program which notifies user of existence of mail
.br
msg - the utility for reading and sorting one's mail
.sp
.ti -3
AUTHOR
.sp
mail was written by Joe Sventek
.sp
.ti -3
BUGS/DEFICIENCIES
.br
