#-h- cld              328  asc  14-may-81 07:29:06  [002,100]
#----------------------------------------------------------------
 ## cld common block for 'ld' tool
 #  put on a file named 'cld'
 common / cld / verbos, debug, task(FILENAMESIZE)

 integer verbos		# if verbose taskbuild; init = NO
 integer debug		# if debugging aid desired in task; init=NO
 character task		# task image name
#-h- flist            277  asc  14-may-81 07:29:07  [002,100]
  #------------------------------------------------------
  # flist - common block
  # should be put on a file named 'flist'
 
  common /flist/  flevel, ffiles(FILENAMESIZE, FLMAX)
    
    integer flevel	#pointer to current file
    character ffiles	#list of files to process
#-h- ld.r            4553  asc  14-may-81 07:29:09  [002,100]
#-h- defns             35  asc  23-apr-81 13:50:04  [002,102]
define(FLMAX,25)
define(EXTSIZE,4)
#-h- main            3034  asc  14-may-81 07:28:40  [002,100]
 DRIVER(ld)

 character arg(FILENAMESIZE), templ8(FILENAMESIZE),
	   scrat(FILENAMESIZE), rlib(FILENAMESIZE),
	   args(arith(FILENAMESIZE,*,3)), map(FILENAMESIZE)
 integer i, getarg, int, create, status, spawn, rlibdn, open, inp, loccom

 include cld
 include flist

 string suffix NO_SUFFIX
 string usestr "usage:  ld [-dv] [-l[libr]] [-pproc] file ..."
 string tkb "tkb"
 string ext "tsk"
 string mapext "map"
 string debsw "/da,"
 string lib "/lb"
 string rlibst "rlib.olb"
 string mainst ":.main."
 string infile "tools.tkb"

 ifelse(FLOAT_PT,YES,string imgsw "/fp/cp",string imgsw "/-fp/cp")

 call query(usestr)
 flevel = 0
 task(1) = EOS
 verbos = NO
 debug = NO
 rlibdn = NO

 for (i=1; getarg(i, arg, FILENAMESIZE) != EOF; i=i+1)
    {
    if (arg(1) == MINUS | arg(1) == PLUS)
	call ldcmd(arg)
    else
	call fstack(arg)
    }

 if (task(1) == EOS)
    {
    for (i=1; i<=flevel; i=i+1)
	if (ffiles(1,i) != MINUS) break
    if (i <= flevel)
	call scopy(ffiles(1,i), 1, task, 1)
    }

 if (task(1) == EOS)
    call error(usestr)
 call scratf(tkb, scrat)
 int = create(scrat, WRITE)
 if (int == ERR)
    call error("Error creating TKB command file.")
 call impath(args)
 if (loccom(rlibst, args, suffix, rlib) == ERR)
    call error("Cannot locate rlib.olb")
 call concat(rlib, lib, rlib)
 if (loccom(infile, args, suffix, templ8) == ERR)
    call error("Cannot locate tools.tkb")
 call genfil(task, ext, arg)
 call genfil(task, mapext, args)
 call mklocl(arg, task)
 call remove(task)		# delete most recent version of task image
 call putlin(task, int)
 call putlin(imgsw, int)
 if (debug == YES)
    {
    call mklocl(args, map)
    call remove(map)		# delete most recent version of map file
    call putlin(debsw, int)
    call putlin(map, int)
    }
 call putch(EQUALS, int)
 call putch(NEWLINE, int)
 for (i=1; i<=flevel; i=i+1)
    {
    if (ffiles(1,i) == MINUS)
	{
	if (ffiles(3,i) == EOS)		# desires rlib in odd place
	    {
	    call putlin(rlib, int)
	    call putch(NEWLINE, int)
	    rlibdn = YES
	    }
	else
	    {
	    call mklocl(ffiles(3,i), arg)
	    call putlin(arg, int)
	    call putlin(lib, int)
	    call putch(NEWLINE, int)
	    }
	}
    else
	{
	call mklocl(ffiles(1,i), arg)
	call putlin(arg, int)
	call putch(NEWLINE, int)
	}
    }
 call putlin(rlib, int)
 call putlin(mainst, int)
 call putch(NEWLINE, int)
 if (rlibdn == NO)
    {
    call putlin(rlib, int)
    call putch(NEWLINE, int)
    }
 inp = open(templ8, READ)
 if (inp == ERR)
    call error("Error opening tools.tkb template file.")
 call fcopy(inp, int)
 call close(inp)
 call close(int)
 i = 1
 call stcopy(tkb, 1, args, i)
 call chcopy(BLANK, args, i)
 call chcopy(ATSIGN, args, i)
 call scopy(scrat, 1, args, i)
 if (verbos ==  YES)
    {
    int = open(scrat, READ)
    if (int == ERR)
	call error("Error in opening TKB command file.")
    call fcopy(int, ERROUT)
    call close(int)
    }
 status = spawn("local", args, arg, WAIT)
 if (status == ERR)
    call remark("Error in spawning TKB.")
 call remove(scrat)
 
 DRETURN
 end
#-h- fstack           330  asc  23-apr-81 13:50:08  [002,102]
   ## fstack - generate stack of input files
 
   subroutine fstack (iarg)
 
   integer i
   character iarg(FILENAMESIZE)
 
   include flist
 
   if (flevel < FLMAX)
     {
     flevel = flevel + 1
     for (i=1; i<=FILENAMESIZE; i=i+1)
         ffiles(i,flevel) = iarg(i)
    call fold(ffiles(1, flevel))
     }
   return
   end
#-h- genfil           464  asc  29-apr-81 19:26:24  [002,100]
##	genfil -- generates file name with extension ext from in

 subroutine genfil(in, ext, out)

 integer i, j
 integer length
 character in(FILENAMESIZE), ext(EXTSIZE), out(FILENAMESIZE)

 string trmchr "/]"

 for (i=length(in); i > 0; i=i-1)
    if (index(trmchr, in(i)) > 0)
	break
 for (j=i+1; in(j) != EOS; j=j+1)
    if (in(j) == PERIOD)
	break
 for (i=1; i < j; i=i+1)
    out(i) = in(i)
 call chcopy(PERIOD, out, i)
 call scopy(ext, 1, out, i)

 return
 end
#-h- ldcmd            380  asc  23-apr-81 13:50:10  [002,102]
 subroutine ldcmd(arg)

 character arg(FILENAMESIZE)
 integer index

 include cld

 call fold(arg)
 if (arg(1) == MINUS)
    if (arg(2) == LETP)
        call scopy(arg, 3, task, 1)
    else if (arg(2) == LETL)
        call fstack(arg)
    else
	{
	if (index(arg, LETD) > 0)
	    debug = YES
	if (index(arg, LETV) > 0)
	    verbos = YES
	}
 else
    call badarg(arg)

 return
 end
#-h- ld.rof          1620  asc  14-may-81 07:29:13  [002,100]
.pl 60
.in 5
.rm 70
.he /LD/%/LD/
.fo //-#-/
.bp 1
.in +3
.ti -3
NAME

ld
- loader

.ti -3
SYNOPSIS

ld [-d] [-l[libname]] [-ptaskname] name ...

.ti -3
DESCRIPTION

ld
links together the named modules in the order given, searches the system
libraries to resolve global references and generates an executable process.

ld
understands three flags:

.in +3
.ti -3
-d causes `ld' to do whatever is necessary to incorporate a
system-specific debugger into the image.

.ti -3
-l
signifies that the filename concatenated to the flag is a library name.  -l
alone stands for the ratfor system library, rlib.  The default extension for
a library file is '.olb'.  A library is searched when its name is
encountered, so the placement of -l is significant.  If the ratfor system
library is not explicitly mentioned, it is searched after all other files
have been linked.  The fortran system library is searched at the very end.

.ti -3
-p
signifies that the file name concatenated to the flag is to be the
process name.  If this option is not specified, the process name is
determined in one of two ways:

.in +3
.ti -3
1. The first non-library file name (eg. roff.o) is found, and the file's
extension is replaced by '.tsk' (roff.tsk).  This is then the resulting
process name.

.ti -3
2. Failing 1 (implying that all files listed in the argument list are
libraries), the process image is placed on the file a.out, overwriting
the previous contents of that file.

.in -3
.in -3
.ti -3
AUTHOR

Joe Sventek wrote the interface of
ld
to the DEC task builder.

.ti -3
BUGS

The creation of the process on a.out is not yet implemented.
