#-h- kwicsym          182  asc  24-apr-81 18:04:28  [002,100]
 ## definitions for kwic and unrot tools
 # put on a filed called 'kwicsym'
 
 define(FOLD,DOLLAR)	#character to indicate beginning of folded line
 define(MAXOUT,80)	#width of index
#-h- kwic.r          1456  asc  24-apr-81 18:04:29  [002,100]
#-h- main             573  asc  24-apr-81 18:04:19  [002,100]
 ## kwic - make keyword in context index

 include kwicsym
 DRIVER(kwic)
 
 character buf(MAXLINE)
 integer getarg, open, getlin
 integer i, int
 
 call query("usage:  kwic [file] ...")
 for (i=1; getarg(i,buf,MAXLINE)!=EOF; i=i+1)
	{
	if (buf(1) == MINUS & buf(2) == EOS)
		int = STDIN
	else
		{
		int = open(buf,READ)
		if (int == ERR)
			call cant(buf)
		}
	while(getlin(buf,int) != EOF)
		call putrot(buf, STDOUT)
	if (int != STDIN)
		call close(int)
	}
 
 if (i==1)		#Read from standard input
	while (getlin(buf,STDIN) != EOF)
		call putrot(buf, STDOUT)
 DRETURN
 end
#-h- putrot           399  asc  24-apr-81 18:04:21  [002,100]
 ## putrot - create lines with keyword at front
 subroutine putrot (buf, outfil)
 
 character type
 character buf(ARB), t
 integer i, outfil
 
 for (i=1; buf(i) != NEWLINE; i=i+1)
	{
	t = type(buf(i))
	if (t == LETTER | t == DIGIT)	#alpha
		{
		call rotate(buf, i, outfil)	#token starts at 'i'
		t = type(buf(i+1))
		for (; t==LETTER | t==DIGIT; t=type(buf(i+1)))
			i = i + 1
		}
	}
 
 return
 end
#-h- rotate           298  asc  24-apr-81 18:04:22  [002,100]
 ## rotate - output rotated line
 subroutine rotate(buf, n, outfil)
 
 character buf(ARB)
 integer i, n, outfil
 
 for (i=n; buf(i) != NEWLINE; i=i+1)
	call putch(buf(i), outfil)
 call putch(FOLD, outfil)
 for (i=1; i<n; i=i+1)
	call putch(buf(i), outfil)
 call putch(NEWLINE, outfil)
 return
 end
#-h- kwic.rof         994  asc  06-may-81 08:09:53  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'KWIC'1/15/79'KWIC'
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
kwic - make keyword in context index
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
kwic [file] ...
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
Kwic
rotates lines from the input files so that each word in the sentence
appears at the beginning of a line, with a special character marking
the original position of the end of the line.
The output from kwic is typically sorted with 'sort' and then
unrotated with 'unrot' to produce a keyword-in-context index.
 
If no input files are given, or if the filename '-' appears, lines
will be read from standard input.
.sp 1
.in 
FILES 
.br 
.in 7 
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
unrot; sort
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
A message is printed if an input file cannot be opened; further
processing is terminated.
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
.sp 1 
Original from Kernighan and Plauger's 'Software Tools', with modifications
by Debbie Scherrer.
.sp 1 
.in 
BUGS 
.br 
.in 7 
