#-h- incl.r          1645  asc  27-apr-81 15:54:46  [002,100]
#-h- defns            210  asc  27-apr-81 15:54:39  [002,100]
 # definitions for INCL tool
 # put on a file named 'inclsym'
 # Used only by the include tool
 
 define(NFILES,arith(MAXOFILES,-,3))	#max nbr of included files
			#(should be max nbr of open files allowed -3)
#-h- main            1311  asc  27-apr-81 15:54:40  [002,100]
 ## incl - replace include file by contents of line
 DRIVER(incl)
 character line(MAXLINE), str(MAXLINE)
 integer equal, getlin, getwrd, open
 integer infile(NFILES), len, level, loc
 integer getarg, i
 character incld(8)
 data incld(1) /LETI/
 data incld(2) /LETN/
 data incld(3) /LETC/
 data incld(4) /LETL/
 data incld(5) /LETU/
 data incld(6) /LETD/
 data incld(7) /LETE/
 data incld(8) /EOS/
 
 call query("usage:  incl [file] ...")
 for (i=1; ; i=i+1)
	{
	if (getarg(i, line, MAXLINE) == EOF)
		{
		if (i!= 1)  break
		infile(1) = STDIN
		}
	else if (line(1) == MINUS & line(2) == EOS)
		infile(1) = STDIN
	else
		{
		infile(1) = open(line,READ)
		if (infile(1) == ERR)
			call cant (line)
		}
	for (level=1; level > 0; level = level - 1)
		{
		while (getlin(line, infile(level)) != EOF)
			{
			loc = 1
			len = getwrd(line, loc, str)
			call fold(str)		#fold to lower case
			if (equal(str,incld) == NO)
				call putlin (line, STDOUT)
			else
				{
				level = level + 1
				if (level > NFILES)
				  call error ('includes nested too deeply.')
				len = getwrd(line, loc,str)
				infile(level) = open(str,READ)
				if (infile(level) == ERR)
				  call cant (str)
				}
			}
		if (infile(level) != 1)
			call close (infile(level))
		}
	if (infile(1) != STDIN)
		call close (infile(1))
	}
 
 DRETURN
 end
#-h- incl.rof        1506  asc  06-may-81 08:04:15  [002,100]
.bp 
.pl 60 
.in 0 
.rm 70 
.he (INCL(07/10/78(INCL 
.fo ((-#- 
.fi 
.in 7 
.rm 70 
.ti -7 
NAME 
.br 
incl - expand included files 
.sp 1 
.ti -7 
SYNOPSIS 
.br 
incl [file] ... 
.sp 1 
.ti -7 
DESCRIPTION 
.br 
Include copies the input files to the standard output.  Whenever an input 
line begins with 
  
.ce 
include filename 
  
the entire contents of filename will be copied to the standard output. 
If no input files are specified, the standard input is copied. 
An included file may include further includes. 
Multiple input files are allowed. 
Include is used to bring in much-used routines, common declarations 
or definitions, thus insuring use of the same version by all programs. 
.sp 1 
.ti -7 
FILES 
.br 
none 
.sp 1 
.ti -7 
SEE ALSO 
.br 
Kernighan and Plauger's "Software Tools", pages 74-77. 
.br 
The software tools "ratfor" tutorial
.sp 1 
.ti -7 
DIAGNOSTICS 
.br 
includes nested too deeply 
.br 
.in +6 
The depth of included files allowed is dependent upon the maximum
number of open files allowed in the following manner:  
.ce
MAXOFILES - 3
.br 
.sp
.in -6 
filename:  can't open 
.br 
.in +6 
File could not be located or maximum number of opened files was exceeded. 
.sp 1 
.in -6 
.ti -7 
AUTHORS 
.br 
Original code by Kernighan and Plauger in "Software Tools", 
with modifications by Ardith Kenney. 
.sp 1 
.ti -7 
BUGS/DEFICIENCIES 
.br 
The depth of included files allowed is dependent upon the maximum
number of open files allowed by the implementor of the primitives.
