#-h- cfc              493  asc  14-may-81 07:33:39  [002,100]
 #----------------------------------------------------------
 ## cfc common block for 'fc' tool
 #  put on a file called 'cfc'
 
 common / cfc / load, verbos, list, errcnt, debug

 integer load	# YES/NO for link
 integer verbos	# YES/NO for verbose mutterings on terminal
 integer list	# YES/NO for listings of fortran compilations
 integer errcnt	# running count of errors in compilation -- load
		# not performed unless errcnt == 0
 integer debug	# YES/NO if -d switch seen; passed on to ld
#-h- flist            277  asc  14-may-81 07:33:40  [002,100]
  #------------------------------------------------------
  # flist - common block
  # should be put on a file named 'flist'
 
  common /flist/  flevel, ffiles(FILENAMESIZE, FLMAX)
    
    integer flevel	#pointer to current file
    character ffiles	#list of files to process
#-h- fc.r            5052  asc  14-may-81 07:33:42  [002,100]
#-h- defns             37  asc  29-apr-81 19:22:38  [002,100]
	define(EXTSIZE,4)
	define(FLMAX,25)
#-h- main            2005  asc  29-apr-81 19:22:40  [002,100]
 DRIVER(fc)

 character source(FILENAMESIZE), object(FILENAMESIZE), arg(FILENAMESIZE),
	   ext(EXTSIZE), listfl(FILENAMESIZE),
	   ldargs(ARGBUFSIZE), descr(PIDSIZE), spath(arith(FILENAMESIZE,*,3))
 integer i, getarg, spawn, k, fortrn, loccom, index

 include flist
 include cfc
 
 string suffix IMAGE_SUFFIX
 string minusv "-v "
 string minusd "-d "
 string exto "obj"
 string extl "l"
 string ld "ld"

 flevel = 0
 load = YES
 verbos = NO		# initialize cfc and flist varibles
 list = NO
 debug = NO
 errcnt = 0

 call query("usage:  fc [-cdov] [-l[libr]] [-pproc] file ...")
 for (i=1; getarg(i, arg, FILENAMESIZE) != EOF; i=i+1)
    {
    if (arg(1) == MINUS | arg(1) == PLUS)
	call fccmd(arg)
    else
	call fstack(arg)
    }

 for (k=1; k<=flevel; k=k+1)
    {
    call getext(ffiles(1,k), ext)
    if (ffiles(1,k) != MINUS & ext(1) == LETF & ext(2) == EOS)
	{
	if (index(ffiles(1,k), SLASH) > 0)
	    call mklocl(ffiles(1,k), source)
	else
	    call scopy(ffiles(1,k), 1, source, 1)
	call genfil(source, exto, object)
	if (list == YES)
	    call genfil(source, extl, listfl)
	else
	    listfl(1) = EOS
	if (fortrn(source, object, listfl, verbos, debug) == ERR)
	    errcnt = errcnt + 1
	}
    }


 if (load == YES & errcnt == 0)
    {
    i = 1
    call stcopy(ld, 1, ldargs, i)
    call chcopy(BLANK, ldargs, i)
    if (verbos == YES)
	call stcopy(minusv, 1, ldargs, i)
    if (debug == YES)
	call stcopy(minusd, 1, ldargs, i)
    for (k=1; k<=flevel; k=k+1)
	{
	call getext(ffiles(1,k), ext)
	if (ffiles(1,k) != MINUS & ext(1) == LETF & ext(2) == EOS)
	    call genfil(ffiles(1,k), exto, arg)
	else
	    call scopy(ffiles(1,k), 1, arg, 1)
	call stcopy(arg, 1, ldargs, i)
	call chcopy(BLANK, ldargs, i)
	}
    ldargs(i-1) = EOS
    call impath(spath)
    if (loccom(ld, spath, suffix, arg) != BINARY)
	call error("Cannot locate ld image file.")
    if (verbos == YES)
	call remark(ldargs)
    if (spawn(arg, ldargs, descr, WAIT) == ERR)
	call remark('Error in linking process')
    }
 DRETURN
 end
#-h- fccmd            492  asc  14-may-81 07:33:26  [002,100]
##	fccmd -- handles switches in fc command line
 subroutine fccmd(arg)

 character arg(FILENAMESIZE)
 integer index

 include cfc

 call fold(arg)
 if (arg(1) == MINUS)
    if (arg(2) == LETP | arg(2) == LETL)
	call fstack(arg)
    else
	{
	if (index(arg, LETC) > 0)
	    load = NO
	if (index(arg, LETD) > 0)
	    debug = YES
	if (index(arg, LETO) > 0)
	    list = YES
	if (index(arg, LETV) > 0)
	    verbos = YES
	}
 else
    call badarg(arg)
 if (debug == YES)
    list = YES

 return
 end
#-h- fortrn           824  asc  29-apr-81 19:22:44  [002,100]
 integer function fortrn(source, object, list, verbos, debug)

 character source(ARB), object(ARB), list(ARB), arg(80), pid(PIDSIZE)
 integer spawn, i, verbos, debug

 ifelse(FORT_COMP,F4P,string srcsw "/notr/nock/co:19.",
string srcsw "/nosn/nova/nolo")

 i = 1
 call stcopy(COMP_NAME, 1, arg, i)
 call chcopy(BLANK, arg, i)
 call remove(object)		# delete most recent version of object file
 call stcopy(object, 1, arg, i)
 if (list(1) != EOS)
    {
    call chcopy(COMMA, arg, i)
    call remove(list)		# delete most recent version of list file
    call stcopy(list, 1, arg, i)
    call stcopy("/-sp", 1, arg, i)
    }
 call chcopy(EQUALS, arg, i)
 call stcopy(source, 1, arg, i)
 call scopy(srcsw, 1, arg, i)
 call fold(arg)
 if (verbos == YES)
    call remark(arg)
 fortrn = spawn("local", arg, pid, WAIT)

 return
 end
#-h- fstack           330  asc  29-apr-81 19:22:46  [002,100]
   ## fstack - generate stack of input files
 
   subroutine fstack (iarg)
 
   integer i
   character iarg(FILENAMESIZE)
 
   include flist
 
   if (flevel < FLMAX)
     {
     flevel = flevel + 1
     for (i=1; i<=FILENAMESIZE; i=i+1)
         ffiles(i,flevel) = iarg(i)
    call fold(ffiles(1, flevel))
     }
   return
   end
#-h- genfil           464  asc  29-apr-81 19:22:48  [002,100]
##	genfil -- generates file name with extension ext from in

 subroutine genfil(in, ext, out)

 integer i, j
 integer length
 character in(FILENAMESIZE), ext(EXTSIZE), out(FILENAMESIZE)

 string trmchr "/]"

 for (i=length(in); i > 0; i=i-1)
    if (index(trmchr, in(i)) > 0)
	break
 for (j=i+1; in(j) != EOS; j=j+1)
    if (in(j) == PERIOD)
	break
 for (i=1; i < j; i=i+1)
    out(i) = in(i)
 call chcopy(PERIOD, out, i)
 call scopy(ext, 1, out, i)

 return
 end
#-h- getext           466  asc  29-apr-81 19:22:50  [002,100]
 subroutine getext(file, ext)

 character file(FILENAMESIZE), ext(EXTSIZE)
 integer i, j
 integer length, index

 string trmchr "/]"

 for (i=length(file); i > 0; i=i-1)
    if (index(trmchr, file(i)) > 0)
	break
 for (j=i+1; file(j) != EOS; j=j+1)
    if (file(j) == PERIOD)
	{
	j = j + 1
	break
	}
 for (i=1; file(j) != EOS & file(j) != SEMICOL & file(j) != PERIOD; i=i+1)
    {
    ext(i) = file(j)
    j = j + 1
    }
 ext(i) = EOS
 call fold(ext)

 return
 end
#-h- fc.rof          1558  asc  14-may-81 07:33:46  [002,100]
.pl 60
.in 5
.rm 70
.he /FC/%/FC/
.fo //-#-/
.bp 1
NAME
.in +3

fc
- fortran compiler

.ti -3
SYNOPSIS

fc [-cdov] file ...

.ti -3
DESCRIPTION

fc 
is the fortran compiler callable from the software tools shell.  It accepts
the following types of arguments:

.in +3
.ti -3
1. Files whose names end in '.f' are assumed to be fortran source programs.   
They are compiled, and the object file is left on a file whose name is
that of the source with '.obj' substituted for '.f'.

.ti -3
2. Other arguments (except for the flags listed in 3 below) are assumed to
be either loader flags, or object files, typically created by an earlier
fc
run.  These programs, together with the results of any compilations, are
loaded (in the order given) to produce an executable program.

.ti -3
3. Four flags which affect the actions of the compiler are:

.in +3
.ti -3
-c
suppress the loading phase, as does any compilation error in any routine
.ti -3
-d do whatever is necessary to prepare the object files for the
system-specific debugger.  This flag is passed on to `ld' if the -c
switch is not specified.
.ti -3
-o
generates a fortran listing for 'file.f' on 'file.l'
.ti -3
-v
verbose option; prints name of file as it is compiled at the terminal
.in -3
.in -3

.ti -3
SEE ALSO

rc, the ratfor compiler, which provides a more pleasant programming dialect and
environment
.br
ld, the loader, for descriptions of loader flags and process naming conventions

.ti -3
AUTHOR

Joe Sventek wrote the interface of
fc
to the DEC Fortran 4+ compiler.

.ti -3
BUGS

none to date
