#-h- cmp.r           1608  asc  08-apr-81 09:41:25  [002,101]
#-h- main            1159  asc  08-apr-81 09:41:09  [002,101]
 ## cmp - compare two files for equality 
  
 DRIVER(cmp)
  
    character arg1(MAXLINE), arg2(MAXLINE) , stdin(2)
    character line1(MAXLINE), line2(MAXLINE) 
    integer equal, getarg, getlin, open 
    integer infil1, infil2, lineno, m1, m2 

   string usestr "usage:  cmp file1 [file2]."
  
    data stdin/MINUS, EOS/

    call query(usestr)
    if (getarg(1, arg1, MAXLINE) == EOF)
        call error(usestr)
    if (getarg(2, arg2, MAXLINE) == EOF)	# read STDIN if arg 2
	call scopy(stdin, 1, args, 1)
    infil1 = open(arg1, READ) 
    if (infil1 == ERR) 
       call cant(arg1) 
    if (equal(args, stdin) == YES)
	infil2 = STDIN
    else
	{
	infil2 = open(arg2, READ)
	if (infil2 == ERR)
	    call cant(arg2)
	}
    lineno = 0 
    repeat { 
       m1 = getlin(line1, infil1) 
       m2 = getlin(line2, infil2) 
       if (m1 == EOF | m2 == EOF) 
          break 
       lineno = lineno + 1 
       if (equal(line1, line2) == NO) 
          call difmsg(lineno, line1, line2) 
       } 
    if (m1 == EOF & m2 != EOF) 
       call remark('eof on file 1.') 
    else if (m2 == EOF & m1 != EOF) 
       call remark('eof on file 2.') 

  DRETURN
  end 
#-h- difmsg           325  asc  08-apr-81 09:41:10  [002,101]
 ## difmsg - print line number and differing lines of file1 and file2 
  
    subroutine difmsg(lineno, line1, line2) 
    character line1(MAXLINE), line2(MAXLINE) 
    integer lineno 
  
    call putdec(lineno, 5) 
    call putc(NEWLINE) 
    call putlin(line1, STDOUT) 
    call putlin(line2, STDOUT) 
    return 
    end 
#-h- cmp.rof         1070  asc  02-may-81 21:52:16  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'CMP'03/06/78'CMP 
.fo ''-#- 
.fi 
.in 7 
.ti -7 
NAME 
.br 
cmp - compare two files 
.sp 1 
.ti -7 
SYNOPSIS 
.br 
cmp file1 [file2] 
.sp 1 
.ti -7 
DESCRIPTION 
.br 
File1 is compared line-by-line with file2.
If file2 is not specified, standard input is used.
If any lines differ, cmp announces the line number and prints 
each file's offending line. 
.sp 1 
.ti -7 
FILES 
.br 
None
.sp 1 
.ti -7 
SEE ALSO 
.br 
comm
.br
The UNIX commands cmp, diff, and comm 
.sp 1 
.ti -7 
DIAGNOSTICS 
.br 
If the end of one file is reached before the end of the other, a 
message is printed. 
.sp 1 
.ti -7 
AUTHORS 
.br 
Acquired from "Software Tools" by Kernighan and Plauger, with 
minor modifications made by Debbie Scherrer. 
.sp 1 
.ti -7 
BUGS 
.br 
.sp 1
If either file is binary, spurious results 
should be expected. 
.sp 
Cmp cannot handle offset lines: line n of file1 
is simply compared to line n of file2. 
  
Trailing blanks are significant, which will cause some lines to 
appear similar to the user which are actually different. 
