#-h- ch.r            3181  asc  08-apr-81 08:50:59  [002,101]
#-h- defns            100  asc  08-apr-81 08:45:50  [002,101]
 ## symbol definitions for ch tool
  
 define(NEXPR,10)	# maximum no of expressions on command line
#-h- main            2518  asc  08-apr-81 08:45:51  [002,101]
 ## ch - change 'string1'  into  'string2' 
 DRIVER(ch)
    character lin(MAXLINE), new(MAXLINE), pat(MAXPAT,NEXPR)
    character arg(MAXARG), from(MAXPAT), to(MAXPAT)
    integer addset, amatch, getarg, getlin, getpat, getsub 
    integer i, junk, k, lastm, m , index
    integer except, andpat, narg, frarg, toarg, npat, itoc, status, gmatch

    string usestr "usage:  ch [-ax] [expression] ... from [to]."
  
 call query(usestr)
 except = NO
 andpat = NO
 narg = 0
 for (i=1; getarg(i, arg, MAXARG) != EOF; i=i+1)
    if (arg(1) == MINUS)
	{
	call scopy(arg, 1, lin, 1)
	call fold(lin)
	if (index(lin, LETA) > 0)
	    andpat = YES
	if (index(lin, LETX) > 0)
	    except = YES
	call delarg(i)
	i = i - 1
	}
    else
	narg = narg + 1
 if (narg == 0)
    call error(usestr)
 else if (narg == 1 | narg == 2)
    {
    frarg = 1
    toarg = 2
    npat = 1
    }
 else
    {
    toarg = narg
    frarg = narg - 1
    npat = narg - 2
    }
 if (npat > NEXPR)
    {
    call putlin("Maximum number of expressions permitted is ", ERROUT)
    i = itoc(NEXPR, arg, MAXARG)
    call error(arg)
    }
 junk = getarg(frarg, arg, MAXARG)
 if (getpat(arg, from) == ERR)
    call error("illegal fromexpr pattern.")
 if (getarg(toarg, arg, MAXARG) == EOF)
    arg(1) = EOS
 if (getsub(arg, to) == ERR)
    call error("illegal toexpr.")
 for (i=1; i <= npat; i=i+1)
    {
    junk = getarg(i, arg, MAXARG)
    if (getpat(arg, pat(1,i)) == ERR)
	{
	call putlin("illegal pattern: ", ERROUT)
	call error(arg)
	}
    }
 while (getlin(lin, STDIN) != EOF) 
    {
    status = gmatch(lin, pat, npat, andpat)
    if ((status == YES & except == NO) | (status == NO & except == YES))
	{
       k = 1 
       lastm = 0 
       for ( i =1; lin(i) != EOS; ) { 
          m = amatch(lin, i, from) 
          if (m > 0 & lastm != m) {   # replace matched text 
             call catsub(lin, i, m, to, new, k, MAXLINE) 
             lastm = m 
             } 
          if (m == 0 | m == i) {   # no match or null match 
             junk = addset(lin(i), new, k, MAXLINE) 
             i = i + 1 
             } 
          else            # skip matched text 
             i = m 
          } 
       if (addset(EOS, new, k, MAXLINE) == NO) { 
          k = MAXLINE 
          junk = addset(EOS, new, k, MAXLINE) 
          call remark('line truncated:.') 
          call putlin(new, ERROUT) 
          call putch(NEWLINE, ERROUT) 
          } 
       call putlin(new, STDOUT) 
       } 
    else
	call putlin(lin, STDOUT)
    }
  DRETURN 
    end 
#-h- gmatch           377  asc  08-apr-81 08:50:50  [002,101]
 integer function gmatch(lin, pat, elevel, andpat)

 integer elevel, andpat, match, i, status
 character lin(ARB), pat(MAXPAT, NEXPR)

 gmatch = andpat
 for (i=1; i <= elevel; i=i+1)
    {
    status = match(lin, pat(1,i))
    if (andpat == NO & status == YES)
	{
	gmatch = YES
	break
	}
    else if (andpat == YES & status == NO)
	{
	gmatch = NO
	break
	}
    }

 return
 end
#-h- ch.rof          4464  asc  02-may-81 21:50:42  [002,100]
.bp 
.pl 60 
.rm 70 
.in 0 
.he *CH*04/07/78*CH* 
.fo **-#-** 
.in 7 
.fi 
.ti -7 
NAME 
.br 
ch - make changes in text files 
.sp 1 
.ti -7 
SYNOPSIS 
.br 
ch [-ax] [expr ...] fromexpr [toexpr]
.sp 1 
.ti -7 
DESCRIPTION 
.br 
ch
copies each line of the standard input to the standard output, globally
substituting the text pattern "toexpr" for "fromexpr" on each line that
satisfies matching criteria defined by the leading expressions "expr" and
the switches. (A text pattern is a subset of a "regular expression"--see
the "ed" writeup for a complete description.)  Three possible courses of
action are taken depending upon the number of text patterns(n) found in
the command line:
.sp
.in +5
.ti -5
n=1  The text pattern is assumed to be "fromexpr" with a null "toexpr";
it is equivalent to the ed command
.ti +10
g/fromexpr/s///g
.ti -5
n=2  The first text pattern is "fromexpr", the second is "toexpr"; it
is equivalent to the ed command
.ti +10
g/fromexpr/s//toexpr/g
.ti -5
n>=3 The (n-1)th pattern is "fromexpr", the nth is "toexpr" and patterns
1...n-2 are used to determine the lines upon which to perform the
substitution.  The default is that any line which matches any one of
the n-2 leading expressions are eligible for substitution.  If the -a
flag is specified, only lines which match all n-2 leading expressions in
any order are eligible.  If the -x flag is specified, all lines which
don't satisfy the above criteria are eligible. (See the writeup on find
for more information.)  In particular, if n=3, 
.ti +10
ch expr from to
.br
is equivalent to the ed command
.ti +10
g/expr/s/from/to/g
.ti +10
ch -x expr from to
.br
is equivalent to the ed command
.ti +10
x/expr/s/from/to/g
.sp
.in -5
The substitution string "toexpr" may be a string of replacement
characters, null to effect a deletion, or it may include the special
"ditto" character "&" to put back the "fromexpr" string and thus
effect an insertion.
It may also contain the expressions `$1' ... `$9', which cause the
corresponding tagged pattern in the input to be inserted.
If a deletion is desired with the multiple
leading tag expressions, a "toexpr" of "" -i.e. quotes around an
empty string may be used.
  
A text pattern consists of the following elements: 
  
.nf 
c      literal character 
?      any character except newline 
%      beginning of line 
$      end of line (null string before newline) 
[...]  character class (any one of these characters) 
[!...] negated character class (all but these characters) 
{expr} tagged pattern (referenced by $1 ... $9)
*      closure (zero or more occurrences of previous pattern) 
+      anchored closure (one or more occurrences of previous pattern)
@c     escaped character (e.g., @%, @[, @*) 
  
.fi 
Any special meaning of characters in a text pattern is lost when 
escaped, inside [...], or for: 
  
.nf 
%         not at beginning 
$         not at end 
*         at beginning 
+         at beginning
  
.fi 
A character class consists of zero or more of the following 
elements, surrounded by [ and ]: 
  
.nf 
c         literal character 
a-b       range of characters (digits, lower or upper case) 
!         negated character class if at beginning 
@c        escaped character (@! @- @@ @]) 
  
.fi 
Special meaning of characters in a character class is lost when 
escaped or for 
  
.nf 
!         not at beginning 
-         at beginning or end 
  
.fi 
An escape sequence consists of the character @ followed by a single 
character: 
  
.nf 
@f        formfeed
@l        linefeed
@n        newline 
@r        return
@t        tab 
@OOO      the octal digit representation for an ASCII character
.ti +10
for example, @001 for the ASCII character SOH
@c        c (including @@) 
  
.fi 
For a complete description, see "Software Tools" pages 135-154. 
Care should be taken when using the characters % $ [ ] ! * + @ and 
any shell characters
in the text pattern. It is often necessary to enclose the 
entire substitution pattern in quotes. 
.sp 1 
.ti -7 
FILES 
.br 
None
.sp 1 
.ti -7 
SEE ALSO 
.br 
The UNIX tool GRES
.br
The tools find and ed
.sp 1 
.ti -7 
DIAGNOSTICS 
.br 
An error message is printed if the pattern given is illegal. 
.sp 1 
.ti -7 
AUTHORS 
.br 
'CH' was originally implemented on BKY by Debbie Scherrer from 
Kernighan and Plauger's "Software Tools".   Major modifications were
performed by Joe Sventek.
.sp 1 
.ti -7 
BUGS/DEFICIENCIES 
.br 
A minus sign(dash[-]) may not start an expression.
