#-h- args.r          2528  asc  29-apr-81 18:54:32  [002,100]
#-h- main            1848  asc  29-apr-81 18:52:08  [002,100]
 DRIVER(args)

 character name(FILENAMESIZE), arg(MAXLINE), args(ARGBUFSIZE),
	   image(FILENAMESIZE), pid(PIDSIZE)
 integer k, i, n, type, verbos, count
 integer getarg, getlin, length, loccom, spawn

 string sh "sh"
 string local "local"
 string usestr "usage:  args [-v] tool [arguments]."
 string fsuff BOTH_SUFFIX
 string isuff IMAGE_SUFFIX

 call query(usestr)
 verbos = NO
 for (i=1; getarg(i, arg, MAXLINE) != EOF; i=i+1)
    if (arg(1) != MINUS)
	break
    else if (arg(2) == LETV | arg(2) == BIGV)
	verbos = YES
    else
	call badarg(arg)
 if (getarg(i, name, FILENAMESIZE) == EOF)
    call error(usestr)
 k = 1
 count = 1
 for ( ; getarg(i, arg, MAXLINE) != EOF; i=i+1)
    {
    call packit(count, arg, args, k, ARGBUFSIZE)
    count = count + 1
    }
 for (n=getlin(arg, STDIN); n != EOF; n=getlin(arg, STDIN))
    if (n > 1)
	{
	arg(n) = EOS
	call packit(count, arg, args, k, ARGBUFSIZE)
	count = count + 1
	}
 args(k) = EOS				# terminate string
#
#	build search path
#	:~home:~usr:~bin
#
 call impath(arg)
#
#	now find the process and spawn it
#
 type = loccom(name, arg, fsuff, image)
 if (type == ERR)
    call scopy(local, 1, image, 1)
 else if (type == ASCII)
    {
    call strcpy(image, name)
    if (loccom(sh, arg, isuff, image) != BINARY)
	call error("Cannot locate shell image file.")
    else
	{
	i = 1
	call stcopy(sh, 1, arg, i)
	call chcopy(BLANK, arg, i)
	call stcopy(name, 1, arg, i)
	for (n=1; args(n) != EOS; n=n+1)
	    if (args(n) == BLANK | args(n) == TAB)
		break
	call scopy(args, n, arg, i)
	for (i=1; arg(i) != EOS; i=i+1)
	    if (i < ARGBUFSIZE)
		args(i) = arg(i)
	    else
		break
	args(i) = EOS
	}
    }
 if (verbos == YES)
    call remark(args)
 if (spawn(image, args, pid, WAIT) == ERR)
    {
    call remark(args)
    call remark("** Error spawning this command from args. **")
    }

 DRETURN
 end
#-h- packit           344  asc  29-apr-81 18:38:06  [002,100]
 subroutine packit(n, in, out, outptr, size)

 integer n, outptr, size, len
 integer length
 character in(ARB), out(ARB)

 if (n > 1)
    if (outptr < size)
	call chcopy(BLANK, out, outptr)
    else
	call sizerr(out, outptr)
 len = length(in)
 if (outptr+len >= size)
    call sizerr(out, outptr)
 call stcopy(in, 1, out, outptr)

 return
 end
#-h- sizerr           150  asc  29-apr-81 18:38:07  [002,100]
 subroutine sizerr(buf, n)

 integer n
 character buf(ARB)

 buf(n) = EOS
 call remark(buf)
 call error("** Command line too long. **")

 return
 end
#-h- args.rof        1676  asc  02-may-81 21:23:46  [002,100]
.in 5
.rm 75
.pl 60
.he 'ARGS'8/25/80'ARGS'
.fo //-#-/
.bp 1
NAME
.in +3

args - use standard input as arguments for command

.ti -3
SYNOPSIS

args [-v] tool [arguments]

.ti -3
DESCRIPTION

args reads the standard input file and concatenates the words found there
onto the arguments passed to args.  It then spawns the tool "tool" with
those arguments.  The first argument to args which does not start with a
"-" is taken to be the name of the tool to be invoked.  args uses the
same search path as the shell, and if "tool" is a script file, a copy
of the shell will be spawned reading that file for its commands.  The
optional -v argument causes args to display the final command line on
ERROUT before spawning the sub-process.

The most common use of args is as a form of argument explosion, as in the
following example:

.in +5
Suppose the user wishes to delete all files which have the string "tst"
somewhere in the filename.  This may be accomplished with the following
shell command line:
.sp
% ls tst | args rm -v
.sp
All of the files matching the pattern "tst" will be fed to args, which will
concatenate the names onto rm's command line.  rm will then be spawned, and
will print the name of each file as it is deleted.

.in -5
If the information found on standard input is so voluminous as to cause
the argument string to be too large, the command line is displayed on ERROUT
and the process is NOT spawned.  This prevents the user from being destroyed
by his/her indescretion.

.ti -3
FILES
.sp
none
.sp
.ti -3
SEE ALSO
.sp
sh - command line interpreter (for search path rules)
.sp
.ti -3
AUTHOR
.sp
args was written by Joe Sventek
.sp
.ti -3
BUGS/DEFICIENCIES
.sp
