;
; P M R G E N . C M D
;
; Command file to build Poor Mans Routing Task (PMR).
; PMR is compatible with the RSTS and VMS passthrough protocol.
;
	.ENABLE SUBSTITUTION
	.DISABLE LOWERCASE
	.SETS UIC <UIC>
	.ASKS IN Specify distribution device (DDNN:)
	.IF IN EQ "" .SETS IN "SY"
	.TEST IN
	.IFT <ALPHAN> .SETS IN "'IN':"
	.ASKS DEV Specify network task device (DDNN:)
	.IF DEV EQ "" .SETS DEV "SY"
	.TEST DEV
	.IFT <ALPHAN> .SETS DEV "'DEV':"
	.ASKN [1:377] GRP Specify Network group code
	.SETN BAS 0
	.SETN LEN 0
	.ASKS PAR What is the PMR partition name (Default=GEN)?
	.IF PAR EQ "" .SETS PAR "GEN"
	.ASK MPL Are you building PMR for RSX-11M-Plus
	.SETS SW ""
	.IFT MPL .SETS SW "/MU"
	.SETF FSL
	.SETF FRS
	.ASK FIL Do you want PMR to look up node names in LB:[1,2]MAILNODE.DAT
	.SETS PMRTRN ""
	.IFT FIL .SETS PMRTRN ":PMRTRN"
	.SETF LOG
	.ASK LOG Do you want PMR logging support
	.SETS PMRLOG ""
	.IFT LOG .SETS PMRLOG ":PMRLOG"
	.SETS PMRFSR ""
	.IFT FIL .OR .IFT LOG .SETS PMRFSR ":PMRFSR"
	.IFF FIL .IFF LOG .GOTO 10
	.IFT MPL .ASK FSL Does your system have an FCS supervisor mode library
	.IFF FSL .ASK FRS Does your system have an FCS resident library
	.SETS FCSRES ""
	.IFT FRS .ASKS FCSRES What is its name (D: FCSRES)
	.IFT FRS .IF FCSRES EQ "" .SETS FCSRES "FCSRES"
	.SETS LIB ""
	.IFT FSL .SETS LIB "SUPLIB=FCSFSL:SV"
	.IFT FRS .SETS LIB "LIBR='FCSRES':RO"
	SET /UIC=['GRP',24]
	.OPEN 'DEV'['GRP',24]PMRBLD.CMD
.ENABLE DATA
;
; Build Poor Man''s Routing task (PMR)
;
'DEV'['GRP',54]PMR'SW'='IN'[200,200]PMR/LB:PMR:PMRCON'PMRTRN''PMRLOG''PMRFSR'
/
TASK=PMR$$$
PRI=100
PAR='PAR':'BAS':'LEN'
UNITS=4
'LIB'
.DISABLE DATA
.IFT LOG .DATA UIC=[1,4]
.IFF FIL .DATA GBLDEF=PMRTRN:0
.IFF LOG .DATA GBLDEF=PMRLOG:0
.DATA //
	.CLOSE
	TKB @'DEV'['GRP',24]PMRBLD
	PIP 'DEV'['GRP',24]PMRBLD.CMD/PU
	PIP 'DEV'['GRP',54]PMR.TSK/PU
	SET /UIC='UIC'
;
; To use PMR, you must define the object type 123 on your system,
; for example:
;
;	>NCP SET OBJECT 123 NAME PMR$$$ COPIES 10
;
