#-h- tail.r          2025  asc  26-apr-81 20:37:19  [002,100]
#-h- defns            160  asc  26-apr-81 20:37:06  [002,100]
 #   include standard symbol definitions
 #        include ratdef
 
define(MAXBUF,3000)     # line buffer size
define(DEFAULT,23)      # default if no argument
#-h- main             975  asc  26-apr-81 20:37:08  [002,100]
# tail - print tail portion of a file
 DRIVER(tail)
   character arg(MAXLINE)
   integer n, i, fd
   integer ctoi, getarg, open

   call query("usage:  tail [-n] [file] ...")
   n = DEFAULT
   fd = ERR
   for (i=1; getarg(i, arg, MAXLINE) != EOF; i=i+1)
        {
        if (arg(1) == MINUS & arg(2) != EOS)
                {
                j = 2
                n = ctoi(arg, j)
                if (n <= 0)
                        call error ("invalid size.")
                }
        else if (arg(1) == MINUS & arg(2) == EOS)
                {
                fd = STDIN
                call ptail (n, fd)
                }
        else
                {
                fd = open(arg, READ)
                if (fd == ERR)
                        call cant(arg)
                call ptail (n, fd)
                call close(fd)
                }
        }
 
   if (fd == ERR)               #no files specified, read STDIN
        call ptail (n, STDIN)
   DRETURN
   end
#-h- ptail            704  asc  26-apr-81 20:37:09  [002,100]
 ## ptail - print last 'n' lines of file 'fd'
 subroutine ptail (nlins, fd)
 integer n, fd, nlins
 character buf(MAXBUF)
 character getch
 integer head, tail, i
 
   head = 1
   tail = 1
   n = nlins
   while (getch(buf(tail), fd) ^= EOF) {
      tail = mod(tail, MAXBUF) + 1
      if (tail == head)
         head = mod(head, MAXBUF) + 1
      }
   for (i = tail; i ^= head; ) {
      i = i - 1
      if (i == 0)
         i = MAXBUF
      if (buf(i) == NEWLINE) {
         n = n - 1
         if (n < 0) {
            i = mod(i, MAXBUF) + 1
            break
            }
         }
      }
   for (head = i; head ^= tail; head = mod(head, MAXBUF) + 1)
      call putch(buf(head), STDOUT)
 
 return
 end
#-h- tail.rof         812  asc  11-may-81 12:13:21  [002,100]
.pl 60
.bp 1
.in 0
.he 'TAIL (1)'8/26/79'TAIL (1)'
.sp 2
.in +3
.fi
.ti -3
NAME
.br
tail - print last lines of a file
.nf
.sp
.ti -3
SYNOPSIS
.br
tail [-n] [file] ...
.fi
.sp
.ti -3
DESCRIPTION
.br
Tail
prints the last "n" lines of the indicated file.
If 'n' is omitted, the last 23 lines are printed.
 
If "file" is omitted or is "-", tail reads the standard input.
.sp
.ti -3
SEE ALSO
.br
split
.sp
.ti -3
AUTHORS
.br
David Hanson and friends (U. of Arizona)
.sp
.ti -3
BUGS/DEFICIENCIES
.br
An internal buffer of MAXBUF characters is kept.
If the value of "n" would require buffering more characters than
the buffer can hold,
tail
prints the last MAXBUF characters of the file.
In this case, the first line of output may not be an entire line.
MAXBUF is a definition in the source code which may be adjusted.
