#-h- cspell           483  asc  15-may-81 18:40:51  [002,100]
 common / cspell / nlines, dunit, freep, freec, strptr(MAX_DIR_ENTRIES),
		   linptr(MAX_DIR_ENTRIES), charay(MAX_CHARS)

 integer nlines		# number of entries read from index
 integer dunit		# rat4 unit for dictionary file
 integer freep		# next free loc in strptr
 integer freec		# next free loc in charay
 integer strptr		# index into charay for the key for the n'th entry
 linepointer linptr	# values to load into seek to locate record
 character charay	# key strings stored here
#-h- spell.r         6156  asc  15-may-81 18:40:54  [002,100]
#-h- defns             55  asc  26-apr-81 20:58:44  [002,100]
 define(MAX_DIR_ENTRIES,1800)
 define(MAX_CHARS,18000)
#-h- main             553  asc  26-apr-81 20:58:45  [002,100]
 DRIVER(spell)

 integer i, status, unit
 integer getarg, equal, open
 character file(FILENAMESIZE)

 string minust "-"

 call query("usage:  spell [-ddictname] [file] ...")
 call lodidx
 i = 1
 repeat
    {
    status = getarg(i, file, FILENAMESIZE)
    if (status == EOF)
	if (i > 1)
	    break
	else
	    unit = STDIN
    else if (equal(file, minust) == YES)
	unit = STDIN
    else
	{
	unit = open(file, READ)
	if (unit == ERR)
	    call cant(file)
	}
    call dospel(unit)
    if (unit != STDIN)
	call close(unit)
    i = i + 1
    }

 DRETURN
 end
#-h- alphan           149  asc  26-apr-81 20:58:47  [002,100]
 integer function alphan(c)

 character c, t
 character type

 t = type(c)
 if (t == LETTER | t == DIGIT)
    return(YES)
 else
    return(NO)

 end
#-h- binsrc           510  asc  26-apr-81 20:58:48  [002,100]
 integer function binsrc(word)

 character word(ARB)
 integer first, last, i, m, c
 integer strcmp

 include cspell

 m = strptr(nlines)
 if (strcmp(word, charay(m)) > 0)
    return(nlines)
 m = strptr(1)
 if (strcmp(word, charay(m)) < 0)
    return(1)
 first = 1
 last = nlines
 while ((last - first) > 1)
    {
    i = (first + last) / 2
    m = strptr(i)
    c = strcmp(word, charay(m))
    if (c == 1)
	first = i
    else if (c == 0)
	{
	last = i
	first = i
	}
    else
	last = i
    }
 return(first)
 end
#-h- dospel           711  asc  26-apr-81 20:58:49  [002,100]
 subroutine dospel(unit)

 integer i, m, n, iferr, j, start, unit
 integer getlin, findwd, gtword
 character buf(MAXLINE), word(MAXLINE), errbuf(MAXLINE)

 include cspell

 for (n=getlin(buf,unit); n != EOF; n=getlin(buf,unit))
    {
    call putlin(buf, STDOUT)
    for (j=1; buf(j) != EOS; j=j+1)
	if (buf(j) == TAB)
	    errbuf(j) = TAB
	else if (buf(j) == NEWLINE)
	    errbuf(j) = NEWLINE
	else
	    errbuf(j) = BLANK
	errbuf(j) = EOS
    i = 1
    iferr = NO
    while (gtword(buf, i, word, start) > 0)
	{
	call fold(word)
	if (findwd(word) == NO)
	    {
	    iferr = YES
	    for (j=start; j < i; j=j+1)
		errbuf(j) = STAR
	    }
	}
    if (iferr == YES)
	call putlin(errbuf, STDOUT)
    }

 return
 end
#-h- findwd           670  asc  26-apr-81 20:58:50  [002,100]
 integer function findwd(word)

 character word(ARB)
 integer i, junk, n
 integer getlin, binsrc, strcmp, equal, wdlook, okword
 character buf(MAXLINE)

 include cspell

 if (okword(word) == YES)	# group of known correct words
    return(YES)
 if (wdlook(word) == YES)	# seen this mis-spelled word before
    return(NO)
 i = binsrc(word)
 call seek(linptr(i), dunit)
 for (n=getlin(buf,dunit); n != EOF; n=getlin(buf,dunit))
    {
    buf(n) = EOS
    if (strcmp(word, buf) <= 0)
	break
    }
 if (n == EOF)
    buf(1) = EOS
 if (equal(word, buf) == NO)
    {
    call wdstal(word)			# install mis-spelled word
    findwd = NO
    }
 else
    findwd = YES

 return
 end
#-h- gtroot           380  asc  26-apr-81 20:58:52  [002,100]
subroutine gtroot(root)

character root(FILENAMESIZE)
integer i, found
integer getarg

string dict "dict"

found = NO
for (i=1; getarg(i, root, FILENAMESIZE) != EOF; i=i+1)
  if (root(1) == MINUS & (root(2) == LETD | root(2) == BIGD))
    {
    call scopy(root, 3, root, 1)
    call delarg(i)
    found = YES
    break
    }
if (found == NO)
  call strcpy(dict, root)

return
end
#-h- gtword           345  asc  26-apr-81 20:58:53  [002,100]
 integer function gtword(buf, i, word, start)

 integer i, start, j
 character buf(ARB), word(ARB)
 integer alphan, length

 while (alphan(buf(i)) == NO)
    if (buf(i) == EOS)
	break
    else
	i = i + 1
 start = i
 for (j=1; alphan(buf(i)) == YES; j=j+1)
    {
    word(j) = buf(i)
    i = i + 1
    }
 word(j) = EOS
 return(length(word))
 end
#-h- lodidx          1123  asc  15-may-81 18:37:30  [002,100]
# load dictionary index file
 subroutine lodidx

 character file(FILENAMESIZE), buf(MAXLINE), root(FILENAMESIZE),
	   spath(arith(3,*,FILENAMESIZE))
 integer int, n, m, i, junk
 integer open, getlin, matchc, loccom

 include cspell

 string suffix "dx"
 string srcsuf NO_SUFFIX

 call gtroot(root)		# get file root
 call concat(root, suffix, buf)
 call impath(spath)		# fetch standard search path
 if (loccom(buf, spath, srcsuf, file) != ASCII)
    call cant(buf)
 int = open(file, READ)
 if (int != ERR)
    {
    m = 1
    for (n=1; getlin(buf, int) != EOF; n=n+1)
	{
	i = 1
	while (buf(i) != BLANK)
	    i = i + 1
	junk = m + i
	if (n > MAX_DIR_ENTRIES | junk > MAX_CHARS)
	    call error("Dictionary index too large for internal storage!")
	strptr(n) = m
	buf(i) = EOS
	i = i + 1
	call stcopy(buf, 1, charay, m)
	m = m + 1
	call ctoptr(buf, i, linptr(n))
	}
    nlines = n - 1
    freep = n
    freec = m
    call close(int)
    }
 else
    call cant(file)
 i = matchc(file, suffix)	# find suffix in file spec
 file(i) = EOS			# lop it off
 dunit = open(file, READ)
 if (dunit == ERR)
    call cant(file)

 return
 end
#-h- okword           277  asc  26-apr-81 20:58:56  [002,100]
 integer function okword(word)

 character word(ARB)
 integer type, equal

 string a "a"
 string i "i"

 okword = NO
 if (type(word(1)) == DIGIT)
    okword = YES
 else if (equal(word, a) == YES)
    okword = YES
 else if (equal(word, i) == YES)
    okword = YES

 return
 end
#-h- wdlook           235  asc  26-apr-81 20:58:58  [002,100]
 integer function wdlook(word)

 character word(ARB)
 integer i, j
 integer equal

 include cspell

 for (i=nlines+1; i < freep; i=i+1)
    {
    j = strptr(i)
    if (equal(word, charay(j)) == YES)
	return(YES)
    }
 return(NO)
 end
#-h- wdstal           404  asc  26-apr-81 20:58:59  [002,100]
 subroutine wdstal(word)

 character word(ARB)
 integer i
 integer length

 include cspell

 if (freep <= MAX_DIR_ENTRIES)
    {
    i = freec + length(word)
    if (i <= MAX_CHARS)			# word will fit
	{
	strptr(freep) = freec		# fill in pointer
	freep = freep + 1		# bump pointer
	call stcopy(word, 1, charay, freec)	# copy word, bumping freec
	freec = freec + 1		# point past EOS
	}
    }

 return
 end
#-h- spell.rof       1169  asc  15-may-81 18:40:59  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'SPELL'1/11/79'SPELL'
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
spell - find spelling errors
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
spell [-ddictname] [file] ...
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
Spell
copies the named files (or standard input if none are specified) to
standard output while looking up each word in a dictionary.  If any
spelling errors are found in a particular line, an additional line
will be printed immediately following the line with asterisks (*)
beneath the offending words.

If the -d switch is used, `spell' will use the files `dictname' and
`dictname'dx for the dictionary and index.
.sp 1
.in 
FILES 
.br 
.in 7 
dict - a dictionary file
.br
dictdx - the index generated by isam for the dictionary
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
isam - generate an index for pseudo-indexed-sequential access
.br
ospell - the script pipeline suggested in K&P for spelling errors
.sp 1 
.in 
DIAGNOSTICS
.br 
.in 7 
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
.sp 1 
Joe Sventek
.sp 1 
.in 
BUGS 
.br 
.in 7 
This is a skeleton spelling error detector.  It is expected that various
modifications to flesh it out will be performed for local use.
