#-h- crar             623  asc  28-apr-81 13:14:16  [002,100]
common / crar / arcint, nmods, fstat(MAX_FILES), filptr(MAX_FILES),
		size(2, MAX_FILES), siz(2), lptr(MAX_FILES),
		fname(MAX_FILE_SPACE), file(FILENAMESIZE),
		buf(MAXLINE)

filedes arcint		# ratfor unit for archive
integer nmods		# number of modules in archive
integer fstat		# if module has been processed previously; init = NO
integer size		# double integer size of module
integer siz		# scratch double integer array
linepointer lptr	# linepointers for start of each module in archive
character fname		# array holding module names
character file		# scratch file name array
character buf		# scratch buffer for getlin's
#-h- rar.r           4082  asc  28-apr-81 13:14:20  [002,100]
#-h- defns            100  asc  28-apr-81 10:15:22  [002,100]
define(MAX_FILES,200)
define(MAX_FILE_SPACE,arith(MAX_FILES,*,15))
define(arskip,arcopy($1,ERR,$2))
#-h- main             921  asc  28-apr-81 13:10:40  [002,100]
DRIVER(rar)

character aname(FILENAMESIZE), rbuf(MAXLINE)
integer verbos, n, i, compl
integer getarg, open, getlin, index

include crar

string usestr "usage:  rar [-cv] archive."

call query(usestr)
aname(1) = EOS
verbos = NO
compl = YES
for (i=1; getarg(i, rbuf, FILENAMESIZE) != EOF; i=i+1)
  if (rbuf(1) == MINUS)
    {
    call fold(rbuf)
    if (index(rbuf, LETV) > 0)
      verbos = YES
    if (index(rbuf, LETC) > 0)
      compl = NO
    }
  else
    call strcpy(rbuf, aname)
if (aname(1) == EOS)
  call error(usestr)
arcint = open(aname, READ)
if (int == ERR)
  call cant(aname)
call rainit
for (n=getlin(rbuf, STDIN); n != EOF; n=getlin(rbuf, STDIN))
  {
  rbuf(n) = EOS
  call fold(rbuf)
  call putmod(rbuf, verbos)
  }
if (compl == YES)
  for (n=1; n <= nmods; n=n+1)
    if (fstat(n) == NO)
      {
      i = filptr(n)
      call scopy(fname, i, rbuf, 1)
      call putmod(rbuf, verbos)
      }

DRETURN
end
#-h- arcopy           383  asc  28-apr-81 10:15:24  [002,100]
subroutine arcopy(fdi, fdo, size)

filedes fdi, fdo
integer size(2), hi, lo
character c
character getch

hi = size(1)
lo = size(2)
if (lo == 0 & hi > 0)
  {
  lo = 10000
  hi = hi - 1
  }
while (lo > 0)
  {
  if (getch(c, fdi) == EOF)
    break
  if (fdo != ERR)
    call putch(c, fdo)
  lo = lo - 1
  if (lo == 0 & hi > 0)
    {
    lo = 10000
    hi = hi - 1
    }
  }

return
end
#-h- gethdr           738  asc  28-apr-81 10:15:25  [002,100]
## GetHdr - Get header info from archive member `fd'.

integer function gethdr(fd, buf, name, size, type)

character buf(MAXLINE), c, name(FILENAMESIZE), temp(FILENAMESIZE)
integer   ctoi, equal, getlin, getwrd, ishdr # function(s)
integer   fd, i, len, size(2), type, j
 
string asc "asc"
string local "local"
string bin "bin"

if( getlin(buf, fd) == EOF )
{
  gethdr = EOF
  return
}

call fold(buf)
if (ishdr(buf, i) == NO)
  call error("? Archive not in proper format.")

gethdr = YES
len = getwrd(buf, i, name)
call ctodi(buf, i, size)
len = getwrd (buf, i, temp)
if( len <= 0 | equal(temp,asc) )
  type = ASCII
else if( equal(temp, local) )
  type = LOCAL
else if( equal(temp, bin) )
  type = BINARY
else
  type = ASCII

return
end
#-h- ishdr            254  asc  28-apr-81 10:15:26  [002,100]
integer function ishdr(buf, i)

character buf(ARB)
integer i

string hdr "#-h-"

ishdr = YES
for (i=1; hdr(i) != EOS; i=i+1)
  if (buf(i) != hdr(i))
    {
    ishdr = NO
    break
    }
if (ishdr == YES)
  if (buf(i) != BLANK)
    ishdr = NO

return
end
#-h- putmod           631  asc  28-apr-81 10:15:27  [002,100]
subroutine putmod(name, verbos)

character name(FILENAMESIZE)
integer verbos, i, j, junk
integer equal, getlin

include crar

for (i=1; i <= nmods; i=i+1)
  {
  j = filptr(i)
  call scopy(fname, j, file, 1)
  if (equal(file, name) == YES)
    {
    if (fstat(i) == YES)
      {
      call putlin(name, ERROUT)
      call error(" - already output.")
      }
    call seek(lptr(i), arcint)
    junk = getlin(buf, arcint)
    call putlin(buf, STDOUT)
    siz(1) = size(1, i)
    siz(2) = size(2, i)
    call arcopy(arcint, STDOUT, siz)
    fstat(i) = YES
    if (verbos == YES)
      call remark(name)
    break
    }
  }

return
end
#-h- rainit           621  asc  28-apr-81 10:15:29  [002,100]
subroutine rainit

integer i, type
integer gethdr, length

include crar

i = 1
for (nmods = 1; nmods <= MAX_FILES; nmods = nmods + 1)
  {
  call markl(arcint, lptr(nmods))
  if (gethdr(arcint, buf, file, siz, type) == EOF)
    break
  fstat(nmods) = NO
  size(1, nmods) = siz(1)
  size(2, nmods) = siz(2)
  filptr(nmods) = i
  if ((i + length(file) + 1) > MAX_FILE_SPACE)
    call error("Out of space for module names.")
  call stcopy(file, 1, fname, i)
  i = i + 1				# skip over EOS
  call arskip(arcint, siz)
  }
if (nmods > MAX_FILES)
  call error("Too many modules in archive.")
else
  nmods = nmods - 1

return
end
#-h- rar.rof         1338  asc  12-may-81 09:58:15  [002,100]
.bp 
.pl 60
.rm 70 
.in 0 
.he 'RAR'5/2/81'RAR'
.fo ''-#-' 
.fi 
.in +7
.ti -7
NAME 
.br
rar - rearrange archive
.sp 1 
.ti -7
SYNOPSIS 
.br
rar [-cv] archname
.sp 1 
.ti -7
DESCRIPTION 
.br
`rar' permits the rearrangement of the modules of an
archive, `archname'.  `rar' opens `archname' and notes the names
and starting address of each module.  It then reads the names of
modules from standard input and outputs each module so indicated
to standard output.  Upon detecting an EOF on standard input,
any modules not yet output are written out in the order found in the
original archive.
.sp 1
Switches:
.sp 1
.in +5
.ti -3
-c Suppresses the output of modules not specified on the standard input.
This permits the selection of only a subset of the original archive's
modules.

.ti -3
-v Print the name of each module on error output after it has been
successfully output to the standard output.
.sp 1
.ti -5
Example of use:
.sp 1
Suppose that you wish to create a new version (newarch) of an archive
(oldarch) with all of the modules sorted by name.  The following shell
command will suffice:

ar t oldarch | sort | rar -v oldarch >newarch

.in -5
.sp 1
.ti -7
FILES 
.br
None
.sp 1 
.ti -7
SEE ALSO 
.br
.nf
ar - archive file maintainer
.fi
.sp 1 
.ti -7
DIAGNOSTICS 
.br

.sp 1 
.ti -7
AUTHORS 
.br
Joe Sventek
.sp 1 
.ti -7
BUGS 
.br

