#-h- pl.r            5024  asc  27-apr-81 13:01:42  [002,100]
#-h- defns            118  asc  27-apr-81 12:58:22  [002,100]
 # include ratdef
 define(MAXBUF,3000)
 define(MAXLINES,200)
 define(EOL,-1)
 define(PAGESIZE,23)	# default page size
#-h- main            1079  asc  27-apr-81 12:58:23  [002,100]
# pl - print specified lines or pages of given files
 DRIVER(pl)

   character arg(MAXLINE)
   integer getarg, open, ctoi, addset
   integer fd, i, j, l, u, lp, list(MAXLINES), pagsiz, pflag, junk

   string usestr "usage:  pl [-p<n>] numbers [file] ..."

   call query(usestr)
   pflag = NO
   i = 1
   pagsiz = 1
   list(1) = EOL
 for (i=1; getarg(i, arg, MAXLINE) != EOF; i=i+1)
   {
   if (arg(1) == MINUS & arg(2) != EOS)        # pick up flags
	{
	call doflag(arg, pflag, pagsiz)
	next
	}
    if (list(1) == EOL)	      # need some numbers
    	lp = gnum (arg, list)     # break out numbers
     else
	{
      if (arg(1) == MINUS & arg(2) == EOS)
         fd = STDIN
      else
         fd = open(arg, READ)
      if (fd == ERR)
         call cant(arg)
      if (list(1) == EOL)     # need some numbers
		call error (usestr)
      call plines(fd, list, pagsiz)
      if (fd ^= STDIN)
         call close(fd)
      }
    }
 
   if (list(1) == EOL)
	call error (usestr)
   if (fd == ERR) 
           # no files specified
      call plines(STDIN, list, pagsiz)
 DRETURN
   end
#-h- doflag           463  asc  27-apr-81 12:58:24  [002,100]
 ## doflag - process flags for pl tool
 subroutine doflag (arg, pflag, pagsiz)
 character arg(ARB)
 integer pflag, pagsiz
 integer ctoi
 
 if (arg(2) == LETP | arg(2) == BIGP)	  # print pages
      {
      pflag = YES
      j = 3
      pagsiz = ctoi(arg, j)
      if (pagsiz < 0 | arg(j) ^= EOS)
         call error("bad page size.")
      if (pagsiz == 0)
         pagsiz = PAGESIZE	#default
      }
else
	call remark ("ignoring invalid argument.")
 return
 end
#-h- get              492  asc  27-apr-81 12:58:25  [002,100]
# get - get next n lines from fd into buf
   integer function get(n, buf, fd)
   integer n, fd
   character buf(MAXBUF)
   integer i
   character getch, c

   i = 1
   for (m = n; m > 0; m = m - 1) {
      while (getch(c, fd) ^= EOF) {
         if (i < MAXBUF) {
            buf(i) = c
            i = i + 1
            }
         if (c == NEWLINE)
            break
         }
      if (c == EOF)
         break
      }
   buf(i) = EOS
   if (c == EOF)
      return(EOF)
   return(n)
   end
#-h- gnum             884  asc  27-apr-81 12:58:26  [002,100]
 ## gnum - get numbers for pl tool
 integer function gnum (arg, list)
 integer list(ARB), lp, j
 character arg(ARB)
 integer ctoi
 
 lp = 0
 for (j=1; arg(j) ^= EOS;  )
	{
	lp = lp + 1
        if (lp > MAXLINES)
		call error ("too many numbers.")
	list(lp) = ctoi(arg, j)
	if (list(lp) <= 0)
		call error ("bad number.")
      if (arg(j) == MINUS) {	# have l-u specification
         j = j + 1
         u = ctoi(arg, j)
         l = list(lp)
         if ( u < l)
            call error("bad range.")
         for (l = l + 1; l <= u; l = l + 1)
	    {
            lp = lp + 1
	    if (lp > MAXLINES)
		call error ("too many numbers.")
	    list(lp) = l
	    }
         }
      while (arg(j) == COMMA | arg(j) == BLANK | arg(j) == TAB)
         j = j + 1
      }
 if (lp+1 > MAXLINES)
	call error ("too many numbers.")
 list(lp+1) = EOL
   call shell (list, lp)
 gnum = lp
 return
 end
#-h- plines           590  asc  27-apr-81 12:58:28  [002,100]
# plines - print pages from fd as specified in sorted list.
   subroutine plines(fd, list, pagsiz)
   integer fd, list(MAXLINES), pagsiz
   integer i, j, n, get, skip, len, junk
   character buf(MAXBUF)

   n = 0
   for (i = 1; list(i) ^= EOL; ) {
      if (skip(pagsiz*(list(i) - n - 1), fd) == EOF)
         return
      len = get(pagsiz, buf, fd)
      for (j = i; list(j) == list(i); i = i + 1)
         call putlin(buf, STDOUT)
      if (len == EOF)
         return
      n = list(j)
      }
   if (fd == STDIN)	# must flush standard input
      junk = skip(HUGE, fd)
   return
   end
#-h- shell            577  asc  27-apr-81 12:58:29  [002,100]
 ## shell - Shell sort v(1)...v(n) increasing
 subroutine shell (v, n)
 integer gap, i, j, jg, k, n, v(ARB)
 
 for (gap=n/2; gap>0; gap=gap/2)
        for (i=gap+1; i<=n; i=i+1)
                for (j=i-gap; j>0; j=j-gap)
                        {
                        jg = j + gap
                        if (v(j) <= v(jg))      #compare
                                break
                        k = v(j)                #exchange
                        v(j) = v(jg)            #
                        v(jg) = k               #
                        }
 return
 end
#-h- skip             325  asc  27-apr-81 12:58:30  [002,100]
# skip - skip n lines on fd
   integer function skip(n, fd)
   integer n, fd
   integer m
   character getch, c

   for (m = n; m > 0; m = m - 1) {
      while (getch(c, fd) ^= EOF)
         if (c == NEWLINE)
            break
      if (c == EOF)
         break
      }
   if (c == EOF)
      return(EOF)
   return(n)
   end
#-h- pl.rof          1761  asc  08-may-81 17:00:08  [002,100]
.pl 60
.bp 1
.in 0
.he 'PL (1)'9/18/79'PL (1)
.sp 2
.in +3
.fi
.ti -3
NAME
.br
pl - print specified lines/pages in a file
.nf
.sp
.ti -3
SYNOPSIS
.br
pl [-pn] numbers [file] ...
.fi
.sp
.ti -3
DESCRIPTION
.br
Pl
prints the specified lines from each of the named files
on the standard output.  If no files are given, or if
the name "-" is specified, pl reads the standard input.
.sp
The "numbers" argument is a list of line numbers
separated by commas, e.g.
.sp
.in +3
.nf
pl 4,5,26,55 foo bazrat
.in -3
.sp
.fi
prints lines 4, 5, 26, and 55 in file "foo" and
"bazrat".  The line
numbers may be given in any order.
Repeated numbers cause the specified lines to be
printed once for each occurrence of the line number.
Line number ranges can also be given, e.g. 4-15.
.sp
The "-p" option causes pl to print pages instead of lines,
and the numbers refer to page numbers.  If an integer follows
the "-p", it is taken as the page size; the default is 23.
Repeated numbers cause the specified pages to be printed
once for each occurrence of the page number.
.fi
.sp
.ne 2
.ti -3
DIAGNOSTICS
.br
bad page size
.in +5
Invalid page size specified after '-p' flag
.in -5
bad number
.in +5
Invalid number given as argument
.in -5
bad range
.in +5
Invalid range given as argument
.in -5
too many numbers
.in +5
Number of lines/pages specified overflowed the buffer.  
Maximum number of lines is determined by the MAXLINES definition
in the source code.
.in -5
ignoring invalid argument
.in +5
An invalid flag was specified.   Processing continues.
.in -5
.fi
.sp
.ti -3
AUTHORS
.br
David Hanson and friends (U. of Arizona)
.sp
.ti -3
BUGS/DEFICIENCIES
.br
There is a limit to the size of pages which can be buffered.
This is set by the MAXBUF definition in the source code.
