#-h- mubld.r         6386  asc  29-may-81 12:37:42  [002,100]
#-h- defns            879  asc  08-may-81 15:53:39  [002,100]
# definitions necessary for mubld - task to build multi-user tasks
#
# necessary label block offsets (TKB manual, page B-5)
define(L_BLIB,8%40)	# start of resident library label
define(L_BBLK,8%360)	# number of blocks in label
define(L_BROB,8%364)	# relative block of R-O image
define(L_BROL,8%366)	# R-O load size (64-byte blocks)
define(R_LSA,8%4)	# library starting address in library request
define(RO_ST_ADDR,arith(L_BLIB,+,R_LSA))	# label offset to R-O st addr
#
# integer array indices after reading label block from image
#
define(ADDR_IND,arith(arith(RO_ST_ADDR,/,2),+,1))	# starting virt addr
define(BLIB_IND,arith(arith(L_BLIB,/,2),+,1))		# start of RO request
define(SIZE_IND,arith(arith(L_BROL,/,2),+,1))		# size of RO image
define(BLCK_IND,arith(arith(L_BROB,/,2),+,1))		# st block of RO image
define(LABL_IND,arith(arith(L_BBLK,/,2),+,1))		# no of blocks in label
#-h- main             586  asc  08-may-81 15:53:40  [002,100]
DRIVER(mubld)

character arg(FILENAMESIZE), name(FILENAMESIZE)

integer verbos, debug, i
integer getarg, index, length

string usestr "usage:  mubld [-dv] task"

call query(usestr)
debug = NO
verbos = NO
name(1) = EOS
for (i=1; getarg(i, arg, FILENAMESIZE) != EOF; i=i+1)
  {
  call fold(arg)
  if (arg(1) == MINUS)
    {
    if (index(arg, LETD) > 0)
      debug = YES
    if (index(arg, LETV) > 0)
      verbos = YES
    }
  else
    call strcpy(arg, name)
  }
if (name(1) == EOS)
  call error(usestr)
if (length(name) > 4)
  name(5) = EOS
call domu(name, debug, verbos)

DRETURN
end
#-h- domu            4735  asc  29-may-81 08:10:02  [002,100]
subroutine domu(name, debug, verbos)

integer debug, verbos, b1(256), b2(256), junk, intm, mint, intr, rint,
	stvadr, stblck, rosize, int, nlbl, n
integer spawn, open, readf, writef, create, remove, getlin
character name(5), mutask(FILENAMESIZE), taskmu(FILENAMESIZE),
	  rotask(FILENAMESIZE), taskro(FILENAMESIZE), file(FILENAMESIZE),
	  spwbuf(80), buf(MAXLINE), pid(PIDSIZE)

string local "local"
string pipcmd "pip dummy.tsk;*/de/nm,dummy.obj;*,dummy.mac;*,dummy.tkb;*"
string pipfmt "pip %sro.tsk;*/de/nm,%sro.obj;*,%sro.mac;*,%sro.tkb;*"
string romac "@t.psect@tro%s@n@t.blkb@t%o@n@t.end@n"
string rotkb "%sro/mm/-hd/-pr,,ro%s=%sro@n/@nstack=0@npar=ro%s:%o:%o@n//@n"
string dmmac "@t.end@n"
string dmtkb "dummy=dummy@n/@nrescom=ro%s/ro@n//@n"
string mucmd "mac %sro=%sro@ntkb @@@@%sro.tkb@npip %s=%s@n_
mac dummy=dummy@ntkb @@@@dummy.tkb@n"

call sprint(mutask, "mu%s.tsk", name)
call sprint(taskmu, "%smu.tsk", name)
call sprint(rotask, "ro%s.tsk", name)
call sprint(taskro, "%sro.tsk", name)
junk = remove(mutask)
junk = remove(rotask)
junk = spawn(local, pipcmd, pid, WAIT)
call sprint(spwbuf, pipfmt, name, name, name, name)
junk = spawn(local, spwbuf, pid, WAIT)
call sprint(spwbuf, "pip %s=%s", mutask, taskmu)
if (verbos == YES)
  call remark(spwbuf)
junk = spawn(local, spwbuf, pid, WAIT)
intm = open(taskmu, READ)
if (intm == ERR)
  call cant(taskmu)
if (readf(b1, 512, intm) != 512)
  call error("Error reading label block 0")
call close(intm)
stvadr = b1(ADDR_IND)	# starting virtual address of R-O image
stblck = b1(BLCK_IND)	# starting block # of R-O image
rosize = 64 * b1(SIZE_IND)	# size of R-O image in bytes
call sprint(file, "%sro.mac", name)
int = create(file, WRITE)
if (int == ERR)
  call cant(file)
call sprint(buf, romac, name, rosize)
call putlin(buf, int)
call close(int)
if (verbos == YES)
  {
  call remark(file)
  call putlin(buf, ERROUT)
  }
call sprint(file, "%sro.tkb", name)
int = create(file, WRITE)
if (int == ERR)
  call cant(file)
call sprint(buf, rotkb, name, name, name, name, stvadr, rosize)
call putlin(buf, int)
call close(int)
if (verbos == YES)
  {
  call remark(file)
  call putlin(buf, ERROUT)
  }
call strcpy("dummy.mac", file)
int = create(file, WRITE)
if (int == ERR)
  call cant(file)
call putlin(dmmac, int)
call close(int)
if (verbos == YES)
  {
  call remark(file)
  call putlin(dmmac, ERROUT)
  }
call strcpy("dummy.tkb", file)
int = create(file, WRITE)
if (int == ERR)
  call cant(file)
call sprint(buf, dmtkb, name)
call putlin(buf, int)
call close(int)
if (verbos == YES)
  {
  call remark(file)
  call putlin(buf, ERROUT)
  }
call strcpy("mubld.cmd", file)
int = create(file, WRITE)
if (int == ERR)
  call cant(file)
call sprint(buf, mucmd, name, name, name, rotask, taskro)
call putlin(buf, int)
call close(int)
if (verbos == YES)
  call remark(file)
int = open(file, READ)
for (n=getlin(buf, int); n != EOF; n=getlin(buf, int))
  {
  buf(n) = EOS
  if (verbos == YES)
    call remark(buf)
  junk = spawn(local, buf, pid, WAIT)
  }
call close(int)
call close(STDIN)
call close(STDOUT)
intm = open(taskmu, READ)
if (intm == ERR)
  call cant(taskmu)
mint = create(mutask, READWRITE)
if (mint == ERR)
  call cant(mutask)
int = open("dummy.tsk", READ)
if (int == ERR)
  call cant("dummy.tsk")
if (readf(b1, 512, intm) != 512)
  call error("Error reading label block for taskmu")
if (readf(b2, 512, int) != 512)
  call error("Error reading label block for dummy.tsk")
for (i=BLIB_IND; i <= arith(BLIB_IND,+,13); i=i+1)
  b1(i) = b2(i)
call close(int)
if (debug == NO)
  junk = spawn(local, pipcmd, pid, WAIT)
intr = open(taskro, READ)
if (intr == ERR)
  call cant(taskro)
rint = create(rotask, READWRITE)
if (rint == ERR)
  call cant(rotask)
junk = writef(b1, 512, mint)	# write revised label block
for (i=2; i < stblck; i=i+1)	# write read-write image
  {
  junk = readf(b1, 512, intm)
  junk = writef(b1, 512, mint)
  }
if (readf(b1, 512, intr) != 512)
  call error("Error reading label block for taskro.tsk")
nlbl = b1(LABL_IND)		# number of label blocks
junk = writef(b1, 512, rint)	# write label blocks to rotask
for (i=2; i <= nlbl; i=i+1)
  {
  junk = readf(b1, 512, intr)
  junk = writef(b1, 512, rint)
  }
nlbl = (rosize - 1) / 512 + 1	# number of blocks in read-only image
for (i=1; i <= nlbl; i=i+1)
  {
  junk = readf(b1, 512, intm)
  junk = writef(b1, 512, mint)
  junk = writef(b1, 512, rint)
  junk = readf(b2, 512, intr)
  }
while (readf(b1, 512, intm) == 512)
  junk = writef(b1, 512, mint)
call close(intm)
call close(mint)
while (readf(b1, 512, intr) == 512)
  junk = writef(b1, 512, rint)
call close(intr)
call close(rint)
if (debug == NO)
  {
  call sprint(spwbuf, pipfmt, name, name, name, name)
  junk = spawn(local, spwbuf, pid, WAIT)
  }

return
end
#-h- mubld.rof       1884  asc  08-may-81 16:25:21  [002,100]
.bp 
.pl 60
.rm 70 
.in 0 
.he 'MUBLD'5/2/81'MUBLD'
.fo ''-#-' 
.fi 
.in +7
.ti -7
NAME 
.br
mubld - build a multi-user task for RSX-11M
.sp 1 
.ti -7
SYNOPSIS 
.br
mubld [-dv] tool
.sp 1 
.ti -7
DESCRIPTION 
.br
`mubld' builds a multi-user task for RSX-11M.
It does so by manipulating the task image label blocks as discussed
by Eric Levy of JPL in the April 1981 issue of the Multi-tasker.
`mubld' requires one input file (`tool'mu.tsk) and generates three
output files (mu`tool'.tsk, ro`tool'.tsk and ro`tool'.stb).
ro`tool'.tsk is a resident common containing all of the read-only code
and data of `tool', with ro`tool'.stb being its symbol table file.
mu`tool'.tsk is a task image which contains the impure data of `tool'
and is mapped over ro`tool'.tsk as a resident common for its code.
To use mu`tool', one must VMR a partition for ro`tool' with the name
ro`tool' into your system image and install ro`tool'.tsk into it.
Then one may use mu`tool' at will.  A file `mushbld.cmd' is provided
in [307,31] for building a multi-user version of the shell.

Switches:
.in +5
.ti -3
-v Causes verbose mutterings at the user's terminal while `mubld'
is working.  It is suggested that one use this switch, since one of the
gems of wisdom appearing on your terminal is the size of the common
partition needed for ro`tool'.

.ti -3
-d Debug option: causes all files created during the run to be kept
around on the current UIC.
.in -5
.sp 1
.ti -7
FILES 
.br
`tool'mu.tsk,mu`tool'.tsk,ro`tool'.tsk,ro`tool'.stb
.sp 1 
.ti -7
SEE ALSO 
.br
.nf
objfix - Fortran object module fixer
.fi
.sp 1 
.ti -7
DIAGNOSTICS 
.br

.sp 1 
.ti -7
AUTHORS 
.br
Joe Sventek
.sp 1 
.ti -7
BUGS 
.br
Once I get a chance to experiment with the LDLIB package from
the Fall '80 DECUS SIG tape, `mubld' will be enhanced to generage
images which can participate in the dynamic loading of the shared
common regions.
