#-h- msplit.r        1701  asc  27-apr-81 12:49:54  [002,100]
#-h- defns             68  asc  27-apr-81 12:49:19  [002,100]
define(MAXHEADERS,50)	# this value must jive with msg.w/msg.r/defns
#-h- main             816  asc  27-apr-81 12:49:20  [002,100]
 DRIVER(msplit)

 character ch, cl, root(FILENAMESIZE), file(FILENAMESIZE)
 integer i, verbos, status
 integer getarg, equal, cpymsg

 string dfroot "tmsg"
 string minusv "-v"

 data ch/LETA/
 data cl/LETA/

 call query("usage:  msplit <file [-v] [root].")
 verbos = NO
 call scopy(dfroot, 1, root, 1)
 for (i=1; getarg(i, file, FILENAMESIZE) != EOF; i=i+1)
    {
    call fold(file)
    if (equal(file, minusv) == YES)
	verbos = YES
    else
	call scopy(file, 1, root, 1)
    }
 repeat
    {
    i = 1
    call stcopy(root, 1, file, i)
    call chcopy(ch, file, i)
    call chcopy(cl, file, i)
    file(i) = EOS
    i = MAXHEADERS - 1
    status = cpymsg(i, file)
    if (verbos == YES)
	call remark(file)
    cl = cl + 1
    if (cl > LETZ)
	{
	cl = LETA
	ch = ch + 1
	}
    }
 until (status == EOF)

 DRETURN
 end
#-h- cpymsg           631  asc  27-apr-81 12:49:21  [002,100]
 integer function cpymsg(n, file)

 integer n, out, i, status
 integer create, getlin, equal
 linepointer temp
 character file(FILENAMESIZE), hdrpat(4), buf(MAXLINE)

 data hdrpat/1, 1, NEWLINE, EOS/

 out = create(file, WRITE)
 if (out == ERR)
    call cant(file)
 i = 0
 repeat
    {
    call markl(STDIN, temp)
    status = getlin(buf, STDIN)
    if (status == EOF)
	break
    if (equal(buf, hdrpat) == YES)
	{
	i = i + 1
	if (i > n)
	    {
	    call seek(temp, STDIN)		# backup one line
	    status = n				# n messages copied
	    break
	    }
	}
    call putlin(buf, out)
    }
 call close(out)
 cpymsg = status

 return
 end
#-h- msplit.rof       974  asc  08-may-81 16:53:10  [002,100]
.in 5
.rm 75
.pl 60
.he 'MSPLIT'1/11/79'MSPLIT'
.fo //-#-/
.bp 1
NAME
.in +3

msplit
- utility for salvaging message files

.ti -3
SYNOPSIS

msplit <file [-v] [root]

.ti -3
DESCRIPTION

msplit
reads the standard input file, which presumably has more messages on
it than msg can handle, and splits it up into files which contain a
fixed number of messages.  The files created are named rootaa, rootab, ...,
where root defaults to "tmsg" if none is specified on the command line.  If
the -v (verbose) option is selected, then the name of each file is displayed
on ERROUT as it is created.  The user should immediately use msg on these
temporaries to place the messages in appropriate files.  In particular, the
input file to msplit should be overwritten, since it is too large already.

.ti -3
FILES
.sp
none
.sp
.ti -3
SEE ALSO
.sp
msg - the utility for reading and sorting one's mail
.sp
.ti -3
AUTHOR
.sp
msplit was written by Joe Sventek
.sp
.ti -3
BUGS/DEFICIENCIES
.br
