#-h- lam.r           2384  asc  27-apr-81 14:32:32  [002,100]
#-h- defns            166  asc  27-apr-81 14:32:23  [002,100]
 # include ratdef
define(MAXARGS,12)      # max nbr args (files and strings) allowed
define(MAXBUF,200)	# buffer to hold strings
define(MAXOBUF,500)	# output buffer

#-h- main            2094  asc  27-apr-81 14:32:24  [002,100]
# lam - laminate named files
 DRIVER(lam)
   character lin(MAXLINE), buf(MAXBUF), obuf(MAXOBUF)
   integer bp, obp, i, j, junk, nfiles, len, fd(MAXARGS)
   integer open, getarg, getlin, esc, addset

   call query("usage:  lam [-sstring | file] ...")
   bp = 1
   nfiles = 0
   for (i = 1; getarg(i, lin, MAXLINE) ^= EOF; i = i + 1) {
      if (i > MAXARGS)
         call error("too many arguments.")
      if (lin(1) == MINUS & lin(2) ^= EOS) {	# -string
         fd(i) = -bp
         for (j = 2; lin(j) ^= EOS; j = j + 1)
            junk = addset(esc(lin, j), buf, bp, MAXBUF)
         if (addset(EOS, buf, bp, MAXBUF) == NO)
            call error("too many strings.")
         }
      else {
         nfiles = nfiles + 1
         if (lin(1) == MINUS)
            fd(i) = STDIN
         else
            fd(i) = open(lin, READ)
         if (fd(i) == ERR)
            call cant(lin)
         }
      }
 
   if (nfiles == 0) {
      nfiles = 1
      fd(i) = STDIN
      }
   else
      i = i - 1
   n = i
 for (obp = 1; nfiles > 0; obp = 1) 
   {
   for (i = 1; i <= n; i = i + 1)
      {
      if (fd(i) < 0 )           # do string
         {
         for (j = -fd(i); buf(j) ^= EOS; j = j + 1)
            {
            if ( addset(buf(j), obuf, obp, MAXOBUF) == NO)
                  call error ('output buffer exceeded.')
            }
         }
      else if (fd(i) ^= EOF) 
         {
         len = getlin(lin, fd(i))
         if (len == EOF) 
            {
            nfiles = nfiles - 1
            if (fd(i) ^= STDIN)
               call close(fd(i))
            fd(i) = EOF
            }
         else
            {
            for (j = 1; j < len; j = j + 1)
               {
               if ( addset(lin(j), obuf, obp, MAXOBUF) == NO)
                    call error ('output buffer exceeded.')
               }
            }
         }
      }       # end of second 'for' loop
   if (nfiles > 0) 
      {
      for (j = 1; j < obp; j = j + 1)
         call putch(obuf(j), STDOUT)
      call putch(NEWLINE, STDOUT)
      }
   }           # end of main 'for' loop.
 DRETURN
end
#-h- lam.rof         1864  asc  06-may-81 08:11:38  [002,100]
.pl 60
.bp 1
.in 0
.he 'LAM (1)'7/30/79'LAM (1)'
.sp 2
.in +3
.fi
.ti -3
NAME
.br
lam - laminate files
.nf
.sp
.ti -3
SYNOPSIS
.br
lam { -string | file } ...
.fi
.sp
.ti -3
DESCRIPTION
.br
Lam laminates the named files to the standard output.
That is, the first output line is the result of concatenating
the first lines of each file, and so on.
If the files are different lengths, null lines are used for the missing
lines in the shorter files.
.sp
The "-string" arguments are used to place strings in each output
line.  Each "string" is placed in the output lines at the point
it appears in the argument list.  For example,
.sp
.in +3
.nf
lam -file1: foo1 "-, file2:" foo2
.in -3
.sp
.fi
results in output lines that look like
.sp
.in +3
.nf
file1: a line from foo1, file2: a line from foo2
.in -3
.sp
.fi
The escape sequences described in find (and change)
are valid in "string"
arguments.  Thus
.sp
.in +3
.nf
lam foo1 -@n foo2
.in -3
.sp
.fi
results in the lines from foo1 and foo2 being interleaved.
.sp
Files and string specifications may appear in any order in the
argument list.
.sp
If no file arguments are given,
or if the file "-" is specified,
lam reads the standard input.
.fi
.sp
.ti -3
FILES
.br
None
.sp
.ne 2
.ti -3
SEE ALSO
.br
comm, tail
.fi
.sp
.ne 2
.ti -3
DIAGNOSTICS
.br
too many arguments
.br
.in +3
The maximum number of command line arguments allowed has been exceeded.
It is set by the MAXARGS definition in the source code.
.in -3
.sp
too many strings
.br
.in +3
The max number of characters in a string has been exceeded.
It is set by the MAXBUF definition in the source code.
.in -3
.sp
output buffer exceeded
.in +3
The size of the output line buffer has been exceeded. 
It is set by the MAXOBUF definition in the source code.
.in -3
.sp
.ne 2
.ti -3
AUTHORS
.br
David Hanson and friends (U. of Arizona)
.sp
.ti -3
BUGS/DEFICIENCES
