#-h- field.r         4708  asc  27-apr-81 16:11:16  [002,100]
#-h- defns             89  asc  27-apr-81 16:09:14  [002,100]
 # include ratdef
define(MAXFIELDS,10)
define(ARGFLAG,-1)       # or define(ARGFLAG,255)
#-h- main            2090  asc  27-apr-81 16:09:15  [002,100]
# field - rearrange fields in a file
 DRIVER(field)
   character buf(MAXLINE), tabc
   integer from(MAXFIELDS), to(MAXFIELDS)
   character ofmt(MAXLINE)
   integer i, j, k, n, nflds, len, fd, tflag, files
   integer getarg, getlin, open, doflds, getfmt

   string usestr "usage:  field [-t[c] | fieldlist] outputformat [file] ..."

   data tabc /TAB/, tflag /YES/, nflds /MAXFIELDS/

   call query(usestr)
   i = 1        # assume no field specification is given
   if (getarg(1, buf, MAXLINE) == EOF)
      call error(usestr)
   if (buf(1) == MINUS & buf(2) == LETT) {  # tab fields are specified
      if (buf(3) ^= EOS)
         tabc = buf(3)
      i = 2
      }
   else if (buf(1) >= DIG0 & buf(1) <= DIG9) {  # fields are specified
      nflds = doflds(buf, from, to, MAXFIELDS)
      if (nflds == ERR)
                call error ("illegal field specification.")
      tflag = NO
      i = 2
      }
   if (getarg(i, buf, MAXLINE) == EOF)
      call error(usestr)                #error, no output format specified
   junk = getfmt(buf, ofmt)
   files = NO
   for (i=i+1; ; i=i+1)
      {
      if (getarg(i, buf, MAXLINE) == EOF)     #done?
          {
          if (files == YES)             #yes, done
               break
          fd = STDIN              #not done, read from STDIN
          }
      else if (buf(1) == MINUS & buf(2) == EOS)
         fd = STDIN
      else
         fd = open(buf, READ)
      files = YES
      if (fd == ERR)
         call cant(buf)
      len = getlin(buf, fd)
      while (len ^= EOF) {
         if (tflag == YES)
            call dotabs(buf, tabc, from, to, nflds)
         for (j = 1; ofmt(j) ^= EOS; j = j + 1)
            if (ofmt(j) == ARGFLAG) {
               n = ofmt(j+1)
               for (k = from(n); k <= to(n) & k < len; k = k + 1)
                   call putch(buf(k), STDOUT)
               j = j + 1
               }
            else
               call putch(ofmt(j), STDOUT)
         call putch(NEWLINE, STDOUT)
         len = getlin(buf, fd)
         }
      if (fd ^= STDIN)
         call close(fd)
      }
   DRETURN
   end
#-h- doflds          1025  asc  27-apr-81 16:09:17  [002,100]
# doflds - get field specifications from buf into from and to
   integer function doflds(buf, from, to, maxsiz)
   character buf(ARB)
   integer from(ARB), to(ARB), maxsiz
   integer i, n
   integer ctoi

   n = 1
   from(1) = 1
   to(1) = HUGE
   for (i = 1; buf(i) ^= EOS; ) {
      n = n + 1
      if (n > maxsiz)
         return(ERR)
      from(n) = ctoi(buf, i)
      to(n) = from(n)
      call skipbl(buf, i)
      if (buf(i) == MINUS) {            # form is n-m
         i = i + 1
         to(n) = ctoi(buf, i)
         call skipbl(buf, i)
         }
      else if (buf(i) == PLUS) {        # form is n+m
         i = i + 1
         to(n) = from(n) + ctoi(buf, i) - 1
         call skipbl(buf, i)
         }
      if (from(n) < 1 |
          from(n) > to(n) |
         (buf(i) ^= COMMA & buf(i) ^= EOS))
           return(ERR)
      if (buf(i) == COMMA)
         i = i + 1
      }
   for (i = n + 1; i <= maxsiz; i = i + 1) {    # clear other fields
      from(i) = HUGE
      to(i) = HUGE
      }
   return(n)
   end
#-h- dotabs           642  asc  27-apr-81 16:09:18  [002,100]
# dotabs - break buf into fields defined by tab character c
   subroutine dotabs(buf, c, from, to, maxsiz)
   character buf(ARB), c
   integer from(ARB), to(ARB), maxsiz
   integer i, j, n

   n = 1
   from(n) = 1
   to(n) = HUGE
   j = 1
   for (i = 1; buf(i) ^= EOS & n < maxsiz; i = i + 1)
      if (buf(i) == c) {
         n = n + 1
         from(n) = j
         to(n) = i - 1
         j = i + 1
         }
      if (n < maxsiz)
        {
        n = n + 1
        from(n) = j
        to(n) = HUGE
        }
   for ( ; n < maxsiz; n = n + 1) {     # clear other fields
      from(n+1) = HUGE
      to(n+1) = HUGE
      }
   return
   end
#-h- getfmt           552  asc  27-apr-81 16:09:19  [002,100]
# getfmt - convert output format in buf to internal form in fmt
   subroutine getfmt(buf, fmt)
   character buf(ARB)
   character fmt(ARB)
   integer i, j
   character esc
   integer addset

   j = 1
   for (i = 1; buf(i) ^= EOS; i = i + 1)
      {
      if (buf(i) == DOLLAR & buf(i+1) >= DIG0 & buf(i+1) <= DIG9) {
        junk = addset(ARGFLAG, fmt, j, MAXLINE)
        junk = addset(buf(i+1) - DIG0 + 1, fmt, j, MAXLINE)
         i = i + 1
         }
      else
        junk = addset(esc(buf,i), fmt, j, MAXLINE)
      }
 fmt(j) = EOS
 return
 end
#-h- field.rof       2223  asc  06-may-81 07:56:16  [002,100]
.pl 60
.bp 1
.in 0
.he 'FIELD (1)'7/10/80'FIELD (1)'
.sp 2
.in +3
.fi
.ti -3
NAME
.br
field - manipulate fields of data
.nf
.sp
.ti -3
SYNOPSIS
.br
field [-t[c] | fieldlist] outputformat [file ...]
.fi
.sp
.ti -3
DESCRIPTION
.br
.fi
Feild
is used to manipulate data kept in formatted fields.
It selects data from certain fields of the input files 
and copies it to certain places in the standard output.
 
The 'fieldlist' parameter is used to describe the interesting
columns on the input file.
Fields are specified by naming the columns in which they
occur (e.g. 5-10) or the columns in which they start and
an indication of their length (e.g. 3+2, meaning a field
which starts in column 3 and spans 2 columns).
When specifying more than one field, separate the specs
with commas (e.g. 5-10,16,72+8)
Fields may overlap, and need not be in ascending numerical order
(e.g. 1-25,10,3 is OK).
 
If input fields do not fall in certain columns, but rather are
separated by some character (such as a blank or a comma), 
describe the fields by using the '-tc' flag, replacing 'c'
with the appropriate
separator (a tab character is the default).
 
Once fields have been described with either the '-tc' flag
or a fieldlist, they can be arranged on output by
the 'outputformat' argument.
This argument is actually a picture of what the output line
should look like.
Fields from input are referred to as $1, $2, $3, etc., referring
to the first, second, third, etc. fields that were specified.
(Up to 9 fields are allowed, plus the argument $0 which
refers to the whole line.)
These $n symbols are placed in the output format wherever 
that field should appear, surrounded by whatever characters
desired.
For example, an outputformat of:
.ce
           "$2 somewords $1"
would produce an output line such as:
.ce
            field2 somewords field1
 
If no input files are specified, or if the filename '-' is
found, field will read from the standard input.
.sp
.ti -3
DIAGNOSTICS
.br
illegal field specification
.in +5
The fieldlist specification was in error, probably because
it contained letters or some other
illegal characters
.in -5
.sp
.ti -3
SEE ALSO
.br
sedit
.sp
.ti -3
AUTHORS
.br
David Hanson and friends (U. of Arizona)
