#-h- rm.r            1050  asc  27-apr-81 17:51:02  [002,100]
#-h- main             696  asc  27-apr-81 17:49:19  [002,100]
 ##	subroutine rm -- removes files
  
 DRIVER(rm)
  
 	integer i, getarg, verbos, isatty, getlin, narg
 	character buf(MAXLINE), clower
  
	call query("usage:  rm [-v] [file] ...")
	verbos = NO
 	for (i=1; getarg(i,buf,FILENAMESIZE) != EOF; i=i+1)
	    if (buf(1) == MINUS & clower(buf(2)) == LETV)
		verbos = YES
	if (verbos == YES)
	    narg = i - 2
	else
	    narg = i - 1
	if (narg > 0)
	    for (i=1; getarg(i, buf, FILENAMESIZE) != EOF; i=i+1)
		{
		if (buf(1) != MINUS)
		    call rmfile(buf, verbos)
		}
	else if (isatty(STDIN) == NO)
	    for (i=getlin(buf, STDIN); i != EOF; i=getlin(buf, STDIN))
		{
		buf(i) = EOS		# overwrite NEWLINE
		call rmfile(buf, verbos)
		}
  
	DRETURN
 	end
#-h- rmfile           230  asc  27-apr-81 17:49:20  [002,100]
## subroutine to remove files, and optionally to list file name on ERROUT
 subroutine rmfile(file, verbos)

 character file(FILENAMESIZE)
 integer verbos

 if (verbos == YES)
    call remark(file)
 call remove(file)

 return
 end
#-h- rm.rof           760  asc  12-may-81 10:00:29  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'RM'1/11/79'RM'
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
rm - remove files
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
rm
[-v] [name] ...
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
Rm
removes the files specified.
If none are specified and standard input is not a terminal, `rm' reads
the names of the files to delete from the standard input.  If the -v
switch is specified, `rm' displays the name of each file on error output
as it is deleted.
.sp 1
.in 
FILES 
.br 
.in 7 
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
The Unix command 'rm'
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
A message is printed if the file could not be removed.
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
.sp 1 
Joe Sventek (DEC machines); Debbie Scherrer (CDC machines)
.sp 1 
.in 
BUGS 
.br 
.in 7 
