#-h- crc              523  asc  29-apr-81 19:31:42  [002,100]
 #---------------------------------------------------------------
 ## crc common block for 'rc' tool
 #  put on a file named 'crc'
 
 common / crc / load, savef, ratonl, verbos, list, debug

 integer load		# YES/NO for link after compilation
 integer savef		# YES/NO for saving intermediate .f files
 integer ratonl		# YES/NO for rat4 only => savef == YES
 integer verbos		# YES/NO for verbose mutterings
 integer list		# YES/NO for fortran listings during compilation
 integer debug		# YES/NO for debugging aid; init = NO
#-h- flist            277  asc  29-apr-81 19:31:44  [002,100]
  #------------------------------------------------------
  # flist - common block
  # should be put on a file named 'flist'
 
  common /flist/  flevel, ffiles(FILENAMESIZE, FLMAX)
    
    integer flevel	#pointer to current file
    character ffiles	#list of files to process
#-h- rc.r            4477  asc  29-apr-81 19:31:46  [002,100]
#-h- defns             37  asc  23-apr-81 14:31:21  [002,102]
	define(FLMAX,25)
	define(EXTSIZE,4)
#-h- main            2278  asc  29-apr-81 19:29:44  [002,100]
 DRIVER(rc)

 character arg(FILENAMESIZE), ext(EXTSIZE), args(ARGBUFSIZE),
	   rat4(FILENAMESIZE),
	   descr(PIDSIZE), spath(arith(FILENAMESIZE,*,3))
 integer errcnt, i, k, status, spawn, getarg, loccom

 include flist
 include crc

 string suffix IMAGE_SUFFIX
 string minusd "-d "
 string rat4s "ratfor"
 string fc "fc"
 string extf(EXTSIZE) "f"
 string minusc "-c "
 string minusv "-v "
 string minuso "-o "

 call query("usage:  rc [-cdforv] [-l[libr]] [-pproc] file ...")
 load = YES
 savef = NO
 ratonl = NO
 verbos = NO
 list = NO
 debug = NO
 errcnt = 0

 for (i=1; getarg(i, arg, FILENAMESIZE) != EOF; i=i+1)
    {
    if (arg(1) == MINUS | arg(1) == PLUS)
	call rccmd(arg)
    else
	call fstack(arg)
    }
 call impath(spath)
 if (loccom(rat4s, spath, suffix, rat4) != BINARY)
    call error("Cannot locate ratfor image file.")
 for (i=1; i <= flevel; i=i+1)
    {
    call getext(ffiles(1,i), ext)
    if (ffiles(1,i) != MINUS & ext(1) == LETR & ext(2) == EOS)
	{
	call genfil(ffiles(1,i), extf, arg)
	k = 1
	call stcopy(rat4s, 1, args, k)
	call chcopy(BLANK, args, k)
	call stcopy(ffiles(1,i), 1, args, k)
	call chcopy(BLANK, args, k)
	call chcopy(GREATER, args, k)
	call scopy(arg, 1, args, k)
	if (verbos == YES)
	    call remark(args)
	if (spawn(rat4, args, descr, WAIT) == ERR)
	    errcnt = errcnt + 1
	k = 1
	if (savef == NO)
	    {
	    ffiles(1,i) = GREATER
	    k = 2
	    }
	call scopy(arg, 1, ffiles(1,i), k)
	}
    }

 if (ratonl == NO & errcnt == 0)
    {
    k = 1
    call stcopy(fc, 1, args, k)
    call chcopy(BLANK, args, k)
    if (load == NO)
	call stcopy(minusc, 1, args, k)
    if (verbos == YES)
	call stcopy(minusv, 1, args, k)
    if (list == YES)
	call stcopy(minuso, 1, args, k)
    if (debug == YES)
	call stcopy(minusd, 1, args, k)
    for (i=1; i <= flevel; i=i+1)
	{
	if (ffiles(1,i) == GREATER)
	    call stcopy(ffiles(1,i), 2, args, k)
	else
	    call stcopy(ffiles(1,i), 1, args, k)
	call chcopy(BLANK, args, k)
	}
    args(k-1) = EOS
    if (verbos == YES)
	call remark(args)
    if (loccom(fc, spath, suffix, arg) != BINARY)
	call error("Cannot locate fc image file.")
    status = spawn(arg, args, descr, WAIT)
    for (i=1; i <= flevel; i=i+1)
	{
	if (ffiles(1,i) == GREATER)
	    call remove(ffiles(2,i))
	}
    }
 DRETURN
 end
#-h- fstack           330  asc  23-apr-81 14:31:25  [002,102]
   ## fstack - generate stack of input files
 
   subroutine fstack (iarg)
 
   integer i
   character iarg(FILENAMESIZE)
 
   include flist
 
   if (flevel < FLMAX)
     {
     flevel = flevel + 1
     for (i=1; i<=FILENAMESIZE; i=i+1)
         ffiles(i,flevel) = iarg(i)
    call fold(ffiles(1, flevel))
     }
   return
   end
#-h- genfil           464  asc  29-apr-81 19:27:02  [002,100]
##	genfil -- generates file name with extension ext from in

 subroutine genfil(in, ext, out)

 integer i, j
 integer length
 character in(FILENAMESIZE), ext(EXTSIZE), out(FILENAMESIZE)

 string trmchr "/]"

 for (i=length(in); i > 0; i=i-1)
    if (index(trmchr, in(i)) > 0)
	break
 for (j=i+1; in(j) != EOS; j=j+1)
    if (in(j) == PERIOD)
	break
 for (i=1; i < j; i=i+1)
    out(i) = in(i)
 call chcopy(PERIOD, out, i)
 call scopy(ext, 1, out, i)

 return
 end
#-h- getext           466  asc  29-apr-81 19:27:04  [002,100]
 subroutine getext(file, ext)

 character file(FILENAMESIZE), ext(EXTSIZE)
 integer i, j
 integer length, index

 string trmchr "/]"

 for (i=length(file); i > 0; i=i-1)
    if (index(trmchr, file(i)) > 0)
	break
 for (j=i+1; file(j) != EOS; j=j+1)
    if (file(j) == PERIOD)
	{
	j = j + 1
	break
	}
 for (i=1; file(j) != EOS & file(j) != SEMICOL & file(j) != PERIOD; i=i+1)
    {
    ext(i) = file(j)
    j = j + 1
    }
 ext(i) = EOS
 call fold(ext)

 return
 end
#-h- rccmd            530  asc  23-apr-81 14:31:29  [002,102]
 subroutine rccmd(arg)

 character arg(FILENAMESIZE)
 integer index

 include crc

 call fold(arg)
 if (arg(1) == MINUS)
    if (arg(2) == LETL | arg(2) == LETP)
	call fstack(arg)
    else
	{
	if (index(arg, LETC) > 0)
	    load = NO
	if (index(arg, LETD) > 0)
	    debug = YES
	if (index(arg, LETF) > 0)
	    savef = YES
	if (index(arg, LETO) > 0)
	    list = YES
	if (index(arg, LETR) > 0)
	    {
	    ratonl = YES
	    savef = YES
	    }
	if (index(arg, LETV) > 0)
	    verbos = YES
	}
 else
    call badarg(arg)

 return
 end
#-h- rc.rof          1817  asc  08-may-81 17:08:45  [002,100]
.pl 60
.in 5
.rm 70
.he /RC/%/RC/
.fo //-#-/
.bp 1
.in +3
.ti -3
NAME

rc
- ratfor compiler

.ti -3
SYNOPSIS

rc [-cdforv] file ...

.ti -3
DESCRIPTION

rc
is the ratfor compiler.  It accepts the following types of arguments:

.in +3
.ti -3
1. Files whose names end in '.r' are assumed to be ratfor source programs;
they are preprocessed into fortran and compiled.  The preprocessed file
for name.r is placed on name.f and the compiled object code appears on
name.obj.  The name.f file is removed unless -f is specified (see below).

.ti -3
2. Six flags which affect the actions of the compiler are:

.in +3
.ti -3
-c
suppress the loading phase, as does any preprocessing or compilation error
.ti -3
-d do whatever is necessary to prepare the fortran files for the system
debugger.  In addition, pass the -d on to fc.
.ti -3
-r
ratfor only; don't compile fortran; implies -f and -c
.ti -3
-f
save fortran intermediate files; usually for debugging purposes
.ti -3
-v
verbose option; prints name of each file as it is preprocessed and
prints name of each '.f' file as it is compiled
.ti -3
-o
generates fortran listing for name.f on name.l

.in -3
.ti -3
3. Files whose names end in '.f' are assumed to be fortran source programs,
and are compiled.  Other arguments are assumed to be loader flags, or
object files, typically created by an earlier
rc
or
fc
run.  These files, together with the results of any compilations, are loaded
to produce an executable process.

.in -3
.ti -3
SEE ALSO

ratfor, the ratfor preprocessor, for descriptions of the language and for a more
general way of performing the preprocessing.
.br
fc, the fortran compiler
.br
ld, the loader, for loader flags and process naming conventions

.ti -3
AUTHOR

Joe Sventek wrote the interface of
rc
to ratfor, fc, and ld.

.ti -3
BUGS

none to date
