#-h- find.r          2115  asc  27-apr-81 08:37:59  [002,100]
#-h- defns            163  asc  27-apr-81 08:36:09  [002,100]
 ## definitions for the FIND tool
 # put on a file named 'defns'
 # Used by the find tool
 
  define(NEXPR,10)	# maximum number of expressions allowed on cmd line
#-h- main            1389  asc  27-apr-81 08:36:10  [002,100]
 DRIVER(find)

 character exp(MAXARG,NEXPR), pat(MAXPAT,NEXPR), lin(MAXLINE),
	   arg(MAXARG)
 integer i, getarg, except, andpat, count, elevel, itoc, getpat,
	 mcount, getlin, matchd, status, gmatch, index

 string usestr "usage:  find [-acx] expression [expression] ..."

 data except/NO/
 data andpat/NO/
 data count /NO/
 data elevel/0/

 call query(usestr)
 for (i=1; getarg(i, arg, MAXARG) != EOF; i=i+1)
    if (arg(1) == MINUS)
	{
	call scopy(arg, 1, lin, 1)
	call fold(lin)
	if (index(lin, LETA) > 0)
	    andpat = YES
	if (index(lin, LETC) > 0)
	    count = YES
	if (index(lin, LETX) > 0)
	    except = YES
	}
    else if (elevel < NEXPR)
	{
	elevel = elevel + 1
	call scopy(arg, 1, exp(1, elevel), 1)
	}
    else
	{
	call putlin("Maximum number of expressions permitted is ", ERROUT)
	status = itoc(NEXPR, arg, MAXARG)
	call error(arg)
	}
 if (elevel == 0)
    call error(usestr)
 for (i=1; i <= elevel; i=i+1)
    if (getpat(exp(1,i), pat(1,i)) == ERR)
	{
	call putlin("illegal pattern: ", ERROUT)
	call error(exp(1,i))
	}
 mcount = 0
 while (getlin(lin, STDIN) != EOF)
    {
    matchd = gmatch(lin, pat, elevel, andpat)
    if ((matchd == YES & except == NO) | (matchd == NO & except == YES))
	if (count == YES)
	    mcount = mcount + 1
	else
	    call putlin(lin, STDOUT)
    }
 if (count == YES)
    {
    call putdec(mcount, 1)
    call putc(NEWLINE)
    }

 DRETURN
 end
#-h- gmatch           377  asc  27-apr-81 08:36:11  [002,100]
 integer function gmatch(lin, pat, elevel, andpat)

 integer elevel, andpat, match, i, status
 character lin(ARB), pat(MAXPAT, NEXPR)

 gmatch = andpat
 for (i=1; i <= elevel; i=i+1)
    {
    status = match(lin, pat(1,i))
    if (andpat == NO & status == YES)
	{
	gmatch = YES
	break
	}
    else if (andpat == YES & status == NO)
	{
	gmatch = NO
	break
	}
    }

 return
 end
#-h- find.rof        3358  asc  06-may-81 07:57:53  [002,100]
.bp 
.rm 70 
.pl 60 
.in 0 
.he 'FIND'03/03/78'FIND 
.fo ''-#-'' 
.fi 
.in 7 
.ti -7 
NAME 
.br 
find - search a file for text patterns 
.sp 1 
.ti -7 
SYNOPSIS 
.br 
find
[-acx] expr [expr ...]
.sp 1 
.ti -7 
DESCRIPTION 
.br 
find
searches the standard input file for lines matching the text patterns
"expr" (up to 9 patterns may be specified) according to the matching
criterion specified by the switches.  (A text pattern is a subset of a
"regular expression"--see the writeup on "ed" for a complete description
of regular expressions.)  Unless the -c option is specified, each matching
line is copied to the standard output.

By default, any line which matches any one of the expressions is considered
a matching line.  If the -a flag is specified, only lines which match all
expressions in any order are considered to match.  If the -x flag is
specified, all lines which don't satisfy the above criteria are considered
matching lines.  And finally, if the -c option is specified, matching
lines are counted instead of being copied to the standard output, and the
final count is written to the standard output.
  
A text pattern consists of the following elements: 
  
.nf 
c      literal character 
?      any character except newline 
%      beginning of line 
$      end of line (null string before newline) 
[...]  character class (any one of these characters) 
[!...] negated character class (all but these characters) 
*      closure (zero or more occurrences of previous pattern) 
+      anchored closure (one or more occurrences of previous pattern)
@c     escaped character (e.g., @%, @[, @*) 
  
.fi 
Any special meaning of characters in a text pattern is lost when 
escaped, inside [...], or for: 
  
.nf 
%         not at beginning 
$         not at end 
*         at beginning 
+         at beginning 
  
.fi 
A character class consists of zero or more of the following 
elements, surrounded by [ and ]: 
  
.nf 
c         literal character, including [ 
a-b       range of characters (digits, lower or upper case) 
!         negated character class if at beginning 
@c        escaped character (@! @- @@ @]) 
  
.fi 
Special meaning of characters in a character class is lost when 
escaped or for 
  
.nf 
!         not at beginning 
-         at beginning or end 
  
.fi 
An escape sequence consists of the character @ followed by a single 
character: 
  
.nf 
@f        formfeed
@l        linefeed
@n        newline 
@r        carriage return
@t        tab 
@c        c (including @@) 
  
.fi 
For a complete description, see "Software Tools" pages 135-154. 
Care should be taken when using the characters % $ [ ] ! * + @ and 
any shell characters
in the text pattern. It is often necessary to enclose the 
entire substitution pattern in quotes. 
.sp 1 
.ti -7 
FILES 
.br 
None 
.sp 1 
.ti -7 
SEE ALSO 
.br 
tr, ed, ch and the UNIX grep command. 
.sp 1 
.ti -7 
DIAGNOSTICS 
.br 
An error message is printed if one of the patterns given is illegal. 
.sp 1 
.ti -7
AUTHORS
.br
Originally from Kernighan & Plauger's "Software Tools", with major
modifications by Joe Sventek.
.sp 1
.ti -7 
BUGS 
.br 
An expression may not start with a minus sign(-).

A very complex escape scheme must be used when not operating 
inside the shell on BKY.  This is because BKY only accepts the CDC character 
set in command arguments (see /*/doc/guide). 
