#-h- detab.r         1467  asc  09-apr-81 09:02:15  [002,101]
#-h- main             740  asc  09-apr-81 09:01:46  [002,101]
 ## driver for detab tool

 DRIVER(detab)
    character buf(MAXLINE)
    integer open, getarg, length, alldig
    integer tabs(MAXLINE), int, i, k, l
  
 
    call query("usage:  detab [<t1>...] [+<n>] [file] ...")
    call argtab(buf)		# fetch tab info into buf
    call settab(buf, tabs)	# set tab stops
    int = ERR
  
     for (i=1; getarg(i, buf, MAXLINE) != EOF; i=i+1)
	{
        if (buf(1) == PLUS | alldig(buf) == YES)	#ignore flags
		next
	if (buf(1) == MINUS & buf(2) == EOS)	#read from standard input
		int = STDIN
	else
		int = open(buf, READ)
	if (int == ERR)
		call cant(buf)
	call detab (tabs, int)
	if (int != STDIN)
		call close(int)
	}
   
    if (int == ERR)	#no files read
	call detab(tabs, STDIN)
    DRETURN
    end
#-h- detabs           603  asc  09-apr-81 09:01:48  [002,101]
 ## detab - convert tabs to equivalent number of blanks
 subroutine detab (tabs, int)
 integer int
 character getch
 character c
 integer tabs(ARB)
 integer tabpos
 integer col
 
    col = 1 
    while (getch(c, int) != EOF) 
       if (c == TAB) 
          repeat { 
             call putc(BLANK) 
             col = col + 1 
             if (tabpos(col, tabs) == YES) 
                break 
             } 
       else if (c == NEWLINE) { 
          call putc(NEWLINE) 
          col = 1 
          } 
       else { 
          call putc(c) 
          col = col + 1 
          } 
    return 
    end 
#-h- detab.rof        869  asc  03-may-81 01:06:17  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'DETAB'date'DETAB'
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
detab - convert tabs to spaces
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
detab [<t1>...] [+<n>] [file...]
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
Detab converts tab characters (control-i) to equivalent strings
of blanks.
Tab stops are indicated by <t1>...
(default 8, 16, ...),
while +<n> indicates tab stops
every <n> columns.
Thus the command
  
.ti +3
detab 5 21 +5
  
supplies blanks for tabs terminating at column positions 5, 21, 26, etc.
If no files are specified, the standard input is read.
An isolated minus sign also indicates the standard input.
.sp 1
.in 
SEE ALSO 
.br 
.in 7 
entab; lpr
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
.sp 1 
Original from Kernighan & Plauger's 'Software Tools', with modifications
by Dennis Hall and Debbie Scherrer.
.sp 1 
.in 
BUGS 
.br 
.in 7 
None to date.
