#-h- crypt.r          903  asc  08-apr-81 09:55:28  [002,101]
#-h- defns             56  asc  08-apr-81 09:55:05  [002,101]
 # definitions for crypt tool
 
 define(MAXKEY,MAXLINE)
#-h- main             540  asc  08-apr-81 09:55:06  [002,101]
 # crypt - encrypt and decrypt standard input

 DRIVER(crypt)
 character getc, xor
 character c, key(MAXKEY), b
 integer getarg, mod
 integer i, keylen

 string usestr "usage:  crypt key."
  
 call query(usestr)
 keylen = getarg(1,key,MAXKEY)
 if (keylen == EOF)
	call error(usestr)
 for (i=1; getc(c) != EOF; i = mod(i,keylen) + 1)
	{
	if (c < BLANK)		#leave control characters alone
		call putc(c)
	else
		{
		b = xor(c, key(i) & 31)
      		if (b == 127)		#DEC can't handle RUBOUT char
      			b = c
		call putc(b)
		}
	}
 DRETURN
 end
#-h- xor              121  asc  08-apr-81 09:55:07  [002,101]
 # xor - exclusive-or of a and b
 character function xor(a,b)
 character a, b
  
 xor = (a & !b) | (!a & b)
 return
 end
#-h- crypt.rof       1138  asc  02-may-81 21:56:04  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'CRYPT'1/15/79'CRYPT'
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
crypt - crypt and decrypt standard input
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
crypt
key
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
Crypt
encrypts characters on the standard input by using 'key'.
The file can eventually be decrypted by running it back through
crypt with the same key.
Double encryption (encrypting a file with first one key and then
another) is allowable, but on some systems the decryption must
be done in the exact reverse order as encryption was done.
 
The encryption algorithm used by 'crypt' is not a complicated one, so
users requiring a great degree of protection should not rely on
this tool.
.sp 1
.in 
FILES 
.br 
.in 7 
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
.sp 1 
Original from Kernighan & Plauger's 'Software Tools', with modifications
by Debbie Scherrer.  (NOTE:  the original encryption algorithm has been
altered slightly.)
.sp 1 
.in 
BUGS 
.br 
.in 7 
On IAS and VMS systems, double encryption must be decrypted in the
exact reverse order as the encryption.
