#-h- ccomm            314  asc  08-apr-81 09:44:43  [002,101]
 ## ccomm - common block to hold flags for comm
 # Put on a file called 'ccomm'
 # Used only the comm tool
 
 common /ccomm/  one, two, three
 integer one		#flag to print col1 (lines only in file 1)
 integer two		#flag to print col2 (lines only in file 2)
 integer three		#flag to print col3 (lines in both files)
#-h- comm.r          3442  asc  08-apr-81 09:44:44  [002,101]
#-h- main             787  asc  08-apr-81 09:44:22  [002,101]
 ## comm - print lines common to two files
 DRIVER(comm)
 
 character buf(MAXLINE)
 integer getarg, open, index
 integer i, file(2), j

 include ccomm    
 
 string usestr "usage:  comm [-123] file1 [file2]."

 call query(usestr)
 one = YES
 two = YES
 three = YES
 j = 0
 for (i=1; getarg(i,buf,MAXLINE)!=EOF; i=i+1)
	{
	if (j == 2)
		break
	if (buf(1) == MINUS & buf(2) != EOS)
		{
		if (index(buf, DIG1) == 0)
			one = NO
		if (index(buf, DIG2) == 0)
			two = NO
		if (index(buf, DIG3) == 0)
			three = NO
		}
	else if (buf(1) == MINUS)
		{
		j = j + 1
		file(j) = STDIN
		}
	else
		{
		j = j + 1
		file(j) = open(buf,READ)
		if (file(j) == ERR)
			call cant(buf)
		}
	}
 
 if (j == 0)
	call error(usestr)
 
 if (j == 1)
	file(2) = STDIN
 call common(file(1), file(2))

 DRETURN
 end
#-h- cmpar            272  asc  08-apr-81 09:44:23  [002,101]
 ## cmpar - compare lin1 with lin2
 integer function cmpar(lin1, lin2)
 character lin1(ARB), lin2(ARB)
 integer i
 
 for (i=1; lin1(i) == lin2(i); i=i+1)
	if (lin1(i) == EOS)
		{
		cmpar = 0
		return
		}
 if (lin1(i) < lin2(i))
	cmpar = -1
 else
	cmpar = + 1
 return
 end
#-h- col1             282  asc  08-apr-81 09:44:24  [002,101]
 ## col1 - print col1 (lines only in file1) for comm tool
 #  (remove leading blanks)
 subroutine col1 (buf)
 character buf(ARB)
 include ccomm    
 
 if (one == NO)		#return if column not to be printed
	return
 i = 1
 call skipbl (buf, i)
 call putlin(buf(i), STDOUT)
 return
 end
#-h- col2             355  asc  08-apr-81 09:44:24  [002,101]
 ## col2 - print col2 (lines only in file2) for comm tool
 # (remove leading blanks)
 
 subroutine col2 (buf)
 character buf(ARB)
 integer i
 include ccomm    
 
 if (two == NO)		#return if column not to be printed
	return
 if (one == YES)
	for (i=1; i<=15; i=i+1)
		call putc(BLANK)
 i = 1
 call skipbl (buf, i)
 call putlin(buf(i), STDOUT)
 return
 end
#-h- col3             415  asc  08-apr-81 09:44:25  [002,101]
 ## col3 - print col3 (lines in both files) for comm tool
 #  (remove leading blanks)
 subroutine col3(buf)
 character buf(ARB)
 integer i
 include ccomm    
 
 if (three == NO)		#return if column not to be printed
	return
 if (one == YES)
	for (i=1; i<=10; i=i+1)
		call putc(BLANK)
 if (two == YES)
	for (i=1; i<=15; i=i+1)
		call putc(BLANK)
 i = 1
 call skipbl(buf, i)
 call putlin(buf(i), STDOUT)
 return
 end
#-h- common           959  asc  08-apr-81 09:44:26  [002,101]
 ## common - print lines common to file1 and file2
 subroutine common(file1, file2)
 integer file1, file2, k, stat1, stat2
 integer getlin
 character buf1(MAXLINE), buf2(MAXLINE)
 integer cmpar
 
 stat1 = getlin(buf1,file1)
 stat2 = getlin(buf2,file2)
 repeat
	{
	if (stat1 == EOF | stat2 == EOF)
		break
	k = cmpar(buf1, buf2)		#compare lines
	if (k < 0)			#line only in file1
		{
		call col1(buf1)
		stat1 = getlin(buf1, file1)
		}
	else if (k > 0)			#line only in file2
		{
		call col2(buf2)
		stat2 = getlin(buf2, file2)
		}
	else				#line in both files
		{
		call col3(buf1)
		stat1 = getlin(buf1, file1)
		stat2 = getlin(buf2, file2)
		}
	}
 
 if (stat1 == EOF & two == YES)		#end of file1, print rest of file2
	while(stat2 != EOF)
		{
		call col2(buf2)
		stat2 = getlin(buf2, file2)
		}
 else if (stat2 == EOF & one == YES)	#end of file2, print rest of file1
	while (stat1 != EOF)
		{
		call col1(buf1)
		stat1 = getlin(buf1, file1)
		}
 
 return
 end
#-h- comm.rof        1259  asc  02-may-81 21:53:16  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'COMM'1/11/79'COMM'
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
comm - print lines common to two files
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
comm
[-123] file1 [file2]
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
Comm
reads 
file1
and
file2,
which should be sorted, and produces a three column output:
lines only in
file1,
lines only in
file2,
and lines in both files.
The filename '-' means the standard input.  
If there is only one file argument,
file2
refers to the standard input.
   
The optional arguments -1, -2, and -3 specify the printing of
only the corresponding column.
Thus 
comm -3
prints only the lines common to both files, and
comm -12
prints lines which are in either file, but not in both.
The default is -123.
.sp 1
.in 
FILES 
.br 
.in 7 
None
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
The tool 'cmp'; the Unix tool 'diff'.
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
A message is printed if an input file cannot be opened.
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
.sp 1 
Debbie Scherrer
.sp 1 
.in 
BUGS 
.br 
.in 7 
The flags used by this tool are the reverse of those used by the
Unix 'comm'.  In Unix, the flags 1, 2, and 3
suppress
printing of the corresponding column.
Kernighan, on page 126 of 'Software Tools' suggests the
version used above.
