#-h- cat.r            830  asc  08-apr-81 08:23:23  [002,101]
#-h- main             768  asc  08-apr-81 08:22:16  [002,101]
 ## cat - concatenate named files onto standard output
 DRIVER(cat)
 
 character buf(MAXLINE)
 integer getarg, open
 integer i, int
 ifdef(BKY)
  integer gettyp, ovride, junk
 enddef
 
 call query("usage:  cat [file] ...")
 for (i=1; getarg(i, buf, MAXLINE) != EOF; i=i+1)
	    {
	    if (buf(1) == MINUS & buf(2) == EOS)
		int = STDIN
	    else
		int = open(buf, READ)
            if (int == ERR)
		call cant(buf)

	ifdef(BKY)
 #For BKY, set stdout type to that of first input file, unless overridden
	    if (i == 1 & ovride(STDOUT) == NO)
		call settyp(STDOUT, gettyp(int,junk))
	enddef
 
            call fcopy(int, STDOUT)
            if (int != STDIN)
		call close(int)
	    }
	if (i == 1)	# no arguments passed
		call fcopy (STDIN, STDOUT)
        DRETURN
	end
#-h- cat.rof          994  asc  02-may-81 21:27:54  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'CAT'02/16/78'CAT' 
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
cat -- concatenate and print text files 
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
cat [file1] [file2]... 
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
`cat' reads each file in sequence and writes it on the standard output. 
Thus 
.sp 1 
.ti +5 
cat file 
.sp 1 
prints the file, and 
.sp 1 
.ti +5 
cat file1 file2 >file3 
.sp 1 
concatenates the first two files and places the result on the third. 
.sp 1 
If no argument or '-' is given, `cat' reads the standard input.
.sp 1 
.in 
FILES 
.br 
.in 7 
None
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
The "Software Tools" book, p. 77. 
.br
The UNIX tools cat, PR, CP
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
A message is printed if a file cannot be opened; 
further processing is terminated.
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
.sp 1 
Dennis Hall, 
Debbie Scherrer and Wen-Sue Gee. 
.sp 1 
.in 
BUGS 
.br 
.in 7 
Using the same file for output as well as input may 
cause strange results. 
