C  ADVENTURES
	SUBROUTINE INIT
C
C MODIFIED BY KENT BLACKETT
C             ENGINEERING SYSTEMS GROUP
C             DIGITAL EQUIPMENT CORP.
C             15-JUL-77
C MODIFIED BY	BOB SUPNIK
C		DISK ENGINEERING
C		21-OCT-77
C MODIFIED BY	BOB SUPNIK
C		DISK ENGINEERING
C		25-AUG-78
C ORIGINAL VERSION WAS FOR DECSYSTEM-10
C NEXT VERSION WAS FOR FORTRAN IV-PLUS UNDER
C THE IAS OPERATING SYSTEM ON THE PDP-11/70
C THIS VERSION IS FOR FORTRAN IV (V01C OR LATER)
C UNDER RT-11 ON *ANY* PDP-11
C
C
C  CURRENT LIMITS:
C	750 TRAVEL OPTIONS (TRAVEL, TRVSIZ).
C	350 VOCABULARY WORDS (KTAB, ATAB, TABSIZ).
C	150 LOCATIONS (LTEXT, STEXT, KEY, COND, ABB, ATLOC, LOCSIZ).
C	100 OBJECTS (PLAC, PLACE, FIXD, FIXED, LINK (TWICE), PTEXT, PROP).
C	 40 "ACTION" VERBS (ACTSPK, VRBSIZ).
C	205 RANDOM MESSAGES (RTEXT, RTXSIZ).
C	 12 DIFFERENT PLAYER CLASSIFICATIONS (CTEXT, CVAL, CLSMAX).
C	 20 HINTS, LESS 3 (HINTLC, HINTED, HINTS, HNTSIZ).
C	[MAGIC MESSAGES HAVE BEEN DECOMMITTED]
C	 35 MAGIC MESSAGES (MTEXT, MAGSIZ).
C  THERE ARE ALSO LIMITS WHICH CANNOT BE EXCEEDED DUE TO THE STRUCTURE OF
C  THE DATABASE.  (E.G., THE VOCABULARY USES N/1000 TO DETERMINE WORD TYPE,
C  SO THERE CAN'T BE MORE THAN 1000 WORDS.)  THESE UPPER LIMITS ARE:
C	1000 NON-SYNONYMOUS VOCABULARY WORDS
C	300 LOCATIONS
C	100 OBJECTS
C
	IMPLICIT INTEGER (A-Z)
	LOGICAL BLKLIN,NOINPT
	LOGICAL DSEEN,HINTED
	LOGICAL BITSET,LMWARN,CLOSNG,PANIC,
	1       CLOSED,GAVEUP,SCORNG
C
	COMMON /VERSN/ VMAJ,VMIN,VEDIT
	COMMON /TXTCOM/ RTEXT,LINES,ASCVAR
	COMMON /BLKCOM/ BLKLIN,NOINPT
	COMMON /VOCCOM/ KTAB,ATAB,A2TAB,TABSIZ
	COMMON /PLACOM/ ATLOC,LINK,PLACE,FIXED,HOLDNG
C	COMMON /MTXCOM/ MTEXT
	COMMON /PTXCOM/ PTEXT
	COMMON /ABBCOM/ ABB
	COMMON /MISCOM/ LINUSE,TRVS,CLSSES,OLDLOC,LOC,CVAL,TK,NEWLOC,
	1KEY,PLAC,FIXD,ACTSPK,COND,HINTS,HNTMAX,PROP,TALLY,TALLY2,
	2HINTLC,CHLOC,CHLOC2,DSEEN,DFLAG,DLOC,DALTLC,KEYS,LAMP,GRATE,
	3CAGE,ROD,ROD2,STEPS,BIRD,DOOR,PILLOW,SNAKE,FISSUR,TABLET,
	4CLAM,OYSTER,MAGZIN,DWARF,KNIFE,FOOD,BOTTLE,WATER,OIL,PLANT,
	5PLANT2,AXE,MIRROR,DRAGON,CHASM,TROLL,TROLL2,BEAR,MESSAG,VEND,
	6BATTER,NUGGET,COINS,CHEST,EGGS,TRIDNT,VASE,EMRALD,PYRAM,
	7PEARL,RUG,CHAIN,BACK,LOOK,CAVE,NULL,ENTRNC,DPRSSN,SAY,LOCK,
	8THROW,FIND,INVENT,TURNS,LMWARN,KNFLOC,DETAIL,ABBNUM,
	9NUMDIE,MAXDIE,DKILL,FOOBAR,BONUS,CLOCK1,CLOCK2,
	1CLOSNG,PANIC,CLOSED,GAVEUP,SCORNG,ODLOC,STREAM,SPICES
	COMMON /MISC2/ I,RTXSIZ,CLSMAX,MAGSIZ,LOCSIZ,CTEXT,STEXT,LTEXT,
	1SECT,TRAVEL,TRVCON,TRVLOC,TRVSIZ,TABNDX,OBJ,J,K,VERB,HNTSIZ,
	2MAXTRS,HINTED,HNTLOC,KK
C
	DIMENSION LINES(36)
	DIMENSION TRAVEL(750),TRVCON(750),TRVLOC(750)
	DIMENSION KTAB(350),ATAB(350),A2TAB(350)
	DIMENSION LTEXT(150),STEXT(150),KEY(150),COND(150),ABB(150),
	1	ATLOC(150)
	DIMENSION PLAC(100),PLACE(100),FIXD(100),FIXED(100),LINK(200),
	1	PTEXT(100),PROP(100)
	DIMENSION ACTSPK(40)
	DIMENSION RTEXT(205)
	DIMENSION CTEXT(12),CVAL(12)
	DIMENSION HINTLC(20),HINTED(20),HINTS(20,4)
C	DIMENSION MTEXT(35)
	DIMENSION TK(20),DSEEN(6),DLOC(6),ODLOC(6)
C
C
	BITSET(L,N)=(COND(L).AND.ISHFT(1,N)).NE.0

C  DESCRIPTION OF THE DATABASE FORMAT
C
C
C  THE DATA FILE CONTAINS SEVERAL SECTIONS.  EACH BEGINS WITH A LINE CONTAINING
C  A NUMBER IDENTIFYING THE SECTION, AND ENDS WITH A LINE CONTAINING "-1".
C
C  SECTION 1: LONG FORM DESCRIPTIONS.  EACH LINE CONTAINS A LOCATION NUMBER,
C	A COMMA, AND A LINE OF TEXT.  THE SET OF (NECESSARILY ADJACENT) LINES
C	WHOSE NUMBERS ARE X FORM THE LONG DESCRIPTION OF LOCATION X.
C  SECTION 2: SHORT FORM DESCRIPTIONS.  SAME FORMAT AS LONG FORM.  NOT ALL
C	PLACES HAVE SHORT DESCRIPTIONS.
C  SECTION 3: TRAVEL TABLE.  EACH LINE CONTAINS A LOCATION NUMBER (X), A SECOND
C	LOCATION NUMBER (Y), AND A LIST OF MOTION NUMBERS (SEE SECTION 4).
C	EACH MOTION REPRESENTS A VERB WHICH WILL GO TO Y IF CURRENTLY AT X.
C	Y, IN TURN, IS INTERPRETED AS FOLLOWS.  LET M=Y/1000, N=Y MOD 1000.
C		IF N<=300	IT IS THE LOCATION TO GO TO.
C		IF 300<N<=500	N-300 IS USED IN A COMPUTED GOTO TO
C					A SECTION OF SPECIAL CODE.
C		IF N>500	MESSAGE N-500 FROM SECTION 6 IS PRINTED,
C					AND HE STAYS WHEREVER HE IS.
C	MEANWHILE, M SPECIFIES THE CONDITIONS ON THE MOTION.
C		IF M=0		IT'S UNCONDITIONAL.
C		IF 0<M<100	IT IS DONE WITH M% PROBABILITY.
C		IF M=100	UNCONDITIONAL, BUT FORBIDDEN TO DWARVES.
C		IF 100<M<=200	HE MUST BE CARRYING OBJECT M-100.
C		IF 200<M<=300	MUST BE CARRYING OR IN SAME ROOM AS M-200.
C		IF 300<M<=400	PROP(M MOD 100) MUST *NOT* BE 0.
C		IF 400<M<=500	PROP(M MOD 100) MUST *NOT* BE 1.
C		IF 500<M<=600	PROP(M MOD 100) MUST *NOT* BE 2, ETC.
C	IF THE CONDITION (IF ANY) IS NOT MET, THEN THE NEXT *DIFFERENT*
C	"DESTINATION" VALUE IS USED (UNLESS IT FAILS TO MEET *ITS* CONDITIONS,
C	IN WHICH CASE THE NEXT IS FOUND, ETC.).  TYPICALLY, THE NEXT DEST WILL
C	BE FOR ONE OF THE SAME VERBS, SO THAT ITS ONLY USE IS AS THE ALTERNATE
C	DESTINATION FOR THOSE VERBS.  FOR INSTANCE:
C		15	110022	29	31	34	35	23	43
C		15	14	29
C	THIS SAYS THAT, FROM LOC 15, ANY OF THE VERBS 29, 31, ETC., WILL TAKE
C	HIM TO 22 IF HE'S CARRYING OBJECT 10, AND OTHERWISE WILL GO TO 14.
C		11	303008	49
C		11	9	50
C	THIS SAYS THAT, FROM 11, 49 TAKES HIM TO 8 UNLESS PROP(3)=0, IN WHICH
C	CASE HE GOES TO 9.  VERB 50 TAKES HIM TO 9 REGARDLESS OF PROP(3).
C
C ********************
C	IN THIS IMPLEMENTATION, THE SECOND LOCATION NUMBER Y HAS BEEN
C	SPLIT INTO M, CONDITIONS, AND N, LOCATION.
C
C  SECTION 4: VOCABULARY.  EACH LINE CONTAINS A NUMBER (N), A TAB, AND A
C	FIVE-LETTER WORD.  CALL M=N/1000.  IF M=0, THEN THE WORD IS A MOTION
C	VERB FOR USE IN TRAVELLING (SEE SECTION 3).  ELSE, IF M=1, THE WORD IS
C	AN OBJECT.  ELSE, IF M=2, THE WORD IS AN ACTION VERB (SUCH AS "CARRY"
C	OR "ATTACK").  ELSE, IF M=3, THE WORD IS A SPECIAL CASE VERB (SUCH AS
C	"DIG") AND N MOD 1000 IS AN INDEX INTO SECTION 6.  OBJECTS FROM 50 TO
C	(CURRENTLY, ANYWAY) 79 ARE CONSIDERED TREASURES (FOR PIRATE, CLOSEOUT).
C  SECTION 5: OBJECT DESCRIPTIONS.  EACH LINE CONTAINS A NUMBER (N), A TAB,
C	AND A MESSAGE.  IF N IS FROM 1 TO 100, THE MESSAGE IS THE "INVENTORY"
C	MESSAGE FOR OBJECT N.  OTHERWISE, N SHOULD BE 000, 100, 200, ETC., AND
C	THE MESSAGE SHOULD BE THE DESCRIPTION OF THE PRECEDING OBJECT WHEN ITS
C	PROP VALUE IS N/100.  THE N/100 IS USED ONLY TO DISTINGUISH MULTIPLE
C	MESSAGES FROM MULTI-LINE MESSAGES; THE PROP INFO ACTUALLY REQUIRES ALL
C	MESSAGES FOR AN OBJECT TO BE PRESENT AND CONSECUTIVE.  PROPERTIES WHICH
C	PRODUCE NO MESSAGE SHOULD BE GIVEN THE MESSAGE ">$<".
C  SECTION 6: ARBITRARY MESSAGES.  SAME FORMAT AS SECTIONS 1, 2, AND 5, EXCEPT
C	THE NUMBERS BEAR NO RELATION TO ANYTHING (EXCEPT FOR SPECIAL VERBS
C	IN SECTION 4).
C  SECTION 7: OBJECT LOCATIONS.  EACH LINE CONTAINS AN OBJECT NUMBER AND ITS
C	INITIAL LOCATION (ZERO (OR OMITTED) IF NONE).  IF THE OBJECT IS
C	IMMOVABLE, THE LOCATION IS FOLLOWED BY A "-1".  IF IT HAS TWO LOCATIONS
C	(E.G. THE GRATE) THE FIRST LOCATION IS FOLLOWED WITH THE SECOND, AND
C	THE OBJECT IS ASSUMED TO BE IMMOVABLE.
C  SECTION 8: ACTION DEFAULTS.  EACH LINE CONTAINS AN "ACTION-VERB" NUMBER AND
C	THE INDEX (IN SECTION 6) OF THE DEFAULT MESSAGE FOR THE VERB.
C  SECTION 9: LIQUID ASSETS, ETC.  EACH LINE CONTAINS A NUMBER (N) AND UP TO 20
C	LOCATION NUMBERS.  BIT N (WHERE 0 IS THE UNITS BIT) IS SET IN COND(LOC)
C	FOR EACH LOC GIVEN.  THE COND BITS CURRENTLY ASSIGNED ARE:
C		0	LIGHT
C		1	IF BIT 2 IS ON: ON FOR OIL, OFF FOR WATER
C		2	LIQUID ASSET, SEE BIT 1
C		3	PIRATE DOESN'T GO HERE UNLESS FOLLOWING PLAYER
C	OTHER BITS ARE USED TO INDICATE AREAS OF INTEREST TO "HINT" ROUTINES:
C		4	TRYING TO GET INTO CAVE
C		5	TRYING TO CATCH BIRD
C		6	TRYING TO DEAL WITH SNAKE
C		7	LOST IN MAZE
C		8	PONDERING DARK ROOM
C		9	AT WITT'S END
C	COND(LOC) IS SET TO 2, OVERRIDING ALL OTHER BITS, IF LOC HAS FORCED
C	MOTION.
C  SECTION 10: CLASS MESSAGES.  EACH LINE CONTAINS A NUMBER (N), A TAB, AND A
C	MESSAGE DESCRIBING A CLASSIFICATION OF PLAYER.  THE SCORING SECTION
C	SELECTS THE APPROPRIATE MESSAGE, WHERE EACH MESSAGE IS CONSIDERED TO
C	APPLY TO PLAYERS WHOSE SCORES ARE HIGHER THAN THE PREVIOUS N BUT NOT
C	HIGHER THAN THIS N.  NOTE THAT THESE SCORES PROBABLY CHANGE WITH EVERY
C	MODIFICATION (AND PARTICULARLY EXPANSION) OF THE PROGRAM.
C  SECTION 11: HINTS.  EACH LINE CONTAINS A HINT NUMBER (CORRESPONDING TO A
C	COND BIT, SEE SECTION 9), THE NUMBER OF TURNS HE MUST BE AT THE RIGHT
C	LOC(S) BEFORE TRIGGERING THE HINT, THE POINTS DEDUCTED FOR TAKING THE
C	HINT, THE MESSAGE NUMBER (SECTION 6) OF THE QUESTION, AND THE MESSAGE
C	NUMBER OF THE HINT.  THESE VALUES ARE STASHED IN THE "HINTS" ARRAY.
C	HNTMAX IS SET TO THE MAX HINT NUMBER (<= HNTSIZ).  NUMBERS 1-3 ARE
C	UNUSABLE SINCE COND BITS ARE OTHERWISE ASSIGNED, SO 2 IS USED TO
C	REMEMBER IF HE'S READ THE CLUE IN THE REPOSITORY, AND 3 IS USED TO
C	REMEMBER WHETHER HE ASKED FOR INSTRUCTIONS (GETS MORE TURNS, BUT LOSES
C	POINTS).
C  SECTION 12: MAGIC MESSAGES. IDENTICAL TO SECTION 6 EXCEPT PUT IN A SEPARATE
C	SECTION FOR EASIER REFERENCE.  MAGIC MESSAGES ARE USED BY THE STARTUP,
C	MAINTENANCE MODE, AND RELATED ROUTINES.
C  SECTION 0: END OF DATABASE.

C INIT THE RANDOM NUMBER GENERATOR
C
	CALL IDATE(I,J,K)
	I=I.OR.K
	J=J.OR.K
	CALL INIRND(I,J)
C
C  READ THE DATABASE IF WE HAVE NOT YET DONE SO
C
	FILSIZ=900
	TABSIZ=350
	LOCSIZ=150
	VRBSIZ=40
	BLKLIN=.TRUE.
	NOINPT=.TRUE.
	RTXSIZ = 205
	HNTSIZ = 20
	MAGSIZ = 35
	TRVSIZ = 750
	CLSMAX = 12
D	VCOUNT = 0
D	TYPE 1000
D1000	FORMAT(' INITIALIZING...')
C
C FIRST, TRY TO RESTORE PRE-EXISTING COPY OF DATA BASE
C
	CALL RSTRGM(.FALSE.,I)
	IF(I.NE.0) GO TO 10
	CALL ASSIGN(2,'PB0:[300,375]ATEXT.DAT')
	CALL	FDBSET (2,'RO')
	DEFINE FILE 2(FILSIZ,37,U,ASCVAR)
	GO TO 5000

C  CLEAR OUT THE VARIOUS TEXT-POINTER ARRAYS.  ALL TEXT IS STORED IN DISK
C  FILE (RANDOM ACCESS ON UNIT 2).  THE TEXT-POINTER ARRAYS CONTAIN RECORD
C  NUMBERS IN THE FILE.  STEXT(N) IS SHORT DESCRIPTION OF LOCATION N.
C  LTEXT(N) IS LONG DESCRIPTION.  PTEXT(N) POINTS TO MESSAGE FOR PROP(N)=0.
C  SUCCESSIVE PROP MESSAGES ARE FOUND BY CHASING POINTERS.  RTEXT CONTAINS
C  SECTION 6'S STUFF.  CTEXT(N) POINTS TO A PLAYER-CLASS MESSAGE.  MTEXT IS FOR
C  SECTION 12.  WE ALSO CLEAR COND.  SEE DESCRIPTION OF SECTION 9 FOR DETAILS.
C
10	DO 1001 I=1,TABSIZ
	KTAB(I)=0
	ATAB(I)=0
	A2TAB(I)=0
	IF(I.GT.100) GO TO 1990
	PTEXT(I)=0
	PROP(I)=0
	PLAC(I)=0
	PLACE(I)=0
	FIXD(I)=0
	FIXED(I)=0
	LINK(I)=0
	LINK(I+100)=0
1990	IF(I.LE.RTXSIZ)RTEXT(I)=0
	IF(I.LE.CLSMAX)CTEXT(I)=0
C	IF(I.LE.MAGSIZ)MTEXT(I)=0
	IF(I.LE.VRBSIZ)ACTSPK(I)=0
	IF(I.GT.LOCSIZ)GOTO 1001
	KEY(I)=0
	ABB(I)=0
	ATLOC(I)=0
	STEXT(I)=0
	LTEXT(I)=0
	COND(I)=0
1001	CONTINUE
C
	CALL ASSIGN(1,'ATEXT.TXT')
	CALL FDBSET (1,'RO')
	CALL ASSIGN(2,'ATEXT.DAT')
	DEFINE FILE 2(FILSIZ,37,U,ASCVAR)
	ASCVAR = 1
	LINUSE=1
	TRVS=1
	CLSSES=1
C
C  START NEW DATA SECTION.  SECT IS THE SECTION NUMBER.
C
1002	READ(1,1003)SECT
1003	FORMAT(I5)
D	TYPE 930,SECT
D930	FORMAT(' NOW LOADING SECTION',I3)
	OLDLOC=-1
	GOTO(1100,1004,1004,1030,1040,1004,1004,1050,1060,1070,1004,
	1    1080,1004) (SECT+1)
C	      (0)  (1)  (2)  (3)  (4)  (5)  (6)  (7)  (8)  (9)  (10)
C	     (11) (12)
	CALL BUG(9)
C
C  SECTIONS 1, 2, 5, 6, 10, 12.  READ MESSAGES AND SET UP POINTERS.
C
1004	READ(1,1005) LOC,LINES
1005	FORMAT(I5,36A2)
	WRITE(2'ASCVAR) LOC,LINES
	LINUSE = ASCVAR-1
	IF(LOC .EQ. -1) GO TO 1002
	IF(LOC .EQ. OLDLOC) GO TO 1020
	IF(SECT.EQ.12)GOTO 1013
	IF(SECT.EQ.10)GOTO 1012
	IF(SECT.EQ.6)GOTO 1011
	IF(SECT.EQ.5)GOTO 1010
	IF(SECT.EQ.1)GOTO 1008
C
	IF(LOC.GT.LOCSIZ) CALL BUG(11)
	STEXT(LOC)=LINUSE
	GOTO 1020
C
1008	IF(LOC.GT.LOCSIZ) CALL BUG(11)
	LTEXT(LOC)=LINUSE
	GOTO 1020
C
1010	IF(LOC.GT.0.AND.LOC.LE.100)PTEXT(LOC)=LINUSE
	GOTO 1020
C
1011	IF(LOC .GT. RTXSIZ) CALL BUG(6)
	RTEXT(LOC)=LINUSE
	GOTO 1020
C
1012	IF(CLSSES.GT.CLSMAX) CALL BUG(12)
	CTEXT(CLSSES)=LINUSE
	CVAL(CLSSES)=LOC
	CLSSES=CLSSES+1
	GOTO 1020
C
1013	CONTINUE
C	IF(LOC.GT.MAGSIZ)CALL BUG(6)
C	MTEXT(LOC)=LINUSE
C
1020	OLDLOC = LOC
	IF(LINUSE .GE. FILSIZ) CALL BUG(2)
	GOTO 1004
C
C  THE STUFF FOR SECTION 3 IS ENCODED HERE.  EACH "FROM-LOCATION" GETS A
C  CONTIGUOUS SECTION OF THE "TRAVEL" ARRAY.  EACH ENTRY IN TRAVEL IS
C  KEYWORD (FROM SECTION 4, MOTION VERBS), AND IS NEGATED IF
C  THIS IS THE LAST ENTRY FOR THIS LOCATION.  KEY(N) IS THE INDEX IN TRAVEL
C  OF THE FIRST OPTION AT LOCATION N.
C
C  SPECIAL CONDITIONS ON TRAVEL ARE ENCODED IN THE CORRESPONDING
C  ENTRIES OF TRVCON.  THE NEW LOCATION IS IN TRVLOC.
C
C
1030	READ(1,1031)LOC,J,NEWLOC,TK
1031	FORMAT(99I6)
	IF(LOC.EQ.-1)GOTO 1002
	IF(KEY(LOC).NE.0)GOTO 1033
	KEY(LOC)=TRVS
	GOTO 1035
1033	TRAVEL(TRVS-1)=-TRAVEL(TRVS-1)
1035	DO 1037 L=1,20
	IF(TK(L).EQ.0)GOTO 1039
	TRAVEL(TRVS)=TK(L)
	TRVLOC(TRVS)=NEWLOC
	TRVCON(TRVS)=J
	TRVS=TRVS+1
	IF(TRVS.EQ.TRVSIZ)CALL BUG(3)
1037	CONTINUE
1039	TRAVEL(TRVS-1)=-TRAVEL(TRVS-1)
	GOTO 1030
C
C  HERE WE READ IN THE VOCABULARY.  KTAB(N) IS THE WORD NUMBER, ATAB(N) IS
C  THE CORRESPONDING WORD.  THE -1 AT THE END OF SECTION 4 IS LEFT IN KTAB
C  AS AN END-MARKER.
C
1040	DO 1042 TABNDX=1,TABSIZ
1043	READ(1,1041)KTAB(TABNDX),ATAB(TABNDX),A2TAB(TABNDX)
1041	FORMAT(I6,2A2)
	IF(KTAB(TABNDX).EQ.-1)GOTO 1002
1042	CONTINUE
	CALL BUG(4)
C
C  READ IN THE INITIAL LOCATIONS FOR EACH OBJECT.  ALSO THE IMMOVABILITY INFO.
C  PLAC CONTAINS INITIAL LOCATIONS OF OBJECTS.  FIXD IS -1 FOR IMMOVABLE
C  OBJECTS (INCLUDING THE SNAKE), OR = SECOND LOC FOR TWO-PLACED OBJECTS.
C
1050	READ(1,1031)OBJ,J,K
	IF(OBJ.EQ.-1)GOTO 1002
	IF(OBJ.GT.100) CALL BUG(13)
	PLAC(OBJ)=J
	FIXD(OBJ)=K
	GOTO 1050
C
C  READ DEFAULT MESSAGE NUMBERS FOR ACTION VERBS, STORE IN ACTSPK.
C
1060	READ(1,1031)VERB,J
	IF(VERB.EQ.-1)GOTO 1002
	IF(VERB.GT.VRBSIZ) CALL BUG(10)
	ACTSPK(VERB)=J
D	VCOUNT=MAX0(VERB,VCOUNT)
	GOTO 1060
C
C  READ INFO ABOUT AVAILABLE LIQUIDS AND OTHER CONDITIONS, STORE IN COND.
C
1070	READ(1,1031)K,TK
	IF(K.EQ.-1)GOTO 1002
	DO 1071 I=1,20
	LOC=TK(I)
	IF(LOC.EQ.0)GOTO 1070
	IF(BITSET(LOC,K))CALL BUG(8)
1071	COND(LOC)=COND(LOC)+ISHFT(1,K)
	GOTO 1070
C
C  READ DATA FOR HINTS.
C
1080	HNTMAX=0
1081	READ(1,1031)K,TK
	IF(K.EQ.-1)GOTO 1002
	IF(K.LT.0.OR.K.GT.HNTSIZ)CALL BUG(7)
	DO 1083 I=1,4
1083	HINTS(K,I)=TK(I)
	HNTMAX=MAX0(HNTMAX,K)
	GOTO 1081

C  FINISH CONSTRUCTING INTERNAL DATA FORMAT
C  THEN SAVE THE RESULTS
C
1100	CALL CLOSE(1)
	CALL SAVEGM(.FALSE.,I)
C
C  HAVING READ IN THE DATABASE, CERTAIN THINGS ARE NOW CONSTRUCTED.  PROPS ARE
C  SET TO ZERO.  WE FINISH SETTING UP COND BY CHECKING FOR FORCED-MOTION TRAVEL
C  ENTRIES.  THE PLAC AND FIXD ARRAYS ARE USED TO SET UP ATLOC(N) AS THE FIRST
C  OBJECT AT LOCATION N, AND LINK(OBJ) AS THE NEXT OBJECT AT THE SAME LOCATION
C  AS OBJ.  (OBJ>100 INDICATES THAT FIXED(OBJ-100)=LOC; LINK(OBJ) IS STILL THE
C  CORRECT LINK TO USE.)  ABB IS ZEROED; IT CONTROLS WHETHER THE ABBREVIATED
C  DESCRIPTION IS PRINTED.  COUNTS MOD 5 UNLESS "LOOK" IS USED.
C
C
C  IF THE FIRST MOTION VERB IS 1 (ILLEGAL), THEN THIS IS A FORCED
C  MOTION ENTRY.
C
5000	DO 1102 I=1,LOCSIZ
	IF(LTEXT(I).EQ.0.OR.KEY(I).EQ.0)GOTO 1102
	K=KEY(I)
	IF(IABS(TRAVEL(K)).EQ.1)COND(I)=2
1102	CONTINUE
C
C  SET UP THE ATLOC AND LINK ARRAYS AS DESCRIBED ABOVE.  WE'LL USE THE DROP
C  SUBROUTINE, WHICH PREFACES NEW OBJECTS ON THE LISTS.  SINCE WE WANT THINGS
C  IN THE OTHER ORDER, WE'LL RUN THE LOOP BACKWARDS.  IF THE OBJECT IS IN TWO
C  LOCS, WE DROP IT TWICE.  THIS ALSO SETS UP "PLACE" AND "FIXED" AS COPIES OF
C  "PLAC" AND "FIXD".  ALSO, SINCE TWO-PLACED OBJECTS ARE TYPICALLY BEST
C  DESCRIBED LAST, WE'LL DROP THEM FIRST.
C
	DO 1106 I=1,100
	K=101-I
	IF(FIXD(K).LE.0)GOTO 1106
	CALL DROP(K+100,FIXD(K))
	CALL DROP(K,PLAC(K))
1106	CONTINUE
C
	DO 1107 I=1,100
	K=101-I
	FIXED(K)=FIXD(K)
1107	IF(PLAC(K).NE.0.AND.FIXD(K).LE.0)CALL DROP(K,PLAC(K))
C
C  TREASURES, AS NOTED EARLIER, ARE OBJECTS 50 THROUGH MAXTRS (CURRENTLY 79).
C  THEIR PROPS ARE INITIALLY -1, AND ARE SET TO 0 THE FIRST TIME THEY ARE
C  DESCRIBED.  TALLY KEEPS TRACK OF HOW MANY ARE NOT YET FOUND, SO WE KNOW
C  WHEN TO CLOSE THE CAVE.  TALLY2 COUNTS HOW MANY CAN NEVER BE FOUND (E.G. IF
C  LOST BIRD OR BRIDGE).
C
	MAXTRS=79
	TALLY=0
	TALLY2=0
	DO 1200 I=50,MAXTRS
	IF(PTEXT(I).NE.0)PROP(I)=-1
1200	TALLY=TALLY-PROP(I)
C
C  CLEAR THE HINT STUFF.  HINTLC(I) IS HOW LONG HE'S BEEN AT LOC WITH COND BIT
C  I.  HINTED(I) IS TRUE IFF HINT I HAS BEEN USED.
C
	DO 1300 I=1,HNTMAX
	HINTED(I)=.FALSE.
1300	HINTLC(I)=0
C
D	TYPE 931,TABNDX,TABSIZ,VCOUNT,VRBSIZ,CLSSES,CLSMAX,
D	1	HNTMAX,HNTSIZ,TRVS,TRVSIZ,LINUSE,FILSIZ
D931	FORMAT(' USED VS MAX TABLE VALUES:'/
D	1	1X,I5,' OF ',I5,' VOCAB ENTRIES'/
D	2	1X,I5,' OF ',I5,' VERB ENTRIES'/
D	3	1X,I5,' OF ',I5,' CLASS ENTRIES'/
D	4	1X,I5,' OF ',I5,' HINT ENTRIES'/
D	5	1X,I5,' OF ',I5,' TRAVEL ENTRIES'/
D	6	1X,I5,' OF ',I5,' FILE RECORDS'/
D	9	)
C
C  DEFINE SOME HANDY MNEMONICS.  THESE CORRESPOND TO OBJECT NUMBERS.
C
	CALL VOCAB('KE','YS',1,KEYS)
	CALL VOCAB('LA','MP',1,LAMP)
	CALL VOCAB('GR','AT',1,GRATE)
	CALL VOCAB('CA','GE',1,CAGE)
	CALL VOCAB('RO','D ',1,ROD)
	ROD2=ROD+1
	CALL VOCAB('ST','EP',1,STEPS)
	CALL VOCAB('BI','RD',1,BIRD)
	CALL VOCAB('DO','OR',1,DOOR)
	CALL VOCAB('PI','LL',1,PILLOW)
	CALL VOCAB('SN','AK',1,SNAKE)
	CALL VOCAB('FI','SS',1,FISSURE)
	CALL VOCAB('TA','BL',1,TABLET)
	CALL VOCAB('CL','AM',1,CLAM)
	CALL VOCAB('OY','ST',1,OYSTER)
	CALL VOCAB('MA','GA',1,MAGZIN)
	CALL VOCAB('DW','AR',1,DWARF)
	CALL VOCAB('KN','IF',1,KNIFE)
	CALL VOCAB('FO','OD',1,FOOD)
	CALL VOCAB('BO','TT',1,BOTTLE)
	CALL VOCAB('WA','TE',1,WATER)
	CALL VOCAB('OI','L ',1,OIL)
	CALL VOCAB('PL','AN',1,PLANT)
	PLANT2=PLANT+1
	CALL VOCAB('AX','E ',1,AXE)
	CALL VOCAB('MI','RR',1,MIRROR)
	CALL VOCAB('DR','AG',1,DRAGON)
	CALL VOCAB('CH','AS',1,CHASM)
	CALL VOCAB('TR','OL',1,TROLL)
	TROLL2=TROLL+1
	CALL VOCAB('BE','AR',1,BEAR)
	CALL VOCAB('ME','SS',1,MESSAG)
	CALL VOCAB('VE','ND',1,VEND)
	CALL VOCAB('BA','TT',1,BATTER)
C
C  OBJECTS FROM 50 THROUGH WHATEVER ARE TREASURES.  HERE ARE A FEW.
C
	CALL VOCAB('GO','LD',1,NUGGET)
	CALL VOCAB('CO','IN',1,COINS)
	CALL VOCAB('CH','ES',1,CHEST)
	CALL VOCAB('EG','GS',1,EGGS)
	CALL VOCAB('TR','ID',1,TRIDNT)
	CALL VOCAB('VA','SE',1,VASE)
	CALL VOCAB('EM','ER',1,EMRALD)
	CALL VOCAB('PY','RA',1,PYRAM)
	CALL VOCAB('PE','AR',1,PEARL)
	CALL VOCAB('RU','G ',1,RUG)
	CALL VOCAB('CH','AI',1,CHAIN)
	CALL VOCAB('SP','IC',1,SPICES)
C
C  THESE ARE MOTION-VERB NUMBERS.
C
	CALL VOCAB('BA','CK',0,BACK)
	CALL VOCAB('LO','OK',0,LOOK)
	CALL VOCAB('CA','VE',0,CAVE)
	CALL VOCAB('NU','LL',0,NULL)
	CALL VOCAB('EN','TR',0,ENTRNC)
	CALL VOCAB('DE','PR',0,DPRSSN)
	CALL VOCAB('ST','RE',0,STREAM)
C
C  AND SOME ACTION VERBS.
C
	CALL VOCAB('SA','Y ',2,SAY)
	CALL VOCAB('LO','CK',2,LOCK)
	CALL VOCAB('TH','RO',2,THROW)
	CALL VOCAB('FI','ND',2,FIND)
	CALL VOCAB('IN','VE',2,INVENT)
C
C  INITIALISE THE DWARVES.  DLOC IS LOC OF DWARVES, HARD-WIRED IN.  ODLOC IS
C  PRIOR LOC OF EACH DWARF, INITIALLY GARBAGE.  DALTLC IS ALTERNATE INITIAL LOC
C  FOR DWARF, IN CASE ONE OF THEM STARTS OUT ON TOP OF THE ADVENTURER.  (NO 2
C  OF THE 5 INITIAL LOCS ARE ADJACENT.)  DSEEN IS TRUE IF DWARF HAS SEEN HIM.
C  DFLAG CONTROLS THE LEVEL OF ACTIVATION OF ALL THIS:
C	0	NO DWARF STUFF YET (WAIT UNTIL REACHES HALL OF MISTS)
C	1	REACHED HALL OF MISTS, BUT HASN'T MET FIRST DWARF
C	2	MET FIRST DWARF, OTHERS START MOVING, NO KNIVES THROWN YET
C	3	A KNIFE HAS BEEN THROWN (FIRST SET ALWAYS MISSES)
C	3+	DWARVES ARE MAD (INCREASES THEIR ACCURACY)
C  SIXTH DWARF IS SPECIAL (THE PIRATE).  HE ALWAYS STARTS AT HIS CHEST'S
C  EVENTUAL LOCATION INSIDE THE MAZE.  THIS LOC IS SAVED IN CHLOC FOR REF.
C  THE DEAD END IN THE OTHER MAZE HAS ITS LOC STORED IN CHLOC2.
C
	CHLOC=114
	CHLOC2=140
	DO 1700 I=1,6
1700	DSEEN(I)=.FALSE.
	DFLAG=0
	DLOC(1)=19
	DLOC(2)=27
	DLOC(3)=33
	DLOC(4)=44
	DLOC(5)=64
	DLOC(6)=CHLOC
	DALTLC=18
C
C  OTHER RANDOM FLAGS AND COUNTERS, AS FOLLOWS:
C	TURNS	TALLIES HOW MANY COMMANDS HE'S GIVEN (IGNORES YES/NO)
C	LIMIT	LIFETIME OF LAMP (NOT SET HERE)
C	KNFLOC	0 IF NO KNIFE HERE, LOC IF KNIFE HERE, -1 AFTER CAVEAT
C	DETAIL	HOW OFTEN WE'VE SAID "NOT ALLOWED TO GIVE MORE DETAIL"
C	ABBNUM	HOW OFTEN WE SHOULD PRINT NON-ABBREVIATED DESCRIPTIONS
C	MAXDIE	NUMBER OF REINCARNATION MESSAGES AVAILABLE (UP TO 5)
C	NUMDIE	NUMBER OF TIMES KILLED SO FAR
C	HOLDNG	NUMBER OF OBJECTS BEING CARRIED
C	DKILL	NUMBER OF DWARVES KILLED (UNUSED IN SCORING, NEEDED FOR MSG)
C	FOOBAR	CURRENT PROGRESS IN SAYING "FEE FIE FOE FOO".
C	BONUS	USED TO DETERMINE AMOUNT OF BONUS IF HE REACHES CLOSING
C	CLOCK1	NUMBER OF TURNS FROM FINDING LAST TREASURE TILL CLOSING
C	CLOCK2	NUMBER OF TURNS FROM FIRST WARNING TILL BLINDING FLASH
C	LOGICALS WERE EXPLAINED EARLIER
C
	TURNS=0
	LMWARN=.FALSE.
	KNFLOC=0
	DETAIL=0
	ABBNUM=5
	DO 1800 I=0,4
1800	IF(RTEXT(2*I+81).NE.0)MAXDIE=I+1
	NUMDIE=0
	HOLDNG=0
	DKILL=0
	FOOBAR=0
	BONUS=0
	CLOCK1=30
	CLOCK2=50
	CLOSNG=.FALSE.
	PANIC=.FALSE.
	CLOSED=.FALSE.
	GAVEUP=.FALSE.
	SCORNG=.FALSE.
C
C
C
C  FINALLY, SINCE WE'RE CLEARLY SETTING THINGS UP FOR THE FIRST TIME...
C
D	PAUSE 'INIT DONE'
C
	RETURN
	END
