On the next page, in rough HELP file format, is how I would like
to see the calling sequence to PAXES to be.  I think this would
give the greatest versatility and  compatability with other
subroutines that have been written.  The routines which generate
that beautiful polar axis of yours could stand some cleaning up;
i.e. one routine to replace: AXISP, AXISR and AXISL; another to
replace: ATIC, LTIC and RTIC; NUMB and DEGL might be combined;
CONV1 and PLUS should be incorporated into one of the subroutines;
and perhaps it would be best to make CIRC into CIRCLE and have it
just draw an arc of any specified size &c.  To help make things, for me,
easier to keep straight, it would also help if you rename all your
files to, PAXES1, PAXES2, ..., PAXESn.  And to help, when people
need to overlay, try to make all their lengths about equal.
 
Also available now, if you've seen the login message or HELP NEW,
are a couple of routine to check for number of arguments and write
error messages and traceback information.  Hopefully, this will all
be of some help to you, it is the least I can do to thank you for
all the help you're giving me (it is not my intention to just give
you the least amount of help that I can, but it is all that I am
able to at this time).
 
 						Paul

 CALL PAXES( X0, Y0, ORIENT, TH0, DTH, MAJTH, MINTH, NRAD,
	RMIN, V0, DV, DL, NMAJ, NMIN, NDEC, 
	NGRID, TITLE, NCHRS, SIZE )  --  This subroutine
 generates and annotates a linear polar coordinate system.
 Data may be scaled and unscaled by using subroutines
 PSTN and NTSP, respectively.  .FCTR: PAXES
 
 X0, Y0		Location of the origin, inches.
 ORIENT		Orientation of the "0 degree" line with respect
		to a rightward going horizontal, degrees.
 TH0		Minimum azimuthal coordinate value, degrees.
 DTH		Change in azimuth per major division, degrees.
 MAJTH		Number of major azimuthal divisions.
 MINTH		Number of minor azimuthal divisions per major division,
		if .LE. 1, no minor divisions will be drawn.
 NRAD		Logical variable that when .TRUE. signifies that the
		annoatation of the axes is to be done in fractions of pi.
		If .FALSE., annotation will be in degrees.
 RMIN		Minimum inner radius, inches.
 V0		Coordinate value at the inner radius.
 DV		Change in value per major division.
 DL		Change in length per major division, inches.
 NMAJ		Number of major radial divisions.
 NMIN		Number of minor radial divisions per major division.
 NDEC		Number of places to the right of the decimal point
		in the annotation of the radial axis.
 NGRID		Grid selection switch, .AND. values together
		0	No grid.
		1	Azimuthal arcs.
		2	Azimuthal tics.
		4	Radial lines.
		8	Radial tics.
		16	"+" at the origin.
 TITLE		String containing title.
 NCHRS		In absolute value, number of characters in the
		TITLE; if positive, TITLE is along radius; if negative,
		TITLE is centered below coordinate system.
 SIZE		Size of annotation, TITLE will be 1.5*SIZE, inches.
