(*
 
	Component :	READUPF -- READ USER PROFILE FILE
 
	Date:		September 23,1980
 
	Author:		Tom Mathieu
			Battelle-Northwest
			Box 999
			Richland, Washington 99352
			(509) 375-3711
 
	Source:		Swedish Pascal
 
	Calling Seq:	RUN [11,1]READUPF
 
	Inputs:		[1,200]PDSUPF.DAT
 
	Outputs:	ACCSESS.DAT
 
	Comments:
*)

PROGRAM READUPF(TTY);
 
TYPE	UPF	= RECORD		(**  SESS APP A OF SYS MAN GUIDE **)
		USN : ARRAY [1..8] OF CHAR;
		UIC : ARRAY [1..2] OF CHAR;
		PAS : ARRAY [1..4] OF CHAR;
		FIL : ARRAY [1..20] OF CHAR;
		UCA : INTEGER;
		UUA : ARRAY [1..2] OF INTEGER;
		FL2 : ARRAY [1..24] OF CHAR
		END;
 
VAR	F : FILE OF UPF;
	O : TEXT;
	UNM : ARRAY [1..12] OF CHAR;
	MCT : REAL;
	I,J,K,L : INTEGER;
 
PROCEDURE R50ASC(VAR I:INTEGER; VAR C1,C2:CHAR); EXTERN(FORTRAN);
 
BEGIN
RESET (F,'PDSUPF.DAT','(1,200)');
REWRITE(O,'ACCTSSES.DAT');
I := ORD(F^.USN[1]) + ORD(F^.USN[2])*256;
J := ORD(F^.USN[3]) + ORD(F^.USN[4])*256;
FOR K := 2 TO I DO GET(F);
WHILE K<=J+1 DO  WITH F^ DO
  BEGIN
  GET(F);
  K := K+1;
  IF UUA[2] < 0 THEN BEGIN MCT := 2.0*UUA[1]+1; UUA[2] := MAXINT+UUA[2]+1 END
		ELSE MCT := 2.0*UUA[1];
  MCT := (MCT * 32768.0 + UUA[2])/1000.0;
  L := 12;
  R50ASC(L,USN[1],UNM[1]);
  IF UNM[1] <> ' ' THEN
    WRITELN(O,UNM,' [',ORD(UIC[2]):3:O,',',ORD(UIC[1]):3:O,']',UCA:6,MCT:9:1);
  END;
WRITELN(J-I+1,' USERS IN UPF.');
END.
