#-h- spsym            307 asc 28-aug-80 14:32:06
 define(PIDSIZE,7)
 define(TREELIMIT,DIG9)
 define(SNDEFN,5)
 define(NSEC,5)
 define(SECONDS,2)
 define(GETEFN,6)
 define(SPNEFN,7)
 define(ARGBUFSIZE,256)
 define(WAIT,LETW)
 define(spawn,sspawn)
 define(ESCAPE,27)
 define(IO.RLB,8%1000)
 define(IO.WLB,8%400)
 define(IO.ATT,8%1400)
 define(IO.DET,8%2000)
#-h- ossym            864 asc 28-aug-80 14:32:07
 # Additional symbols for PDP 11/70 installation
  # Put on a file called 'ossym'
 
 define(MAXARGS,25)		#max number of command line args allowed
 define(NNFILES,6)		#max number of files allowed open at a time
 define(FREEUNIT,7)		# free lun used for various and sundry stuff
 define(TTYUNIT,8)		# free lun used for tty activities
 define(NEWREAD,99)		#flag for creating new file
 define(SCRATCH,98)		# flag for scratch file
 define(PRINT,97)		# flag for print file
 define(INPUTMODE,0)		# flag for mode of io
 define(OUTPUTMODE,1)
 define(OWNER,-1)		#flag for receiving message for parent task
 define(CLOSED,0)		# lfn(int) value if no file opened
 define(OPENED,1)		# lfn(int) value if file is opened
 define(TERMINAL,2)		# lfn(int) value if opened file is tty
 define(CHARACTERMASK,0)	# used in calls to maskit
 define(INTEGERMASK,1)		# used in calls to maskit
#-h- cspawn           515 asc 28-aug-80 14:32:09
 common / cspawn / efn, iffore, ifback, ifbast, forepc(PIDSIZE),
		   backpc(PIDSIZE), tasknm(PIDSIZE)

 integer efn		# event flag number used in spawn for foregrnd procs
 integer iffore		# if foreground process in progress - YES/NO
 integer ifback		# if background process in progress - YES/NO
 integer ifbast		# if background process terminated - YES/NO
 character forepc	# pid for foreground process in progress
 character backpc	# pid for background process in progress
 character tasknm	# pid for this process
#-h- crawtt           234 asc 28-aug-80 14:32:09
 common / crawtt / ids, param(6), iosb(4)

 integer bcount # number of characters xferred
 integer ids	# directive status word
 integer param	# parameter block for qio
 logical*1 iosb # io status block

 equivalence (iosb(3), bcount)
#-h- srargs.r        1986 asc 28-aug-80 14:32:11
#-h- nspawn.q        1343 asc 28-aug-80 14:31:31
 include ossym

 include spsym

 integer function spawn(image, args, pid, wait)

 character image(FILENAMESIZE), args(ARGBUFSIZE), pid(PIDSIZE),
	   local(6), wait, mcrlin(80), filarg(FILENAMESIZE)
 real mcr
 integer equal, length, n, errsb(8)

 include cspawn
 include crawtt

 data local/LETL, LETO, LETC, LETA, LETL, EOS/
%
      data mcr/6RMCR.../
%

 spawn = ERR
 call scopy(image, 1, mcrlin, 1)
 call fold(mcrlin)
 if (equal(mcrlin, local) == YES)
    call scopy(args, 1, mcrlin, 1)
 else
    {
    call genpnm(1, pid)
    if (length(args) > 0)
	{
	call asnlun(FREEUNIT, "SR", 0, ids)
	if (ids <= 0)
	    return
	call getadr(param(1), args)
	param(2) = length(args)
	call irad50(6, pid, param(3))
	param(5) = 0
	param(6) = 1		# non-zero tells driver to flush old messages
	call wtqio(IO.WLB, FREEUNIT, SPNEFN,, iosb, param, ids)
	if (ids <= 0 | iosb(1) <= 0)
	    return
	}
    call genrun(image, pid, mcrlin)
    }
 n = length(mcrlin)
 efn = SPNEFN
 call extpnm(mcrlin, forepc)
 call scopy(forepc, 1, pid, 1)
 iffore = YES
 call wtqio(IO.DET, TTYUNIT)
%
      call spawn(mcr,,, efn,, errsb,, mcrlin, n, 0,, ids)
%
 if (ids <= 0)
    {
    iffore = NO
    spawn = ERR
     }
 else
    {
    call stopfr(SPNEFN, ids)
    iffore = NO
    if (errsb(1) > 1)
	spawn = ERR
    else
	spawn = OK
    }
 call wtqio(IO.ATT, TTYUNIT)

 return
 end
#-h- ngetmsg.q        545 asc 28-aug-80 14:31:33
 integer function getmsg(buf)

 character buf(ARB)
 integer n, getlin, oldmak

 include crawtt

 call getpnm(buf)
 if ((buf(1) == DOLLAR | buf(1) == PERIOD) & buf(2) != buf(1))
    {
    call asnlun(FREEUNIT, "SR", 0, ids)
    if (ids > 0)
	{
	call getadr(param(1), buf)
	param(2) = ARGBUFSIZE
	call wtqio(IO.RLB, FREEUNIT, SPNEFN,, iosb, param, ids)
	if (ids > 0)
	    ids = iosb(1)
	}
    if (ids > 0)
	n = bcount + 1
    else
	{
	buf(1) = BLANK
	n = 2
	}
    buf(n) = EOS
    getmsg = n - 1
    }
 else
    getmsg = oldmak(buf)

 return
 end
