#-h- split.r         2127 asc 08-may-80 11:11:53
#-h- main             285 asc 08-may-80 11:11:39
 #---------------------------------------------------------------------
 # include symbol definitions
 #        include symbols
 #---------------------------------------------------------------------
 ## main - calling routine for split
 
# call initr4
# call split
# call endr4
# end
#-h- splits           900 asc 08-may-80 11:11:39
 ## split - split a file into pieces
# subroutine split
 subroutine main
 
 integer getarg, create, open, ctoi, nlcopy
 character buf(MAXLINE), outf(FILENAMESIZE)
 integer nl, i, j, in, usein, out
 data outf(1), outf(2) / LETX, EOS/
 
 nl = 1000
 usein = NO
 in = STDIN
 			#pick up file name(s)
 for (i=1; getarg(i,buf,MAXLINE)!=EOF; i=i+1)
	{
	if (buf(1) == QMARK & buf(2) == EOS)
		call error ('usage:  split [-n] [file [name]].')
	else if (buf(1) == MINUS)
		{
		if (buf(2) == EOS)
			usein = YES
		else
			{
			j = 2
			nl = max(ctoi(buf,j), 1)
			}
		}
	else if (usein == NO)
		{
		in = open(buf,READ)
		if (in == ERR)
			call cant(buf)
		usein = YES
		}
	else
		call scopy(buf, 1, outf, 1)
	}
 
	#main loop to break up file
 repeat
	{
	call extnam(outf, buf)
	out = create(buf, WRITE)
	if (out == ERR)
		call cant(buf)
	if (nlcopy(in, out, nl) == EOF)
		break
	call close(out)
	}
 return
 end
#-h- extnam           452 asc 08-may-80 11:11:40
 ## extnam - add unique extension to filename -file-
 subroutine extnam (file, name)
 character file(ARB), name(ARB), append(3)
 integer length
 
 data append(1), append(2), append(3) /LETA, LETA, EOS/
 
 call scopy(file, 1, name, 1)
 if (append(2) > LETZ)
	{
	append(2) = LETA
	append(1) = append(1) + 1
	if (append(1) > LETZ)
		call error ('out of file names.')
	}
 call scopy(append, 1, name, length(name)+1)
 append(2) = append(2) + 1
 return
 end
#-h- nlcopy           294 asc 08-may-80 11:11:41
 ## nlcopy - copy n lines from file in to file out
 integer function nlcopy (in, out, n)
 character buf(MAXLINE)
 integer getlin
 integer in, out, n, i
 
 for (i=1; i<=n; i=i+1)
	{
	if (getlin(buf,in) == EOF)
		{
		nlcopy = EOF
		return
		}
	call putlin(buf, out)
 	}
 nlcopy = OK
 return
 end
