#-h- mailsym          207 asc 20-aug-80 12:26:38
# symbol definitions used by:   mail,   postmn
# should be placed on a file named     mailsym
#
 define(UNKNOWN,-1)
 define(USERSIZE,40)
 define(TERMEOF,"^Z")
 define(TIMEZONE,"PST")
 define(RIGHTMARGIN,72)
#-h- cmail            445 asc 20-aug-80 12:26:38
# common block used by:  mail
# should be placed on a file named     cmail
#
 common / cmail /  nusers, regist, edit, temp1(FILENAMESIZE),
		   temp2(FILENAMESIZE)

 integer nusers		#  number of validated users to send mail to
 integer regist		#  whether mail is registered or not
 integer edit		#  whether to invoke editor to generate mail to send
 character temp1	#  name of mail temporary file
 character temp2	#  name of mail temporary file
#-h- mail.r          8718 asc 20-aug-80 12:26:41
#-h- maildrv.q         45 asc 08-may-80 09:22:46
# call initr4
# call mail
# call endr4
# end
#-h- mails.q          791 asc 08-may-80 09:22:46
# subroutine mail
 subroutine main
 
 include mailsym
 
 character arg(FILENAMESIZE), buf(MAXLINE), file(FILENAMESIZE)
 integer i, int, n, junk
 integer getarg, equal, open, getlin, index, getwrd
 
 include cmail

 string all "all"
 string flags "+-?"

 call malint(arg, file, buf)
 for (i=1; getarg(i, arg, FILENAMESIZE) != EOF; i=i+1)
    {
    call fold(arg)
    if (equal(arg, all) == YES)
	{
	call adrfil(file)
	int = open(file, READ)
	if (int != ERR)
	    {
	    while (getlin(buf, int) != EOF)
		{
		n = 1
		junk = getwrd(buf, n, arg)
		if (junk > 0)
		    call addusr(arg, buf)
		}
	    call close(int)
	    }
	}
    else if (index(flags, arg(1)) > 0)
	call malcmd(arg, file, buf)
    else
	call addusr(arg, buf)
    }
 if (nusers != 0)
    call sdmail(buf, arg, file)

 return
 end
#-h- addusr.q         689 asc 08-may-80 09:22:47
 #	addusr -- subroutine to add user to stack of users for mail

 subroutine addusr(arg, temp)

 character arg(USERSIZE), temp(FILENAMESIZE)
 integer int, init
 integer create, lookup

 include cmail

 string t1 "mt1"
 string t2 "mt2"

 data init /YES/

 if (init == YES)
    {
    call scratf(t1, temp1)
    call scratf(t2, temp2)
    int = create(temp1, WRITE)
    if (int == ERR)
	call merror(temp1)
    init = NO
    }
 if (arg(1) == EOS)
    call close(int)
 else if (lookup(arg, temp) == YES)
    {
    nusers = nusers + 1
    call putlin(arg, int)
    call putch(NEWLINE, int)
    }
 else
    {
    call putlin("Invalid user name: ", ERROUT)
    call remark(arg)
    }

 return
 end
#-h- badarg.q         130 asc 08-may-80 09:22:48
 subroutine badarg(arg)

 character arg(ARB)

 call putlin("Ignoring invalid argument: ", ERROUT)
 call remark(arg)

 return
 end
#-h- cleanf.q          94 asc 08-may-80 09:22:49
 subroutine cleanf

 include cmail

 call remove(temp1)
 call remove(temp2)
 call endr4

 end
#-h- dotost.q         673 asc 08-may-80 09:22:50
 subroutine dotost(out, user)

 integer out, in, i, j, n
 integer open, length, getlin
 character user(USERSIZE)

 include cmail

 string tos "To:     "
 string bls "        "

 in = open(temp1, READ)
 if (in == ERR)
    call merror(temp1)
 call putlin(tos, out)
 j = 9
 for (i=getlin(user,in); i !=  EOF; i=getlin(user,in))
    {
    user(i) = EOS
    n = j + length(user) + 1
    if (n > RIGHTMARGIN)
	{
	call putch(COMMA, out)
	call putch(NEWLINE, out)
	call putlin(bls, out)
	j = 9
	}
    if (j > 9)
	call putch(COMMA, out)
    call putch(BLANK, out)
    call putlin(user, out)
    j = j + length(user) + 2
    }
 call putch(NEWLINE, out)
 call close(in)

 return
 end
#-h- editit.q         438 asc 20-aug-80 12:26:26
 subroutine editit(file, buf)

 character file(FILENAMESIZE), buf(ARB), proc(FILENAMESIZE), pid(PIDSIZE)
 integer i, spawn, loccom

 string ed "ed"

 call impath(buf)
 if (loccom(ed, buf, proc) != BINARY)
    call error("Cannot locate ed image file.")
 i = 1
 call stcopy(ed, 1, buf, i)
 call chcopy(BLANK, buf, i)
 call scopy(file, 1, buf, i)
 if (spawn(proc, buf, pid, WAIT) != OK)
    call error("Error in spawning ed!")

 return
 end
#-h- gsbjct.q         271 asc 08-may-80 09:22:52
 subroutine gsbjct(buf)

 character buf(MAXLINE)
 integer n
 integer tty, prompt

 string subjct "Subject: "

 if (tty(STDIN) == YES)
    {
    n = prompt(subjct, buf, STDIN)
    if (n >= 1)
	buf(n) = EOS
    else
	buf(1) = EOS
    }
 else
    buf(1) = EOS

 return
 end
#-h- malcmd.q        1092 asc 08-may-80 09:22:53
 #-----------------------------------------------------------
 ##	malcmd -- interprets command switches for mail
 
 subroutine malcmd(iarg, out, buf)
 
 character iarg(FILENAMESIZE), mllist(FILENAMESIZE), out(FILENAMESIZE),
	   buf(MAXLINE)
 integer i, int, open, getlin, getwrd, index
 
 include cmail
 
 if (iarg(1) == PLUS & iarg(2) == LETL)
    {
    call scopy(iarg, 3, mllist, 1)
    int = open(mllist, READ)
    if (int != ERR)
	{
	while (getlin(buf, int) != EOF)
	    {
	    i = index(buf, SHARP)	# pound sign signals start of comment
	    if (i > 0)
		buf(i) = EOS		# terminate scan for users there
	    i = 1
	    while (getwrd(buf, i, out) > 0)
		call addusr(out, iarg)
	    }
	call close(int)
	}
    else
	{
	call putlin("Error in opening mailing list file: ", ERROUT)
	call remark(mllist)
	}
    }
 else if (iarg(1) == PLUS & iarg(2) == LETR)
    regist = YES
 else if (iarg(1) == QMARK & iarg(2) == EOS)
    call error("usage:  mail [+lmlist] [+r] [+e] [all] [addressee ...]")
 else if (iarg(1) == PLUS & iarg(2) == LETE)
    edit = YES
 else
    call badarg(iarg)
 return
 end
#-h- malinp.q        1257 asc 08-may-80 09:22:54
 subroutine malinp(temp, file, buf, edit)

 integer edit, int, open, tty, create, getlin, inp, fsize, prompt
 character file(FILENAMESIZE), buf(MAXLINE), clower, temp(FILENAMESIZE)

 string mts "mts"

 int = create(temp, WRITE)
 if (int == ERR)
    call merror(temp)
 call gsbjct(buf)
 call pstmrk(int, buf)
 inp = STDIN
 if (tty(STDIN) == YES)
    {
    if (edit == YES)
        {
        call scratf(mts, file)
        call remark("You are now entering ed to create your mail")
        call remark("Please wait for ed to respond with 0")
        call editit(file, buf)
        inp = open(file, READ)
        if (inp == ERR | fsize(file) == 0)
            {
	    call close(inp)
            call remove(file)
            call close(int)
            call cleanf
            }
        }
    else
        {
        call putlin("Input message: (q to quit or ", ERROUT)
        call putlin(TERMEOF, ERROUT)
        call remark(" to send)")
        }
    }
 while (getlin(buf, inp) != EOF)
    if (clower(buf(1)) == LETQ & buf(2) == NEWLINE & edit == NO)
        {
        call close(int)
        call cleanf
        }
    else
        call putlin(buf, int)
 call close(int)
 if (inp != STDIN)
    {
    call close(inp)
    call remove(file)
    }

 return
 end
#-h- malint.q         507 asc 08-may-80 09:22:55
 subroutine malint(arg, file, buf)

 character arg(FILENAMESIZE), file(FILENAMESIZE), buf(MAXLINE)
 integer int, i, junk
 integer open, getlin, getwrd

 include cmail

 nusers = 0
 regist = NO
 edit = NO
 call adrfil(file)
 call tbinit
 int = open(file, READ)
 if (int != ERR)
    {
    while (getlin(buf, int) != EOF)
	{
	i = 1
	junk = getwrd(buf, i, arg)
	junk = getwrd(buf, i, file)
	call instal(arg, file)
	}
    call close(int)
    }
 else
    call error("Cannot open local users file.")

 return
 end
#-h- merror.q         149 asc 08-may-80 09:22:56
 subroutine merror(buf)

 character buf(ARB)

 call putlin("Cannot open mail temporary file: ", ERROUT)
 call remark(buf)
 call cleanf

 return
 end
#-h- pstmrk.q         827 asc 08-may-80 09:22:57
 subroutine pstmrk(int, subjct)
 
 character idate(10), itime(10), user(USERSIZE), cupper, dummy(FILENAMESIZE)
 character hdrpat(4), subjct(ARB)
 integer int

 string dates "Date:    "
 string dashst " - "
 string timzon TIMEZONE
 string froms "From:    "
 string subjs "Subject: "

 data hdrpat/1, 1, NEWLINE, EOS/

 call mailid(user, dummy)
 user(1) = cupper(user(1))
 call gdate(idate)
 call gtime(itime)
 call putlin(hdrpat, int)
 call putlin(dates, int)
 call putlin(idate, int)
 call putch(BLANK, int)
 call putlin(itime, int)
 call putlin(dashst, int)
 call putlin(timzon, int)
 call putch(NEWLINE, int)
 call putlin(froms, int)
 call putlin(user, int)
 call putch(NEWLINE, int)
 call putlin(subjs, int)
 call putlin(subjct, int)
 call putch(NEWLINE, int)
 call dotost(int, user)
 call putch(NEWLINE, int)

 return
 end
#-h- sdmail.q        1069 asc 08-may-80 09:22:58
 subroutine sdmail(buf, file, user)

 character buf(MAXLINE), file(FILENAMESIZE), user(FILENAMESIZE)
 integer inp, int, n, junk, out
 integer open, getlin, lookup, create
 linepointer topfil

 include cmail

 string mymail "mymail"

 call addusr(EOS)
 call malinp(temp2, file, buf, edit)
 inp = open(temp2, READ)
 if (inp == ERR)
    call merror(temp2)
 call markl(inp, topfil)
 int = open(temp1, READ)
 if (int ==  ERR)
    {
    call close(inp)
    call merror(temp1)
    }
 for (n=getlin(buf,int); n != EOF; n=getlin(buf,int))
    {
    buf(n) = EOS
    junk = lookup(buf, file)
    call concat(file, mymail, file)
    call seek(topfil, inp)
    out = create(file, APPEND)
    if (out == ERR)
        {
        call putlin("Cannot send mail to ", ERROUT)
        call remark(buf)
        }
    else
        {
	call fcopy(inp, out)
        call close(out)
        if (regist == YES)
            {
            call putlin("Mail posted to ", ERROUT)
            call remark(buf)
            }
        }
    }
 call close(int)
 call close(inp)
 call cleanf
 return
 end
